/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.containerservice.KeyVaultSecretRef;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.KubernetesVersion;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
@Beta(value=Beta.SinceVersion.V1_4_0)
public interface KubernetesCluster
extends GroupableResource<ContainerServiceManager, ManagedClusterInner>,
Refreshable<KubernetesCluster>,
Updatable<Update>,
OrchestratorServiceBase {
    public String provisioningState();

    public String dnsPrefix();

    public String fqdn();

    public KubernetesVersion version();

    public byte[] adminKubeConfigContent();

    public byte[] userKubeConfigContent();

    public String servicePrincipalClientId();

    public String servicePrincipalSecret();

    public KeyVaultSecretRef keyVaultSecretReference();

    public String linuxRootUsername();

    public String sshKey();

    public Map<String, KubernetesClusterAgentPool> agentPools();

    public static interface UpdateStages {

        public static interface WithUpdateAgentPoolCount {
            public Update withAgentVirtualMachineCount(String var1, int var2);

            public Update withAgentVirtualMachineCount(int var1);
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<KubernetesCluster>,
    UpdateStages.WithUpdateAgentPoolCount {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<KubernetesCluster>,
        WithDnsPrefix,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithDnsPrefix {
            public WithCreate withDnsPrefix(String var1);
        }

        public static interface WithAgentPool {
            public KubernetesClusterAgentPool.DefinitionStages.Blank<WithCreate> defineAgentPool(String var1);
        }

        public static interface WithKeyVaultSecret {
            public WithAgentPool withKeyVaultSecret(String var1);

            public WithAgentPool withKeyVaultSecret(String var1, String var2);
        }

        public static interface WithServicePrincipalProfile {
            public WithAgentPool withServicePrincipalSecret(String var1);

            public WithKeyVaultSecret withKeyVaultReference(String var1);
        }

        public static interface WithServicePrincipalClientId {
            public WithServicePrincipalProfile withServicePrincipalClientId(String var1);
        }

        public static interface WithLinuxSshKey {
            public WithServicePrincipalClientId withSshKey(String var1);
        }

        public static interface WithLinuxRootUsername {
            public WithLinuxSshKey withRootUsername(String var1);
        }

        public static interface WithVersion {
            @Deprecated
            public WithLinuxRootUsername withVersion(KubernetesVersion var1);

            public WithLinuxRootUsername withVersion(String var1);

            @Method
            public WithLinuxRootUsername withLatestVersion();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithVersion> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithVersion,
    DefinitionStages.WithLinuxRootUsername,
    DefinitionStages.WithLinuxSshKey,
    DefinitionStages.WithServicePrincipalClientId,
    DefinitionStages.WithServicePrincipalProfile,
    DefinitionStages.WithKeyVaultSecret,
    DefinitionStages.WithDnsPrefix,
    DefinitionStages.WithAgentPool,
    DefinitionStages.WithCreate {
    }
}

