/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AgentPools.
 */
public class AgentPoolsInner {
    /** The Retrofit service to perform REST calls. */
    private AgentPoolsService service;
    /** The service client containing this operation class. */
    private ContainerServiceManagementClientImpl client;

    /**
     * Initializes an instance of AgentPoolsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AgentPoolsInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = retrofit.create(AgentPoolsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AgentPools to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AgentPoolsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Body AgentPoolInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Body AgentPoolInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools getUpgradeProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}/upgradeProfiles/default")
        Observable<Response<ResponseBody>> getUpgradeProfile(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools getAvailableAgentPoolVersions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}/availableAgentPoolVersions")
        Observable<Response<ResponseBody>> getAvailableAgentPoolVersions(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Path("agentPoolName") String agentPoolName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AgentPoolInner&gt; object if successful.
     */
    public PagedList<AgentPoolInner> list(final String resourceGroupName, final String resourceName) {
        ServiceResponse<Page<AgentPoolInner>> response = listSinglePageAsync(resourceGroupName, resourceName).toBlocking().single();
        return new PagedList<AgentPoolInner>(response.body()) {
            @Override
            public Page<AgentPoolInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AgentPoolInner>> listAsync(final String resourceGroupName, final String resourceName, final ListOperationCallback<AgentPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, resourceName),
            new Func1<String, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AgentPoolInner&gt; object
     */
    public Observable<Page<AgentPoolInner>> listAsync(final String resourceGroupName, final String resourceName) {
        return listWithServiceResponseAsync(resourceGroupName, resourceName)
            .map(new Func1<ServiceResponse<Page<AgentPoolInner>>, Page<AgentPoolInner>>() {
                @Override
                public Page<AgentPoolInner> call(ServiceResponse<Page<AgentPoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AgentPoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<AgentPoolInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String resourceName) {
        return listSinglePageAsync(resourceGroupName, resourceName)
            .concatMap(new Func1<ServiceResponse<Page<AgentPoolInner>>, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(ServiceResponse<Page<AgentPoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
    ServiceResponse<PageImpl<AgentPoolInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<AgentPoolInner>> * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AgentPoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AgentPoolInner>>> listSinglePageAsync(final String resourceGroupName, final String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.list(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AgentPoolInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AgentPoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AgentPoolInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AgentPoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AgentPoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the agent pool.
     * Gets the details of the agent pool by managed cluster and resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AgentPoolInner object if successful.
     */
    public AgentPoolInner get(String resourceGroupName, String resourceName, String agentPoolName) {
        return getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single().body();
    }

    /**
     * Gets the agent pool.
     * Gets the details of the agent pool by managed cluster and resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AgentPoolInner> getAsync(String resourceGroupName, String resourceName, String agentPoolName, final ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    /**
     * Gets the agent pool.
     * Gets the details of the agent pool by managed cluster and resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolInner object
     */
    public Observable<AgentPoolInner> getAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map(new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>() {
            @Override
            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the agent pool.
     * Gets the details of the agent pool by managed cluster and resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolInner object
     */
    public Observable<ServiceResponse<AgentPoolInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolInner>>>() {
                @Override
                public Observable<ServiceResponse<AgentPoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AgentPoolInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AgentPoolInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AgentPoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AgentPoolInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AgentPoolInner object if successful.
     */
    public AgentPoolInner createOrUpdate(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters, final ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).map(new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>() {
            @Override
            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AgentPoolInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AgentPoolInner>() { }.getType());
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AgentPoolInner object if successful.
     */
    public AgentPoolInner beginCreateOrUpdate(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters, final ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolInner object
     */
    public Observable<AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).map(new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>() {
            @Override
            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an agent pool.
     * Creates or updates an agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters Parameters supplied to the Create or Update an agent pool operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolInner object
     */
    public Observable<ServiceResponse<AgentPoolInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolInner>>>() {
                @Override
                public Observable<ServiceResponse<AgentPoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AgentPoolInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AgentPoolInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AgentPoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AgentPoolInner>() { }.getType())
                .register(201, new TypeToken<AgentPoolInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String resourceName, String agentPoolName) {
        deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().last().body();
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String resourceName, String agentPoolName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single().body();
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String agentPoolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an agent pool.
     * Deletes the agent pool in the specified managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets upgrade profile for an agent pool.
     * Gets the details of the upgrade profile for an agent pool with a specified resource group and managed cluster name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AgentPoolUpgradeProfileInner object if successful.
     */
    public AgentPoolUpgradeProfileInner getUpgradeProfile(String resourceGroupName, String resourceName, String agentPoolName) {
        return getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single().body();
    }

    /**
     * Gets upgrade profile for an agent pool.
     * Gets the details of the upgrade profile for an agent pool with a specified resource group and managed cluster name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AgentPoolUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName, String agentPoolName, final ServiceCallback<AgentPoolUpgradeProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    /**
     * Gets upgrade profile for an agent pool.
     * Gets the details of the upgrade profile for an agent pool with a specified resource group and managed cluster name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolUpgradeProfileInner object
     */
    public Observable<AgentPoolUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map(new Func1<ServiceResponse<AgentPoolUpgradeProfileInner>, AgentPoolUpgradeProfileInner>() {
            @Override
            public AgentPoolUpgradeProfileInner call(ServiceResponse<AgentPoolUpgradeProfileInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets upgrade profile for an agent pool.
     * Gets the details of the upgrade profile for an agent pool with a specified resource group and managed cluster name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolUpgradeProfileInner object
     */
    public Observable<ServiceResponse<AgentPoolUpgradeProfileInner>> getUpgradeProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getUpgradeProfile(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolUpgradeProfileInner>>>() {
                @Override
                public Observable<ServiceResponse<AgentPoolUpgradeProfileInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AgentPoolUpgradeProfileInner> clientResponse = getUpgradeProfileDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AgentPoolUpgradeProfileInner> getUpgradeProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AgentPoolUpgradeProfileInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AgentPoolUpgradeProfileInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of supported versions for the specified agent pool.
     * Gets a list of supported versions for the specified agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AgentPoolAvailableVersionsInner object if successful.
     */
    public AgentPoolAvailableVersionsInner getAvailableAgentPoolVersions(String resourceGroupName, String resourceName, String agentPoolName) {
        return getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single().body();
    }

    /**
     * Gets a list of supported versions for the specified agent pool.
     * Gets a list of supported versions for the specified agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsAsync(String resourceGroupName, String resourceName, String agentPoolName, final ServiceCallback<AgentPoolAvailableVersionsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    /**
     * Gets a list of supported versions for the specified agent pool.
     * Gets a list of supported versions for the specified agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolAvailableVersionsInner object
     */
    public Observable<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map(new Func1<ServiceResponse<AgentPoolAvailableVersionsInner>, AgentPoolAvailableVersionsInner>() {
            @Override
            public AgentPoolAvailableVersionsInner call(ServiceResponse<AgentPoolAvailableVersionsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a list of supported versions for the specified agent pool.
     * Gets a list of supported versions for the specified agent pool.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AgentPoolAvailableVersionsInner object
     */
    public Observable<ServiceResponse<AgentPoolAvailableVersionsInner>> getAvailableAgentPoolVersionsWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getAvailableAgentPoolVersions(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolAvailableVersionsInner>>>() {
                @Override
                public Observable<ServiceResponse<AgentPoolAvailableVersionsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AgentPoolAvailableVersionsInner> clientResponse = getAvailableAgentPoolVersionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AgentPoolAvailableVersionsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AgentPoolAvailableVersionsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AgentPoolInner&gt; object if successful.
     */
    public PagedList<AgentPoolInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<AgentPoolInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AgentPoolInner>(response.body()) {
            @Override
            public Page<AgentPoolInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AgentPoolInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<AgentPoolInner>> serviceFuture, final ListOperationCallback<AgentPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AgentPoolInner&gt; object
     */
    public Observable<Page<AgentPoolInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AgentPoolInner>>, Page<AgentPoolInner>>() {
                @Override
                public Page<AgentPoolInner> call(ServiceResponse<Page<AgentPoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AgentPoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<AgentPoolInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AgentPoolInner>>, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(ServiceResponse<Page<AgentPoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * Gets a list of agent pools in the specified managed cluster. The operation returns properties of each agent pool.
     *
    ServiceResponse<PageImpl<AgentPoolInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AgentPoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AgentPoolInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AgentPoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AgentPoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AgentPoolInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AgentPoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AgentPoolInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AgentPoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AgentPoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
