/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerService;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPool;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPoolProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceDiagnosticsProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceLinuxProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceMasterProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceMasterProfileCount;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceServicePrincipalProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceSshConfiguration;
import com.microsoft.azure.management.containerservice.ContainerServiceSshPublicKey;
import com.microsoft.azure.management.containerservice.ContainerServiceStorageProfileTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceVMDiagnostics;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceAgentPoolImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceInner;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ContainerServiceImpl
extends GroupableResourceImpl<ContainerService, ContainerServiceInner, ContainerServiceImpl, ContainerServiceManager>
implements ContainerService,
ContainerService.Definition,
ContainerService.Update {
    private String networkId;
    private String subnetName;

    protected ContainerServiceImpl(String name, ContainerServiceInner innerObject, ContainerServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        if (((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withAgentPoolProfiles(new ArrayList<ContainerServiceAgentPoolProfile>());
        }
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() != null && ((ContainerServiceInner)((Object)this.inner())).masterProfile().vnetSubnetID() != null) {
            this.networkId = ResourceUtils.parentResourceIdFromResourceId((String)((ContainerServiceInner)((Object)this.inner())).masterProfile().vnetSubnetID());
            this.subnetName = ResourceUtils.nameFromResourceId((String)((ContainerServiceInner)((Object)this.inner())).masterProfile().vnetSubnetID());
        } else {
            this.networkId = null;
            this.subnetName = null;
        }
    }

    @Override
    public int masterNodeCount() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null || ((ContainerServiceInner)((Object)this.inner())).masterProfile().count() == null) {
            return 0;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().count();
    }

    @Override
    public ContainerServiceOrchestratorTypes orchestratorType() {
        if (((ContainerServiceInner)((Object)this.inner())).orchestratorProfile() == null) {
            throw new RuntimeException("Orchestrator profile is missing!");
        }
        return ((ContainerServiceInner)((Object)this.inner())).orchestratorProfile().orchestratorType();
    }

    @Override
    public String masterDnsPrefix() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().dnsPrefix();
    }

    @Override
    public String masterFqdn() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().fqdn();
    }

    @Override
    public Map<String, ContainerServiceAgentPool> agentPools() {
        HashMap<String, ContainerServiceAgentPoolImpl> agentPoolMap = new HashMap<String, ContainerServiceAgentPoolImpl>();
        if (((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles() != null && ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ContainerServiceAgentPoolProfile agentPoolProfile : ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles()) {
                agentPoolMap.put(agentPoolProfile.name(), new ContainerServiceAgentPoolImpl(agentPoolProfile, this));
            }
        }
        return Collections.unmodifiableMap(agentPoolMap);
    }

    @Override
    public String linuxRootUsername() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).linuxProfile().adminUsername();
    }

    @Override
    public String sshKey() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile().clientId();
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile().secret();
    }

    @Override
    public int masterOSDiskSizeInGB() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null || ((ContainerServiceInner)((Object)this.inner())).masterProfile().osDiskSizeGB() == null) {
            return 0;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().osDiskSizeGB();
    }

    @Override
    public ContainerServiceStorageProfileTypes masterStorageProfile() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().storageProfile();
    }

    @Override
    public String masterSubnetName() {
        return this.subnetName;
    }

    @Override
    public String networkId() {
        return this.networkId;
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile() == null || ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics() == null) {
            throw new RuntimeException("Diagnostic profile is missing!");
        }
        return ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics().enabled();
    }

    @Override
    public ContainerServiceImpl withMasterNodeCount(ContainerServiceMasterProfileCount profileCount) {
        ContainerServiceMasterProfile masterProfile = new ContainerServiceMasterProfile().withVmSize(ContainerServiceVMSizeTypes.STANDARD_D2_V2);
        masterProfile.withCount(profileCount.count());
        ((ContainerServiceInner)((Object)this.inner())).withMasterProfile(masterProfile);
        return this;
    }

    @Override
    public ContainerServiceImpl withMasterDnsPrefix(String dnsPrefix) {
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withDnsPrefix(dnsPrefix);
        return this;
    }

    public ContainerServiceAgentPoolImpl defineAgentPool(String name) {
        ContainerServiceAgentPoolProfile innerPoolProfile = new ContainerServiceAgentPoolProfile();
        innerPoolProfile.withName(name);
        return new ContainerServiceAgentPoolImpl(innerPoolProfile, this);
    }

    @Override
    public ContainerServiceImpl withDiagnostics() {
        this.withDiagnosticsProfile(true);
        return this;
    }

    @Override
    public ContainerServiceImpl withoutDiagnostics() {
        this.withDiagnosticsProfile(false);
        return this;
    }

    @Override
    public ContainerServiceImpl withLinux() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        return this;
    }

    @Override
    public ContainerServiceImpl withRootUsername(String rootUserName) {
        ((ContainerServiceInner)((Object)this.inner())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public ContainerServiceImpl withSshKey(String sshKeyData) {
        ContainerServiceSshConfiguration ssh = new ContainerServiceSshConfiguration();
        ssh.withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>());
        ContainerServiceSshPublicKey sshPublicKey = new ContainerServiceSshPublicKey();
        sshPublicKey.withKeyData(sshKeyData);
        ssh.publicKeys().add(sshPublicKey);
        ((ContainerServiceInner)((Object)this.inner())).linuxProfile().withSsh(ssh);
        return this;
    }

    @Override
    public ContainerServiceImpl withSwarmOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOrchestratorTypes.SWARM);
        return this;
    }

    @Override
    public ContainerServiceImpl withDcosOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOrchestratorTypes.DCOS);
        return this;
    }

    @Override
    public ContainerServiceImpl withKubernetesOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOrchestratorTypes.KUBERNETES);
        return this;
    }

    @Override
    public ContainerServiceImpl withServicePrincipal(String clientId, String secret) {
        ContainerServiceServicePrincipalProfile serviceProfile = new ContainerServiceServicePrincipalProfile();
        serviceProfile.withClientId(clientId);
        serviceProfile.withSecret(secret);
        ((ContainerServiceInner)((Object)this.inner())).withServicePrincipalProfile(serviceProfile);
        return this;
    }

    private ContainerServiceImpl withOrchestratorProfile(ContainerServiceOrchestratorTypes orchestratorType) {
        ContainerServiceOrchestratorProfile orchestratorProfile = new ContainerServiceOrchestratorProfile();
        orchestratorProfile.withOrchestratorType(orchestratorType);
        ((ContainerServiceInner)((Object)this.inner())).withOrchestratorProfile(orchestratorProfile);
        return this;
    }

    private ContainerServiceImpl withDiagnosticsProfile(boolean enabled) {
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withDiagnosticsProfile(new ContainerServiceDiagnosticsProfile());
        }
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics() == null) {
            ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().withVmDiagnostics(new ContainerServiceVMDiagnostics());
        }
        ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics().withEnabled(enabled);
        return this;
    }

    @Override
    public ContainerServiceImpl withAgentVirtualMachineCount(int agentCount) {
        ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().get(0).withCount(agentCount);
        return this;
    }

    @Override
    public ContainerServiceImpl withMasterVMSize(ContainerServiceVMSizeTypes vmSize) {
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withVmSize(vmSize);
        return this;
    }

    @Override
    public ContainerServiceImpl withMasterStorageProfile(ContainerServiceStorageProfileTypes storageProfile) {
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public ContainerServiceImpl withMasterOSDiskSizeInGB(int osDiskSizeInGB) {
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    @Override
    public ContainerServiceImpl withSubnet(String networkId, String subnetName) {
        this.networkId = networkId;
        this.subnetName = subnetName;
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withVnetSubnetID(networkId + "/subnets/" + subnetName);
        if (((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles() != null) {
            for (ContainerServiceAgentPoolProfile agentPoolProfile : ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles()) {
                String agentPoolSubnet = agentPoolProfile.vnetSubnetID();
                if (agentPoolSubnet == null) {
                    agentPoolProfile.withVnetSubnetID(networkId + "/subnets/" + subnetName);
                    continue;
                }
                agentPoolProfile.withVnetSubnetID(networkId + "/subnets/" + agentPoolSubnet);
            }
        }
        return this;
    }

    protected Observable<ContainerServiceInner> getInnerAsync() {
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).containerServices().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<ContainerService> createResourceAsync() {
        final ContainerServiceImpl self = this;
        if (!this.isInCreateMode()) {
            ((ContainerServiceInner)((Object)this.inner())).withServicePrincipalProfile(null);
        }
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).containerServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ContainerServiceInner)((Object)this.inner())).map((Func1)new Func1<ContainerServiceInner, ContainerService>(){

            public ContainerService call(ContainerServiceInner containerServiceInner) {
                self.setInner((Object)containerServiceInner);
                return self;
            }
        });
    }
}

