/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for Expander.
 */
public final class Expander extends ExpandableStringEnum<Expander> {
    /** Static value least-waste for Expander. */
    public static final Expander LEAST_WASTE = fromString("least-waste");

    /** Static value most-pods for Expander. */
    public static final Expander MOST_PODS = fromString("most-pods");

    /** Static value random for Expander. */
    public static final Expander RANDOM = fromString("random");

    /**
     * Creates or finds a Expander from its string representation.
     * @param name a name to look for
     * @return the corresponding Expander
     */
    @JsonCreator
    public static Expander fromString(String name) {
        return fromString(name, Expander.class);
    }

    /**
     * @return known Expander values
     */
    public static Collection<Expander> values() {
        return values(Expander.class);
    }
}
