/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerservice.AgentPoolMode;
import com.microsoft.azure.management.containerservice.AgentPoolType;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.ManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.OSType;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_4_0)
public interface KubernetesClusterAgentPool
extends ChildResource<OrchestratorServiceBase>,
HasInner<ManagedClusterAgentPoolProfile> {
    public int count();

    public ContainerServiceVMSizeTypes vmSize();

    public int osDiskSizeInGB();

    public OSType osType();

    public AgentPoolType type();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public String subnetName();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public String networkId();

    @Beta(value=Beta.SinceVersion.V1_34_0)
    public AgentPoolMode mode();

    public static interface UpdateStages {

        public static interface WithAgentPoolMode<ParentT> {
            public Update<ParentT> withAgentPoolMode(AgentPoolMode var1);
        }

        public static interface WithAgentPoolVirtualMachineCount<ParentT> {
            public Update<ParentT> withAgentPoolVirtualMachineCount(int var1);
        }
    }

    public static interface Update<ParentT>
    extends Settable<ParentT>,
    UpdateStages.WithAgentPoolVirtualMachineCount<ParentT>,
    UpdateStages.WithAgentPoolMode<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends WithOSType<ParentT>,
        WithOSDiskSize<ParentT>,
        WithAgentPoolType<ParentT>,
        WithAgentPoolVirtualMachineCount<ParentT>,
        WithMaxPodsCount<ParentT>,
        WithVirtualNetwork<ParentT>,
        WithMode<ParentT>,
        Attachable.InDefinition<ParentT> {
        }

        @Beta(value=Beta.SinceVersion.V1_34_0)
        public static interface WithMode<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_34_0)
            public WithAttach<ParentT> withMode(AgentPoolMode var1);
        }

        @Beta(value=Beta.SinceVersion.V1_15_0)
        public static interface WithVirtualNetwork<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public WithAttach<ParentT> withVirtualNetwork(String var1, String var2);
        }

        @Beta(value=Beta.SinceVersion.V1_15_0)
        public static interface WithMaxPodsCount<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public WithAttach<ParentT> withMaxPodsCount(int var1);
        }

        @Beta(value=Beta.SinceVersion.V1_15_0)
        public static interface WithAgentPoolVirtualMachineCount<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public WithAttach<ParentT> withAgentPoolVirtualMachineCount(int var1);
        }

        public static interface WithAgentPoolType<ParentT> {
            public WithAttach<ParentT> withAgentPoolType(AgentPoolType var1);

            public WithAttach<ParentT> withAgentPoolTypeName(String var1);
        }

        public static interface WithOSDiskSize<ParentT> {
            public WithAttach<ParentT> withOSDiskSizeInGB(int var1);
        }

        public static interface WithOSType<ParentT> {
            public WithAttach<ParentT> withOSType(OSType var1);
        }

        @Beta(value=Beta.SinceVersion.V1_15_0)
        public static interface Blank<ParentT> {
            public WithAttach<ParentT> withVirtualMachineSize(ContainerServiceVMSizeTypes var1);
        }
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithOSType<ParentT>,
    DefinitionStages.WithOSDiskSize<ParentT>,
    DefinitionStages.WithAgentPoolType<ParentT>,
    DefinitionStages.WithAgentPoolVirtualMachineCount<ParentT>,
    DefinitionStages.WithMaxPodsCount<ParentT>,
    DefinitionStages.WithVirtualNetwork<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }
}

