/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerServiceLinuxProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceNetworkProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceSshConfiguration;
import com.microsoft.azure.management.containerservice.ContainerServiceSshPublicKey;
import com.microsoft.azure.management.containerservice.KubernetesCluster;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.KubernetesVersion;
import com.microsoft.azure.management.containerservice.ManagedClusterAddonProfile;
import com.microsoft.azure.management.containerservice.ManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.ManagedClusterSKU;
import com.microsoft.azure.management.containerservice.ManagedClusterServicePrincipalProfile;
import com.microsoft.azure.management.containerservice.implementation.AgentPoolInner;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterAgentPoolImpl;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterNetworkProfileImpl;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class KubernetesClusterImpl
extends GroupableResourceImpl<KubernetesCluster, ManagedClusterInner, KubernetesClusterImpl, ContainerServiceManager>
implements KubernetesCluster,
KubernetesCluster.Definition,
KubernetesCluster.Update {
    private byte[] adminKubeConfigContent;
    private byte[] userKubeConfigContent;

    protected KubernetesClusterImpl(String name, ManagedClusterInner innerObject, ContainerServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() == null) {
            ((ManagedClusterInner)((Object)this.inner())).withAgentPoolProfiles(new ArrayList<ManagedClusterAgentPoolProfile>());
        }
        this.adminKubeConfigContent = null;
        this.userKubeConfigContent = null;
    }

    @Override
    public String provisioningState() {
        return ((ManagedClusterInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String dnsPrefix() {
        return ((ManagedClusterInner)((Object)this.inner())).dnsPrefix();
    }

    @Override
    public String fqdn() {
        return ((ManagedClusterInner)((Object)this.inner())).fqdn();
    }

    @Override
    public ManagedClusterSKU sku() {
        return ((ManagedClusterInner)((Object)this.inner())).sku();
    }

    @Override
    public KubernetesVersion version() {
        return KubernetesVersion.fromString(((ManagedClusterInner)((Object)this.inner())).kubernetesVersion());
    }

    @Override
    public byte[] adminKubeConfigContent() {
        if (this.adminKubeConfigContent == null) {
            this.adminKubeConfigContent = ((ContainerServiceManager)this.manager()).kubernetesClusters().getAdminKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return this.adminKubeConfigContent;
    }

    @Override
    public byte[] userKubeConfigContent() {
        if (this.userKubeConfigContent == null) {
            this.userKubeConfigContent = ((ContainerServiceManager)this.manager()).kubernetesClusters().getUserKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return this.userKubeConfigContent;
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().clientId();
        }
        return null;
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().secret();
        }
        return null;
    }

    @Override
    public String linuxRootUsername() {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).linuxProfile().adminUsername();
        }
        return null;
    }

    @Override
    public String sshKey() {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public Map<String, KubernetesClusterAgentPool> agentPools() {
        HashMap<String, KubernetesClusterAgentPoolImpl> agentPoolMap = new HashMap<String, KubernetesClusterAgentPoolImpl>();
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                agentPoolMap.put(agentPoolProfile.name(), new KubernetesClusterAgentPoolImpl(agentPoolProfile, this));
            }
        }
        return Collections.unmodifiableMap(agentPoolMap);
    }

    @Override
    public ContainerServiceNetworkProfile networkProfile() {
        return ((ManagedClusterInner)((Object)this.inner())).networkProfile();
    }

    @Override
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return Collections.unmodifiableMap(((ManagedClusterInner)((Object)this.inner())).addonProfiles());
    }

    @Override
    public String nodeResourceGroup() {
        return ((ManagedClusterInner)((Object)this.inner())).nodeResourceGroup();
    }

    @Override
    public boolean enableRBAC() {
        return ((ManagedClusterInner)((Object)this.inner())).enableRBAC();
    }

    private Observable<byte[]> getAdminConfig(final KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().getAdminKubeConfigContentAsync(self.resourceGroupName(), self.name()).map((Func1)new Func1<byte[], byte[]>(){

            public byte[] call(byte[] kubeConfigContent) {
                KubernetesClusterImpl.access$002(self, kubeConfigContent);
                return self.adminKubeConfigContent;
            }
        });
    }

    private Observable<byte[]> getUserConfig(final KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().getUserKubeConfigContentAsync(self.resourceGroupName(), self.name()).map((Func1)new Func1<byte[], byte[]>(){

            public byte[] call(byte[] kubeConfigContent) {
                KubernetesClusterImpl.access$102(self, kubeConfigContent);
                return self.userKubeConfigContent;
            }
        });
    }

    protected Observable<ManagedClusterInner> getInnerAsync() {
        KubernetesClusterImpl self = this;
        final Observable<byte[]> adminConfig = this.getAdminConfig(self);
        final Observable<byte[]> userConfig = this.getUserConfig(self);
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().getByResourceGroupAsync(this.resourceGroupName(), this.name()).flatMap((Func1)new Func1<ManagedClusterInner, Observable<ManagedClusterInner>>(){

            public Observable<ManagedClusterInner> call(final ManagedClusterInner managedClusterInner) {
                return Observable.merge((Observable)adminConfig, (Observable)userConfig).last().map((Func1)new Func1<byte[], ManagedClusterInner>(){

                    public ManagedClusterInner call(byte[] bytes) {
                        return managedClusterInner;
                    }
                });
            }
        });
    }

    public Observable<KubernetesCluster> createResourceAsync() {
        final KubernetesClusterImpl self = this;
        if (!this.isInCreateMode()) {
            ((ManagedClusterInner)((Object)this.inner())).withServicePrincipalProfile(null);
        }
        Observable<byte[]> adminConfig = this.getAdminConfig(self);
        Observable<byte[]> userConfig = this.getUserConfig(self);
        final Observable mergedConfigs = Observable.merge(adminConfig, userConfig).last().map((Func1)new Func1<byte[], KubernetesCluster>(){

            public KubernetesCluster call(byte[] bytes) {
                return self;
            }
        });
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ManagedClusterInner)((Object)self.inner())).map((Func1)new Func1<ManagedClusterInner, KubernetesCluster>(){

            public KubernetesCluster call(ManagedClusterInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        }).flatMap((Func1)new Func1<KubernetesCluster, Observable<KubernetesCluster>>(){

            public Observable<KubernetesCluster> call(KubernetesCluster kubernetesCluster) {
                return mergedConfigs;
            }
        });
    }

    @Override
    public KubernetesClusterImpl withVersion(KubernetesVersion kubernetesVersion) {
        ((ManagedClusterInner)((Object)this.inner())).withKubernetesVersion(kubernetesVersion.toString());
        return this;
    }

    @Override
    public KubernetesClusterImpl withVersion(String kubernetesVersion) {
        ((ManagedClusterInner)((Object)this.inner())).withKubernetesVersion(kubernetesVersion);
        return this;
    }

    @Override
    public KubernetesClusterImpl withLatestVersion() {
        ((ManagedClusterInner)((Object)this.inner())).withKubernetesVersion("");
        return this;
    }

    @Override
    public KubernetesClusterImpl withRootUsername(String rootUserName) {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() == null) {
            ((ManagedClusterInner)((Object)this.inner())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public KubernetesClusterImpl withSshKey(String sshKeyData) {
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().withSsh(new ContainerServiceSshConfiguration().withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>()));
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().add(new ContainerServiceSshPublicKey().withKeyData(sshKeyData));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalClientId(String clientId) {
        ((ManagedClusterInner)((Object)this.inner())).withServicePrincipalProfile(new ManagedClusterServicePrincipalProfile().withClientId(clientId));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalSecret(String secret) {
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().withSecret(secret);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDnsPrefix(String dnsPrefix) {
        ((ManagedClusterInner)((Object)this.inner())).withDnsPrefix(dnsPrefix);
        return this;
    }

    public KubernetesClusterAgentPoolImpl defineAgentPool(String name) {
        ManagedClusterAgentPoolProfile innerPoolProfile = new ManagedClusterAgentPoolProfile();
        innerPoolProfile.withName(name);
        return new KubernetesClusterAgentPoolImpl(innerPoolProfile, this);
    }

    @Override
    public KubernetesClusterImpl withAgentPoolVirtualMachineCount(String agentPoolName, int agentCount) {
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                if (!agentPoolProfile.name().equals(agentPoolName)) continue;
                agentPoolProfile.withCount(agentCount);
                break;
            }
        }
        return this;
    }

    @Override
    public KubernetesClusterImpl withAgentPoolVirtualMachineCount(int agentCount) {
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                agentPoolProfile.withCount(agentCount);
            }
        }
        return this;
    }

    public KubernetesClusterAgentPoolImpl updateAgentPool(String name) {
        for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
            if (!agentPoolProfile.name().equals(name)) continue;
            return new KubernetesClusterAgentPoolImpl(agentPoolProfile, this);
        }
        throw new IllegalArgumentException(String.format("Cannot get agent pool named %s", name));
    }

    @Override
    public KubernetesCluster.DefinitionStages.NetworkProfileDefinitionStages.Blank<KubernetesCluster.DefinitionStages.WithCreate> defineNetworkProfile() {
        return new KubernetesClusterNetworkProfileImpl(this);
    }

    @Override
    public KubernetesClusterImpl withAddOnProfiles(Map<String, ManagedClusterAddonProfile> addOnProfileMap) {
        ((ManagedClusterInner)((Object)this.inner())).withAddonProfiles(addOnProfileMap);
        return this;
    }

    @Override
    public KubernetesClusterImpl withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        ((ManagedClusterInner)((Object)this.inner())).withNetworkProfile(networkProfile);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACEnabled() {
        ((ManagedClusterInner)((Object)this.inner())).withEnableRBAC(true);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACDisabled() {
        ((ManagedClusterInner)((Object)this.inner())).withEnableRBAC(false);
        return this;
    }

    @Override
    public KubernetesCluster.DefinitionStages.WithCreate withSku(ManagedClusterSKU sku) {
        ((ManagedClusterInner)((Object)this.inner())).withSku(sku);
        return this;
    }

    KubernetesClusterImpl addNewAgentPool(final KubernetesClusterAgentPoolImpl agentPool) {
        if (!this.isInCreateMode()) {
            this.addDependency(new FunctionalTaskItem(){

                public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                    return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)KubernetesClusterImpl.this.manager()).inner())).agentPools().createOrUpdateAsync(KubernetesClusterImpl.this.resourceGroupName(), KubernetesClusterImpl.this.name(), agentPool.name(), agentPool.getAgentPoolInner()).flatMap((Func1)new Func1<AgentPoolInner, Observable<Indexable>>(){

                        public Observable<Indexable> call(AgentPoolInner agentPoolInner) {
                            return context.voidObservable();
                        }
                    });
                }
            });
        }
        ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().add((ManagedClusterAgentPoolProfile)agentPool.inner());
        return this;
    }

    static /* synthetic */ byte[] access$002(KubernetesClusterImpl x0, byte[] x1) {
        x0.adminKubeConfigContent = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(KubernetesClusterImpl x0, byte[] x1) {
        x0.userKubeConfigContent = x1;
        return x1;
    }
}

