/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for Code.
 */
public final class Code extends ExpandableStringEnum<Code> {
    /** Static value Running for Code. */
    public static final Code RUNNING = fromString("Running");

    /** Static value Stopped for Code. */
    public static final Code STOPPED = fromString("Stopped");

    /**
     * Creates or finds a Code from its string representation.
     * @param name a name to look for
     * @return the corresponding Code
     */
    @JsonCreator
    public static Code fromString(String name) {
        return fromString(name, Code.class);
    }

    /**
     * @return known Code values
     */
    public static Collection<Code> values() {
        return values(Code.class);
    }
}
