/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ManagedClusterSKU model.
 */
public class ManagedClusterSKU {
    /**
     * Name of a managed cluster SKU. Possible values include: 'Basic'.
     */
    @JsonProperty(value = "name")
    private ManagedClusterSKUName name;

    /**
     * Tier of a managed cluster SKU. Possible values include: 'Paid', 'Free'.
     */
    @JsonProperty(value = "tier")
    private ManagedClusterSKUTier tier;

    /**
     * Get name of a managed cluster SKU. Possible values include: 'Basic'.
     *
     * @return the name value
     */
    public ManagedClusterSKUName name() {
        return this.name;
    }

    /**
     * Set name of a managed cluster SKU. Possible values include: 'Basic'.
     *
     * @param name the name value to set
     * @return the ManagedClusterSKU object itself.
     */
    public ManagedClusterSKU withName(ManagedClusterSKUName name) {
        this.name = name;
        return this;
    }

    /**
     * Get tier of a managed cluster SKU. Possible values include: 'Paid', 'Free'.
     *
     * @return the tier value
     */
    public ManagedClusterSKUTier tier() {
        return this.tier;
    }

    /**
     * Set tier of a managed cluster SKU. Possible values include: 'Paid', 'Free'.
     *
     * @param tier the tier value to set
     * @return the ManagedClusterSKU object itself.
     */
    public ManagedClusterSKU withTier(ManagedClusterSKUTier tier) {
        this.tier = tier;
        return this;
    }

}
