/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Profile for Windows VMs in the container service cluster.
 */
public class ManagedClusterWindowsProfile {
    /**
     * Specifies the name of the administrator account. &lt;br&gt;&lt;br&gt;
     * **restriction:** Cannot end in "." &lt;br&gt;&lt;br&gt; **Disallowed
     * values:** "administrator", "admin", "user", "user1", "test", "user2",
     * "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     * "aspnet", "backup", "console", "david", "guest", "john", "owner",
     * "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     * "test3", "user4", "user5". &lt;br&gt;&lt;br&gt; **Minimum-length:** 1
     * character &lt;br&gt;&lt;br&gt; **Max-length:** 20 characters.
     */
    @JsonProperty(value = "adminUsername", required = true)
    private String adminUsername;

    /**
     * Specifies the password of the administrator account.
     * &lt;br&gt;&lt;br&gt; **Minimum-length:** 8 characters
     * &lt;br&gt;&lt;br&gt; **Max-length:** 123 characters &lt;br&gt;&lt;br&gt;
     * **Complexity requirements:** 3 out of 4 conditions below need to be
     * fulfilled &lt;br&gt; Has lower characters &lt;br&gt;Has upper characters
     * &lt;br&gt; Has a digit &lt;br&gt; Has a special character (Regex match
     * [\W_]) &lt;br&gt;&lt;br&gt; **Disallowed values:** "abc@123",
     * "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1",
     * "Password!", "Password1", "Password22", "iloveyou!".
     */
    @JsonProperty(value = "adminPassword")
    private String adminPassword;

    /**
     * The licenseType to use for Windows VMs. Windows_Server is used to enable
     * Azure Hybrid User Benefits for Windows VMs. Possible values include:
     * 'None', 'Windows_Server'.
     */
    @JsonProperty(value = "licenseType")
    private LicenseType licenseType;

    /**
     * Get specifies the name of the administrator account. &lt;br&gt;&lt;br&gt; **restriction:** Cannot end in "." &lt;br&gt;&lt;br&gt; **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". &lt;br&gt;&lt;br&gt; **Minimum-length:** 1 character &lt;br&gt;&lt;br&gt; **Max-length:** 20 characters.
     *
     * @return the adminUsername value
     */
    public String adminUsername() {
        return this.adminUsername;
    }

    /**
     * Set specifies the name of the administrator account. &lt;br&gt;&lt;br&gt; **restriction:** Cannot end in "." &lt;br&gt;&lt;br&gt; **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". &lt;br&gt;&lt;br&gt; **Minimum-length:** 1 character &lt;br&gt;&lt;br&gt; **Max-length:** 20 characters.
     *
     * @param adminUsername the adminUsername value to set
     * @return the ManagedClusterWindowsProfile object itself.
     */
    public ManagedClusterWindowsProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    /**
     * Get specifies the password of the administrator account. &lt;br&gt;&lt;br&gt; **Minimum-length:** 8 characters &lt;br&gt;&lt;br&gt; **Max-length:** 123 characters &lt;br&gt;&lt;br&gt; **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled &lt;br&gt; Has lower characters &lt;br&gt;Has upper characters &lt;br&gt; Has a digit &lt;br&gt; Has a special character (Regex match [\W_]) &lt;br&gt;&lt;br&gt; **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
     *
     * @return the adminPassword value
     */
    public String adminPassword() {
        return this.adminPassword;
    }

    /**
     * Set specifies the password of the administrator account. &lt;br&gt;&lt;br&gt; **Minimum-length:** 8 characters &lt;br&gt;&lt;br&gt; **Max-length:** 123 characters &lt;br&gt;&lt;br&gt; **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled &lt;br&gt; Has lower characters &lt;br&gt;Has upper characters &lt;br&gt; Has a digit &lt;br&gt; Has a special character (Regex match [\W_]) &lt;br&gt;&lt;br&gt; **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
     *
     * @param adminPassword the adminPassword value to set
     * @return the ManagedClusterWindowsProfile object itself.
     */
    public ManagedClusterWindowsProfile withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    /**
     * Get the licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'.
     *
     * @return the licenseType value
     */
    public LicenseType licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'.
     *
     * @param licenseType the licenseType value to set
     * @return the ManagedClusterWindowsProfile object itself.
     */
    public ManagedClusterWindowsProfile withLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

}
