/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The UserAssignedIdentity model.
 */
public class UserAssignedIdentity {
    /**
     * The resource id of the user assigned identity.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /**
     * The client id of the user assigned identity.
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /**
     * The object id of the user assigned identity.
     */
    @JsonProperty(value = "objectId")
    private String objectId;

    /**
     * Get the resource id of the user assigned identity.
     *
     * @return the resourceId value
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resource id of the user assigned identity.
     *
     * @param resourceId the resourceId value to set
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the client id of the user assigned identity.
     *
     * @return the clientId value
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the client id of the user assigned identity.
     *
     * @param clientId the clientId value to set
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the object id of the user assigned identity.
     *
     * @return the objectId value
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the object id of the user assigned identity.
     *
     * @param objectId the objectId value to set
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

}
