/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.management.containerservice.PurchasePlan;
import com.microsoft.azure.management.containerservice.NetworkProfile;
import java.util.List;
import com.microsoft.azure.management.containerservice.OpenShiftRouterProfile;
import com.microsoft.azure.management.containerservice.OpenShiftManagedClusterMasterPoolProfile;
import com.microsoft.azure.management.containerservice.OpenShiftManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.OpenShiftManagedClusterAuthProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * OpenShift Managed cluster.
 */
@JsonFlatten
public class OpenShiftManagedClusterInner extends Resource {
    /**
     * Define the resource plan as required by ARM for billing purposes.
     */
    @JsonProperty(value = "plan")
    private PurchasePlan plan;

    /**
     * The current deployment or provisioning state, which only appears in the
     * response.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * Version of OpenShift specified when creating the cluster.
     */
    @JsonProperty(value = "properties.openShiftVersion", required = true)
    private String openShiftVersion;

    /**
     * Version of OpenShift specified when creating the cluster.
     */
    @JsonProperty(value = "properties.clusterVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String clusterVersion;

    /**
     * Service generated FQDN for OpenShift API server.
     */
    @JsonProperty(value = "properties.publicHostname", access = JsonProperty.Access.WRITE_ONLY)
    private String publicHostname;

    /**
     * Service generated FQDN for OpenShift API server loadbalancer internal
     * hostname.
     */
    @JsonProperty(value = "properties.fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /**
     * Configuration for OpenShift networking.
     */
    @JsonProperty(value = "properties.networkProfile")
    private NetworkProfile networkProfile;

    /**
     * Configuration for OpenShift router(s).
     */
    @JsonProperty(value = "properties.routerProfiles")
    private List<OpenShiftRouterProfile> routerProfiles;

    /**
     * Configuration for OpenShift master VMs.
     */
    @JsonProperty(value = "properties.masterPoolProfile")
    private OpenShiftManagedClusterMasterPoolProfile masterPoolProfile;

    /**
     * Configuration of OpenShift cluster VMs.
     */
    @JsonProperty(value = "properties.agentPoolProfiles")
    private List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles;

    /**
     * Configures OpenShift authentication.
     */
    @JsonProperty(value = "properties.authProfile")
    private OpenShiftManagedClusterAuthProfile authProfile;

    /**
     * Get define the resource plan as required by ARM for billing purposes.
     *
     * @return the plan value
     */
    public PurchasePlan plan() {
        return this.plan;
    }

    /**
     * Set define the resource plan as required by ARM for billing purposes.
     *
     * @param plan the plan value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    /**
     * Get the current deployment or provisioning state, which only appears in the response.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get version of OpenShift specified when creating the cluster.
     *
     * @return the openShiftVersion value
     */
    public String openShiftVersion() {
        return this.openShiftVersion;
    }

    /**
     * Set version of OpenShift specified when creating the cluster.
     *
     * @param openShiftVersion the openShiftVersion value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withOpenShiftVersion(String openShiftVersion) {
        this.openShiftVersion = openShiftVersion;
        return this;
    }

    /**
     * Get version of OpenShift specified when creating the cluster.
     *
     * @return the clusterVersion value
     */
    public String clusterVersion() {
        return this.clusterVersion;
    }

    /**
     * Get service generated FQDN for OpenShift API server.
     *
     * @return the publicHostname value
     */
    public String publicHostname() {
        return this.publicHostname;
    }

    /**
     * Get service generated FQDN for OpenShift API server loadbalancer internal hostname.
     *
     * @return the fqdn value
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get configuration for OpenShift networking.
     *
     * @return the networkProfile value
     */
    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set configuration for OpenShift networking.
     *
     * @param networkProfile the networkProfile value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get configuration for OpenShift router(s).
     *
     * @return the routerProfiles value
     */
    public List<OpenShiftRouterProfile> routerProfiles() {
        return this.routerProfiles;
    }

    /**
     * Set configuration for OpenShift router(s).
     *
     * @param routerProfiles the routerProfiles value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withRouterProfiles(List<OpenShiftRouterProfile> routerProfiles) {
        this.routerProfiles = routerProfiles;
        return this;
    }

    /**
     * Get configuration for OpenShift master VMs.
     *
     * @return the masterPoolProfile value
     */
    public OpenShiftManagedClusterMasterPoolProfile masterPoolProfile() {
        return this.masterPoolProfile;
    }

    /**
     * Set configuration for OpenShift master VMs.
     *
     * @param masterPoolProfile the masterPoolProfile value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withMasterPoolProfile(OpenShiftManagedClusterMasterPoolProfile masterPoolProfile) {
        this.masterPoolProfile = masterPoolProfile;
        return this;
    }

    /**
     * Get configuration of OpenShift cluster VMs.
     *
     * @return the agentPoolProfiles value
     */
    public List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set configuration of OpenShift cluster VMs.
     *
     * @param agentPoolProfiles the agentPoolProfiles value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withAgentPoolProfiles(List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get configures OpenShift authentication.
     *
     * @return the authProfile value
     */
    public OpenShiftManagedClusterAuthProfile authProfile() {
        return this.authProfile;
    }

    /**
     * Set configures OpenShift authentication.
     *
     * @param authProfile the authProfile value to set
     * @return the OpenShiftManagedClusterInner object itself.
     */
    public OpenShiftManagedClusterInner withAuthProfile(OpenShiftManagedClusterAuthProfile authProfile) {
        this.authProfile = authProfile;
        return this;
    }

}
