/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.containerservice.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in OpenShiftManagedClusters.
 */
public class OpenShiftManagedClustersInner implements InnerSupportsGet<OpenShiftManagedClusterInner>, InnerSupportsDelete<Void>, InnerSupportsListing<OpenShiftManagedClusterInner> {
    /** The Retrofit service to perform REST calls. */
    private OpenShiftManagedClustersService service;
    /** The service client containing this operation class. */
    private ContainerServiceManagementClientImpl client;

    /**
     * Initializes an instance of OpenShiftManagedClustersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public OpenShiftManagedClustersInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = retrofit.create(OpenShiftManagedClustersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for OpenShiftManagedClusters to be
     * used by Retrofit to perform actually REST calls.
     */
    interface OpenShiftManagedClustersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Body OpenShiftManagedClusterInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Body OpenShiftManagedClusterInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginUpdateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}")
        Observable<Response<ResponseBody>> beginUpdateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("resourceName") String resourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.OpenShiftManagedClusters listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object if successful.
     */
    public PagedList<OpenShiftManagedClusterInner> list() {
        ServiceResponse<Page<OpenShiftManagedClusterInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>(response.body()) {
            @Override
            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OpenShiftManagedClusterInner>> listAsync(final ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<Page<OpenShiftManagedClusterInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>() {
                @Override
                public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OpenShiftManagedClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OpenShiftManagedClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object if successful.
     */
    public PagedList<OpenShiftManagedClusterInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<OpenShiftManagedClusterInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>(response.body()) {
            @Override
            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OpenShiftManagedClusterInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<Page<OpenShiftManagedClusterInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>() {
                @Override
                public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
    ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OpenShiftManagedClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OpenShiftManagedClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a OpenShift managed cluster.
     * Gets the details of the managed OpenShift cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single().body();
    }

    /**
     * Gets a OpenShift managed cluster.
     * Gets the details of the managed OpenShift cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Gets a OpenShift managed cluster.
     * Gets the details of the managed OpenShift cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<OpenShiftManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a OpenShift managed cluster.
     * Gets the details of the managed OpenShift cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OpenShiftManagedClusterInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OpenShiftManagedClusterInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OpenShiftManagedClusterInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OpenShiftManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-04-30";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>() { }.getType());
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner beginCreateOrUpdate(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<OpenShiftManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an OpenShift managed cluster.
     * Creates or updates a OpenShift managed cluster with the specified configuration for agents and OpenShift version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param parameters Parameters supplied to the Create or Update an OpenShift Managed Cluster operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, OpenShiftManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-04-30";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OpenShiftManagedClusterInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OpenShiftManagedClusterInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OpenShiftManagedClusterInner>() { }.getType())
                .register(201, new TypeToken<OpenShiftManagedClusterInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last().body();
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>() { }.getType());
    }
    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner updateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().last().body();
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OpenShiftManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-04-30";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OpenShiftManagedClusterInner>() { }.getType());
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single().body();
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        final Map<String, String> tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OpenShiftManagedClusterInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OpenShiftManagedClusterInner object if successful.
     */
    public OpenShiftManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().single().body();
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, final ServiceCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<OpenShiftManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map(new Func1<ServiceResponse<OpenShiftManagedClusterInner>, OpenShiftManagedClusterInner>() {
            @Override
            public OpenShiftManagedClusterInner call(ServiceResponse<OpenShiftManagedClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates tags on an OpenShift managed cluster.
     * Updates an OpenShift managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OpenShiftManagedClusterInner object
     */
    public Observable<ServiceResponse<OpenShiftManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-04-30";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OpenShiftManagedClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<OpenShiftManagedClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OpenShiftManagedClusterInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OpenShiftManagedClusterInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OpenShiftManagedClusterInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OpenShiftManagedClusterInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String resourceName) {
        deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last().body();
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String resourceName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single().body();
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an OpenShift managed cluster.
     * Deletes the OpenShift managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        final String apiVersion = "2019-04-30";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object if successful.
     */
    public PagedList<OpenShiftManagedClusterInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<OpenShiftManagedClusterInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>(response.body()) {
            @Override
            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OpenShiftManagedClusterInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<OpenShiftManagedClusterInner>> serviceFuture, final ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<Page<OpenShiftManagedClusterInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>() {
                @Override
                public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of OpenShift managed clusters in the specified subscription.
     * Gets a list of OpenShift managed clusters in the specified subscription. The operation returns properties of each OpenShift managed cluster.
     *
    ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OpenShiftManagedClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OpenShiftManagedClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object if successful.
     */
    public PagedList<OpenShiftManagedClusterInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<OpenShiftManagedClusterInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OpenShiftManagedClusterInner>(response.body()) {
            @Override
            public Page<OpenShiftManagedClusterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OpenShiftManagedClusterInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<OpenShiftManagedClusterInner>> serviceFuture, final ListOperationCallback<OpenShiftManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<Page<OpenShiftManagedClusterInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Page<OpenShiftManagedClusterInner>>() {
                @Override
                public Page<OpenShiftManagedClusterInner> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OpenShiftManagedClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<OpenShiftManagedClusterInner>>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(ServiceResponse<Page<OpenShiftManagedClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists OpenShift managed clusters in the specified subscription and resource group.
     * Lists OpenShift managed clusters in the specified subscription and resource group. The operation returns properties of each OpenShift managed cluster.
     *
    ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OpenShiftManagedClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OpenShiftManagedClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OpenShiftManagedClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OpenShiftManagedClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OpenShiftManagedClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OpenShiftManagedClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
