/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.PrivateLinkResourcesListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PrivateLinkResourcesInner {
    private PrivateLinkResourcesService service;
    private ContainerServiceManagementClientImpl client;

    public PrivateLinkResourcesInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (PrivateLinkResourcesService)retrofit.create(PrivateLinkResourcesService.class);
        this.client = client;
    }

    public PrivateLinkResourcesListResultInner list(String resourceGroupName, String resourceName) {
        return (PrivateLinkResourcesListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkResourcesListResultInner> listAsync(String resourceGroupName, String resourceName, ServiceCallback<PrivateLinkResourcesListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<PrivateLinkResourcesListResultInner> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<PrivateLinkResourcesListResultInner>, PrivateLinkResourcesListResultInner>(){

            public PrivateLinkResourcesListResultInner call(ServiceResponse<PrivateLinkResourcesListResultInner> response) {
                return (PrivateLinkResourcesListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourcesListResultInner>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourcesListResultInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourcesListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkResourcesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourcesListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourcesListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateLinkResources list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateLinkResources")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

