/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPoolProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceLinuxProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceServicePrincipalProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceSshConfiguration;
import com.microsoft.azure.management.containerservice.ContainerServiceSshPublicKey;
import com.microsoft.azure.management.containerservice.KeyVaultSecretRef;
import com.microsoft.azure.management.containerservice.KubernetesCluster;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.KubernetesVersion;
import com.microsoft.azure.management.containerservice.OrchestratorVersionProfile;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterAgentPoolImpl;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.containerservice.implementation.OrchestratorVersionProfileListResultInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import rx.Observable;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class KubernetesClusterImpl
extends GroupableResourceImpl<KubernetesCluster, ManagedClusterInner, KubernetesClusterImpl, ContainerServiceManager>
implements KubernetesCluster,
KubernetesCluster.Definition,
KubernetesCluster.Update {
    private boolean useLatestVersion;
    private byte[] adminKubeConfigContent;
    private byte[] userKubeConfigContent;

    protected KubernetesClusterImpl(String name, ManagedClusterInner innerObject, ContainerServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() == null) {
            ((ManagedClusterInner)((Object)this.inner())).withAgentPoolProfiles(new ArrayList<ContainerServiceAgentPoolProfile>());
        }
        this.useLatestVersion = false;
        this.adminKubeConfigContent = null;
        this.userKubeConfigContent = null;
    }

    @Override
    public String provisioningState() {
        return ((ManagedClusterInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String dnsPrefix() {
        return ((ManagedClusterInner)((Object)this.inner())).dnsPrefix();
    }

    @Override
    public String fqdn() {
        return ((ManagedClusterInner)((Object)this.inner())).fqdn();
    }

    @Override
    public KubernetesVersion version() {
        return KubernetesVersion.fromString(((ManagedClusterInner)((Object)this.inner())).kubernetesVersion());
    }

    @Override
    public byte[] adminKubeConfigContent() {
        if (this.adminKubeConfigContent == null) {
            this.adminKubeConfigContent = ((ContainerServiceManager)this.manager()).kubernetesClusters().getAdminKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return this.adminKubeConfigContent;
    }

    @Override
    public byte[] userKubeConfigContent() {
        if (this.userKubeConfigContent == null) {
            this.userKubeConfigContent = ((ContainerServiceManager)this.manager()).kubernetesClusters().getUserKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return this.userKubeConfigContent;
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().clientId();
        }
        return null;
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().secret();
        }
        return null;
    }

    @Override
    public KeyVaultSecretRef keyVaultSecretReference() {
        if (((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().keyVaultSecretRef();
        }
        return null;
    }

    @Override
    public String linuxRootUsername() {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() != null) {
            return ((ManagedClusterInner)((Object)this.inner())).linuxProfile().adminUsername();
        }
        return null;
    }

    @Override
    public String sshKey() {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys() == null || ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public Map<String, KubernetesClusterAgentPool> agentPools() {
        HashMap<String, KubernetesClusterAgentPoolImpl> agentPoolMap = new HashMap<String, KubernetesClusterAgentPoolImpl>();
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ContainerServiceAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                agentPoolMap.put(agentPoolProfile.name(), new KubernetesClusterAgentPoolImpl(agentPoolProfile, this));
            }
        }
        return Collections.unmodifiableMap(agentPoolMap);
    }

    private Observable<byte[]> getAdminConfig(final KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().getAdminKubeConfigContentAsync(self.resourceGroupName(), self.name()).map((Func1)new Func1<byte[], byte[]>(){

            public byte[] call(byte[] kubeConfigContent) {
                KubernetesClusterImpl.access$002(self, kubeConfigContent);
                return self.adminKubeConfigContent;
            }
        });
    }

    private Observable<byte[]> getUserConfig(final KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().getUserKubeConfigContentAsync(self.resourceGroupName(), self.name()).map((Func1)new Func1<byte[], byte[]>(){

            public byte[] call(byte[] kubeConfigContent) {
                KubernetesClusterImpl.access$102(self, kubeConfigContent);
                return self.userKubeConfigContent;
            }
        });
    }

    protected Observable<ManagedClusterInner> getInnerAsync() {
        KubernetesClusterImpl self = this;
        final Observable<byte[]> adminConfig = this.getAdminConfig(self);
        final Observable<byte[]> userConfig = this.getUserConfig(self);
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().getByResourceGroupAsync(this.resourceGroupName(), this.name()).flatMap((Func1)new Func1<ManagedClusterInner, Observable<ManagedClusterInner>>(){

            public Observable<ManagedClusterInner> call(final ManagedClusterInner managedClusterInner) {
                return Observable.merge((Observable)adminConfig, (Observable)userConfig).last().map((Func1)new Func1<byte[], ManagedClusterInner>(){

                    public ManagedClusterInner call(byte[] bytes) {
                        return managedClusterInner;
                    }
                });
            }
        });
    }

    public Observable<KubernetesCluster> createResourceAsync() {
        final KubernetesClusterImpl self = this;
        if (!this.isInCreateMode()) {
            ((ManagedClusterInner)((Object)this.inner())).withServicePrincipalProfile(null);
        }
        Observable<byte[]> adminConfig = this.getAdminConfig(self);
        Observable<byte[]> userConfig = this.getUserConfig(self);
        final Observable mergedConfigs = Observable.merge(adminConfig, userConfig).last().map((Func1)new Func1<byte[], KubernetesCluster>(){

            public KubernetesCluster call(byte[] bytes) {
                return self;
            }
        });
        if (this.useLatestVersion) {
            return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).containerServices().listOrchestratorsAsync(((ManagedClusterInner)((Object)self.inner())).location()).collect((Func0)new Func0<TreeSet<String>>(){

                public TreeSet<String> call() {
                    return new TreeSet<String>();
                }
            }, (Action2)new Action2<TreeSet<String>, OrchestratorVersionProfileListResultInner>(){

                public void call(TreeSet<String> kubernetesVersions, OrchestratorVersionProfileListResultInner inner) {
                    if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
                        for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                            if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                            kubernetesVersions.add(orchestrator.orchestratorVersion());
                        }
                    }
                }
            }).last().flatMap((Func1)new Func1<TreeSet<String>, Observable<KubernetesCluster>>(){

                public Observable<KubernetesCluster> call(TreeSet<String> kubernetesVersions) {
                    ((ManagedClusterInner)((Object)self.inner())).withKubernetesVersion(kubernetesVersions.last());
                    return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)self.manager()).inner())).managedClusters().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ManagedClusterInner)((Object)self.inner())).map((Func1)new Func1<ManagedClusterInner, KubernetesCluster>(){

                        public KubernetesCluster call(ManagedClusterInner inner) {
                            self.setInner((Object)inner);
                            return self;
                        }
                    }).flatMap((Func1)new Func1<KubernetesCluster, Observable<KubernetesCluster>>(){

                        public Observable<KubernetesCluster> call(KubernetesCluster kubernetesCluster) {
                            return mergedConfigs;
                        }
                    });
                }
            });
        }
        return ((ContainerServiceManagementClientImpl)((Object)((ContainerServiceManager)this.manager()).inner())).managedClusters().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ManagedClusterInner)((Object)self.inner())).map((Func1)new Func1<ManagedClusterInner, KubernetesCluster>(){

            public KubernetesCluster call(ManagedClusterInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        }).flatMap((Func1)new Func1<KubernetesCluster, Observable<KubernetesCluster>>(){

            public Observable<KubernetesCluster> call(KubernetesCluster kubernetesCluster) {
                return mergedConfigs;
            }
        });
    }

    @Override
    public KubernetesClusterImpl withVersion(KubernetesVersion kubernetesVersion) {
        ((ManagedClusterInner)((Object)this.inner())).withKubernetesVersion(kubernetesVersion.toString());
        return this;
    }

    @Override
    public KubernetesClusterImpl withLatestVersion() {
        this.useLatestVersion = true;
        return this;
    }

    @Override
    public KubernetesClusterImpl withRootUsername(String rootUserName) {
        if (((ManagedClusterInner)((Object)this.inner())).linuxProfile() == null) {
            ((ManagedClusterInner)((Object)this.inner())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public KubernetesClusterImpl withSshKey(String sshKeyData) {
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().withSsh(new ContainerServiceSshConfiguration().withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>()));
        ((ManagedClusterInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().add(new ContainerServiceSshPublicKey().withKeyData(sshKeyData));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalClientId(String clientId) {
        ((ManagedClusterInner)((Object)this.inner())).withServicePrincipalProfile(new ContainerServiceServicePrincipalProfile().withClientId(clientId));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalSecret(String secret) {
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().withSecret(secret);
        return this;
    }

    @Override
    public KubernetesClusterImpl withKeyVaultReference(String vaultId) {
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().withSecret(null);
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().withKeyVaultSecretRef(new KeyVaultSecretRef().withVaultID(vaultId));
        return this;
    }

    @Override
    public KubernetesClusterImpl withKeyVaultSecret(String secretName) {
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().keyVaultSecretRef().withSecretName(secretName);
        return this;
    }

    @Override
    public KubernetesClusterImpl withKeyVaultSecret(String secretName, String secretVersion) {
        ((ManagedClusterInner)((Object)this.inner())).servicePrincipalProfile().keyVaultSecretRef().withSecretName(secretName).withVersion(secretVersion);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDnsPrefix(String dnsPrefix) {
        ((ManagedClusterInner)((Object)this.inner())).withDnsPrefix(dnsPrefix);
        return this;
    }

    public KubernetesClusterAgentPoolImpl defineAgentPool(String name) {
        ContainerServiceAgentPoolProfile innerPoolProfile = new ContainerServiceAgentPoolProfile();
        innerPoolProfile.withName(name);
        return new KubernetesClusterAgentPoolImpl(innerPoolProfile, this);
    }

    @Override
    public KubernetesClusterImpl withAgentVirtualMachineCount(String agentPoolName, int agentCount) {
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ContainerServiceAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                if (!agentPoolProfile.name().equals(agentPoolName)) continue;
                agentPoolProfile.withCount(agentCount);
                break;
            }
        }
        return this;
    }

    @Override
    public KubernetesClusterImpl withAgentVirtualMachineCount(int agentCount) {
        if (((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles().size() > 0) {
            for (ContainerServiceAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.inner())).agentPoolProfiles()) {
                agentPoolProfile.withCount(agentCount);
            }
        }
        return this;
    }

    static /* synthetic */ byte[] access$002(KubernetesClusterImpl x0, byte[] x1) {
        x0.adminKubeConfigContent = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(KubernetesClusterImpl x0, byte[] x1) {
        x0.userKubeConfigContent = x1;
        return x1;
    }
}

