/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.management.cosmosdb.DatabaseAccountKind;
import com.microsoft.azure.management.cosmosdb.ConsistencyPolicy;
import java.util.List;
import com.microsoft.azure.management.cosmosdb.Location;
import com.microsoft.azure.management.cosmosdb.Capability;
import com.microsoft.azure.management.cosmosdb.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Parameters to create and update Cosmos DB database accounts.
 */
@JsonFlatten
public class DatabaseAccountCreateUpdateParametersInner extends Resource {
    /**
     * Indicates the type of database account. This can only be set at database
     * account creation. Possible values include: 'GlobalDocumentDB',
     * 'MongoDB', 'Parse'.
     */
    @JsonProperty(value = "kind")
    private DatabaseAccountKind kind;

    /**
     * The consistency policy for the Cosmos DB account.
     */
    @JsonProperty(value = "properties.consistencyPolicy")
    private ConsistencyPolicy consistencyPolicy;

    /**
     * An array that contains the georeplication locations enabled for the
     * Cosmos DB account.
     */
    @JsonProperty(value = "properties.locations", required = true)
    private List<Location> locations;

    /**
     * The databaseAccountOfferType property.
     */
    @JsonProperty(value = "properties.databaseAccountOfferType", required = true)
    private String databaseAccountOfferType;

    /**
     * Cosmos DB Firewall Support: This value specifies the set of IP addresses
     * or IP address ranges in CIDR form to be included as the allowed list of
     * client IPs for a given database account. IP addresses/ranges must be
     * comma separated and must not contain any spaces.
     */
    @JsonProperty(value = "properties.ipRangeFilter")
    private String ipRangeFilter;

    /**
     * Flag to indicate whether to enable/disable Virtual Network ACL rules.
     */
    @JsonProperty(value = "properties.isVirtualNetworkFilterEnabled")
    private Boolean isVirtualNetworkFilterEnabled;

    /**
     * Enables automatic failover of the write region in the rare event that
     * the region is unavailable due to an outage. Automatic failover will
     * result in a new write region for the account and is chosen based on the
     * failover priorities configured for the account.
     */
    @JsonProperty(value = "properties.enableAutomaticFailover")
    private Boolean enableAutomaticFailover;

    /**
     * List of Cosmos DB capabilities for the account.
     */
    @JsonProperty(value = "properties.capabilities")
    private List<Capability> capabilities;

    /**
     * List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JsonProperty(value = "properties.virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;

    /**
     * Creates an instance of DatabaseAccountCreateUpdateParametersInner class.
     */
    public DatabaseAccountCreateUpdateParametersInner() {
        databaseAccountOfferType = "Standard";
    }

    /**
     * Get the kind value.
     *
     * @return the kind value
     */
    public DatabaseAccountKind kind() {
        return this.kind;
    }

    /**
     * Set the kind value.
     *
     * @param kind the kind value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withKind(DatabaseAccountKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the consistencyPolicy value.
     *
     * @return the consistencyPolicy value
     */
    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    /**
     * Set the consistencyPolicy value.
     *
     * @param consistencyPolicy the consistencyPolicy value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    /**
     * Get the locations value.
     *
     * @return the locations value
     */
    public List<Location> locations() {
        return this.locations;
    }

    /**
     * Set the locations value.
     *
     * @param locations the locations value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the databaseAccountOfferType value.
     *
     * @return the databaseAccountOfferType value
     */
    public String databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    /**
     * Set the databaseAccountOfferType value.
     *
     * @param databaseAccountOfferType the databaseAccountOfferType value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withDatabaseAccountOfferType(String databaseAccountOfferType) {
        this.databaseAccountOfferType = databaseAccountOfferType;
        return this;
    }

    /**
     * Get the ipRangeFilter value.
     *
     * @return the ipRangeFilter value
     */
    public String ipRangeFilter() {
        return this.ipRangeFilter;
    }

    /**
     * Set the ipRangeFilter value.
     *
     * @param ipRangeFilter the ipRangeFilter value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withIpRangeFilter(String ipRangeFilter) {
        this.ipRangeFilter = ipRangeFilter;
        return this;
    }

    /**
     * Get the isVirtualNetworkFilterEnabled value.
     *
     * @return the isVirtualNetworkFilterEnabled value
     */
    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    /**
     * Set the isVirtualNetworkFilterEnabled value.
     *
     * @param isVirtualNetworkFilterEnabled the isVirtualNetworkFilterEnabled value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    /**
     * Get the enableAutomaticFailover value.
     *
     * @return the enableAutomaticFailover value
     */
    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    /**
     * Set the enableAutomaticFailover value.
     *
     * @param enableAutomaticFailover the enableAutomaticFailover value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    /**
     * Get the capabilities value.
     *
     * @return the capabilities value
     */
    public List<Capability> capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities value.
     *
     * @param capabilities the capabilities value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the virtualNetworkRules value.
     *
     * @return the virtualNetworkRules value
     */
    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    /**
     * Set the virtualNetworkRules value.
     *
     * @param virtualNetworkRules the virtualNetworkRules value to set
     * @return the DatabaseAccountCreateUpdateParametersInner object itself.
     */
    public DatabaseAccountCreateUpdateParametersInner withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

}
