/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.cosmosdb.implementation.CollectionPartitionRegionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.CollectionPartitionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.CollectionRegionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.CollectionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountRegionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountsInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabasesInner;
import com.microsoft.azure.management.cosmosdb.implementation.OperationsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PartitionKeyRangeIdRegionsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PartitionKeyRangeIdsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PercentileSourceTargetsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PercentileTargetsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PercentilesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class CosmosDBImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private DatabaseAccountsInner databaseAccounts;
    private OperationsInner operations;
    private DatabasesInner databases;
    private CollectionsInner collections;
    private CollectionRegionsInner collectionRegions;
    private DatabaseAccountRegionsInner databaseAccountRegions;
    private PercentileSourceTargetsInner percentileSourceTargets;
    private PercentileTargetsInner percentileTargets;
    private PercentilesInner percentiles;
    private CollectionPartitionRegionsInner collectionPartitionRegions;
    private CollectionPartitionsInner collectionPartitions;
    private PartitionKeyRangeIdsInner partitionKeyRangeIds;
    private PartitionKeyRangeIdRegionsInner partitionKeyRangeIdRegions;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public CosmosDBImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public CosmosDBImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public CosmosDBImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public CosmosDBImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public DatabaseAccountsInner databaseAccounts() {
        return this.databaseAccounts;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public DatabasesInner databases() {
        return this.databases;
    }

    public CollectionsInner collections() {
        return this.collections;
    }

    public CollectionRegionsInner collectionRegions() {
        return this.collectionRegions;
    }

    public DatabaseAccountRegionsInner databaseAccountRegions() {
        return this.databaseAccountRegions;
    }

    public PercentileSourceTargetsInner percentileSourceTargets() {
        return this.percentileSourceTargets;
    }

    public PercentileTargetsInner percentileTargets() {
        return this.percentileTargets;
    }

    public PercentilesInner percentiles() {
        return this.percentiles;
    }

    public CollectionPartitionRegionsInner collectionPartitionRegions() {
        return this.collectionPartitionRegions;
    }

    public CollectionPartitionsInner collectionPartitions() {
        return this.collectionPartitions;
    }

    public PartitionKeyRangeIdsInner partitionKeyRangeIds() {
        return this.partitionKeyRangeIds;
    }

    public PartitionKeyRangeIdRegionsInner partitionKeyRangeIdRegions() {
        return this.partitionKeyRangeIdRegions;
    }

    public CosmosDBImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public CosmosDBImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public CosmosDBImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2015-04-08";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.databaseAccounts = new DatabaseAccountsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.databases = new DatabasesInner(this.restClient().retrofit(), this);
        this.collections = new CollectionsInner(this.restClient().retrofit(), this);
        this.collectionRegions = new CollectionRegionsInner(this.restClient().retrofit(), this);
        this.databaseAccountRegions = new DatabaseAccountRegionsInner(this.restClient().retrofit(), this);
        this.percentileSourceTargets = new PercentileSourceTargetsInner(this.restClient().retrofit(), this);
        this.percentileTargets = new PercentileTargetsInner(this.restClient().retrofit(), this);
        this.percentiles = new PercentilesInner(this.restClient().retrofit(), this);
        this.collectionPartitionRegions = new CollectionPartitionRegionsInner(this.restClient().retrofit(), this);
        this.collectionPartitions = new CollectionPartitionsInner(this.restClient().retrofit(), this);
        this.partitionKeyRangeIds = new PartitionKeyRangeIdsInner(this.restClient().retrofit(), this);
        this.partitionKeyRangeIdRegions = new PartitionKeyRangeIdRegionsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "CosmosDB", "2015-04-08");
    }
}

