/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.management.cosmosdb.IndexingPolicy;
import com.microsoft.azure.management.cosmosdb.ContainerPartitionKey;
import com.microsoft.azure.management.cosmosdb.UniqueKeyPolicy;
import com.microsoft.azure.management.cosmosdb.ConflictResolutionPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB container.
 */
@JsonFlatten
@SkipParentValidation
public class ContainerInner extends Resource {
    /**
     * Name of the Cosmos DB container.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String containerId;

    /**
     * The configuration of the indexing policy. By default, the indexing is
     * automatic for all document paths within the container.
     */
    @JsonProperty(value = "properties.indexingPolicy")
    private IndexingPolicy indexingPolicy;

    /**
     * The configuration of the partition key to be used for partitioning data
     * into multiple partitions.
     */
    @JsonProperty(value = "properties.partitionKey")
    private ContainerPartitionKey partitionKey;

    /**
     * Default time to live.
     */
    @JsonProperty(value = "properties.defaultTtl")
    private Integer defaultTtl;

    /**
     * The unique key policy configuration for specifying uniqueness
     * constraints on documents in the collection in the Azure Cosmos DB
     * service.
     */
    @JsonProperty(value = "properties.uniqueKeyPolicy")
    private UniqueKeyPolicy uniqueKeyPolicy;

    /**
     * The conflict resolution policy for the container.
     */
    @JsonProperty(value = "properties.conflictResolutionPolicy")
    private ConflictResolutionPolicy conflictResolutionPolicy;

    /**
     * A system generated property. A unique identifier.
     */
    @JsonProperty(value = "properties.rid")
    private String rid;

    /**
     * A system generated property that denotes the last updated timestamp of
     * the resource.
     */
    @JsonProperty(value = "properties.ts")
    private Object ts;

    /**
     * A system generated property representing the resource etag required for
     * optimistic concurrency control.
     */
    @JsonProperty(value = "properties.etag")
    private String etag;

    /**
     * Get name of the Cosmos DB container.
     *
     * @return the containerId value
     */
    public String containerId() {
        return this.containerId;
    }

    /**
     * Set name of the Cosmos DB container.
     *
     * @param containerId the containerId value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    /**
     * Get the configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container.
     *
     * @return the indexingPolicy value
     */
    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    /**
     * Set the configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container.
     *
     * @param indexingPolicy the indexingPolicy value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    /**
     * Get the configuration of the partition key to be used for partitioning data into multiple partitions.
     *
     * @return the partitionKey value
     */
    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    /**
     * Set the configuration of the partition key to be used for partitioning data into multiple partitions.
     *
     * @param partitionKey the partitionKey value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    /**
     * Get default time to live.
     *
     * @return the defaultTtl value
     */
    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    /**
     * Set default time to live.
     *
     * @param defaultTtl the defaultTtl value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    /**
     * Get the unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
     *
     * @return the uniqueKeyPolicy value
     */
    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    /**
     * Set the unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
     *
     * @param uniqueKeyPolicy the uniqueKeyPolicy value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    /**
     * Get the conflict resolution policy for the container.
     *
     * @return the conflictResolutionPolicy value
     */
    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    /**
     * Set the conflict resolution policy for the container.
     *
     * @param conflictResolutionPolicy the conflictResolutionPolicy value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    /**
     * Get a system generated property. A unique identifier.
     *
     * @return the rid value
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Set a system generated property. A unique identifier.
     *
     * @param rid the rid value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
     * Get a system generated property that denotes the last updated timestamp of the resource.
     *
     * @return the ts value
     */
    public Object ts() {
        return this.ts;
    }

    /**
     * Set a system generated property that denotes the last updated timestamp of the resource.
     *
     * @param ts the ts value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withTs(Object ts) {
        this.ts = ts;
        return this;
    }

    /**
     * Get a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @param etag the etag value to set
     * @return the ContainerInner object itself.
     */
    public ContainerInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

}
