/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB Mongo database.
 */
@JsonFlatten
@SkipParentValidation
public class MongoDatabaseInner extends Resource {
    /**
     * Name of the Cosmos DB Mongo database.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String mongoDatabaseId;

    /**
     * Get name of the Cosmos DB Mongo database.
     *
     * @return the mongoDatabaseId value
     */
    public String mongoDatabaseId() {
        return this.mongoDatabaseId;
    }

    /**
     * Set name of the Cosmos DB Mongo database.
     *
     * @param mongoDatabaseId the mongoDatabaseId value to set
     * @return the MongoDatabaseInner object itself.
     */
    public MongoDatabaseInner withMongoDatabaseId(String mongoDatabaseId) {
        this.mongoDatabaseId = mongoDatabaseId;
        return this;
    }

}
