/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB SQL database.
 */
@JsonFlatten
@SkipParentValidation
public class SqlDatabaseInner extends Resource {
    /**
     * Name of the Cosmos DB SQL database.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String sqlDatabaseId;

    /**
     * A system generated property. A unique identifier.
     */
    @JsonProperty(value = "properties.rid")
    private String rid;

    /**
     * A system generated property that denotes the last updated timestamp of
     * the resource.
     */
    @JsonProperty(value = "properties.ts")
    private Object ts;

    /**
     * A system generated property representing the resource etag required for
     * optimistic concurrency control.
     */
    @JsonProperty(value = "properties.etag")
    private String etag;

    /**
     * A system generated property that specified the addressable path of the
     * collections resource.
     */
    @JsonProperty(value = "properties._colls")
    private String colls;

    /**
     * A system generated property that specifies the addressable path of the
     * users resource.
     */
    @JsonProperty(value = "properties.users")
    private String users;

    /**
     * Get name of the Cosmos DB SQL database.
     *
     * @return the sqlDatabaseId value
     */
    public String sqlDatabaseId() {
        return this.sqlDatabaseId;
    }

    /**
     * Set name of the Cosmos DB SQL database.
     *
     * @param sqlDatabaseId the sqlDatabaseId value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withSqlDatabaseId(String sqlDatabaseId) {
        this.sqlDatabaseId = sqlDatabaseId;
        return this;
    }

    /**
     * Get a system generated property. A unique identifier.
     *
     * @return the rid value
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Set a system generated property. A unique identifier.
     *
     * @param rid the rid value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
     * Get a system generated property that denotes the last updated timestamp of the resource.
     *
     * @return the ts value
     */
    public Object ts() {
        return this.ts;
    }

    /**
     * Set a system generated property that denotes the last updated timestamp of the resource.
     *
     * @param ts the ts value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withTs(Object ts) {
        this.ts = ts;
        return this;
    }

    /**
     * Get a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @param etag the etag value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get a system generated property that specified the addressable path of the collections resource.
     *
     * @return the colls value
     */
    public String colls() {
        return this.colls;
    }

    /**
     * Set a system generated property that specified the addressable path of the collections resource.
     *
     * @param colls the colls value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withColls(String colls) {
        this.colls = colls;
        return this;
    }

    /**
     * Get a system generated property that specifies the addressable path of the users resource.
     *
     * @return the users value
     */
    public String users() {
        return this.users;
    }

    /**
     * Set a system generated property that specifies the addressable path of the users resource.
     *
     * @param users the users value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withUsers(String users) {
        this.users = users;
        return this;
    }

}
