/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB Table.
 */
@JsonFlatten
@SkipParentValidation
public class TableInner extends Resource {
    /**
     * Name of the Cosmos DB table.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String tableId;

    /**
     * Get name of the Cosmos DB table.
     *
     * @return the tableId value
     */
    public String tableId() {
        return this.tableId;
    }

    /**
     * Set name of the Cosmos DB table.
     *
     * @param tableId the tableId value to set
     * @return the TableInner object itself.
     */
    public TableInner withTableId(String tableId) {
        this.tableId = tableId;
        return this;
    }

}
