/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import java.util.Map;
import java.util.List;
import com.microsoft.azure.management.cosmosdb.MongoIndex;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB Mongo collection.
 */
@JsonFlatten
@SkipParentValidation
public class MongoCollectionInner extends Resource {
    /**
     * Name of the Cosmos DB Mongo collection.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String mongoCollectionId;

    /**
     * A key-value pair of shard keys to be applied for the request.
     */
    @JsonProperty(value = "properties.shardKey")
    private Map<String, String> shardKey;

    /**
     * List of index keys.
     */
    @JsonProperty(value = "properties.indexes")
    private List<MongoIndex> indexes;

    /**
     * Get name of the Cosmos DB Mongo collection.
     *
     * @return the mongoCollectionId value
     */
    public String mongoCollectionId() {
        return this.mongoCollectionId;
    }

    /**
     * Set name of the Cosmos DB Mongo collection.
     *
     * @param mongoCollectionId the mongoCollectionId value to set
     * @return the MongoCollectionInner object itself.
     */
    public MongoCollectionInner withMongoCollectionId(String mongoCollectionId) {
        this.mongoCollectionId = mongoCollectionId;
        return this;
    }

    /**
     * Get a key-value pair of shard keys to be applied for the request.
     *
     * @return the shardKey value
     */
    public Map<String, String> shardKey() {
        return this.shardKey;
    }

    /**
     * Set a key-value pair of shard keys to be applied for the request.
     *
     * @param shardKey the shardKey value to set
     * @return the MongoCollectionInner object itself.
     */
    public MongoCollectionInner withShardKey(Map<String, String> shardKey) {
        this.shardKey = shardKey;
        return this;
    }

    /**
     * Get list of index keys.
     *
     * @return the indexes value
     */
    public List<MongoIndex> indexes() {
        return this.indexes;
    }

    /**
     * Set list of index keys.
     *
     * @param indexes the indexes value to set
     * @return the MongoCollectionInner object itself.
     */
    public MongoCollectionInner withIndexes(List<MongoIndex> indexes) {
        this.indexes = indexes;
        return this;
    }

}
