/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB MongoDB database.
 */
@JsonFlatten
@SkipParentValidation
public class MongoDBDatabaseInner extends Resource {
    /**
     * Name of the Cosmos DB MongoDB database.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String mongoDBDatabaseId;

    /**
     * Get name of the Cosmos DB MongoDB database.
     *
     * @return the mongoDBDatabaseId value
     */
    public String mongoDBDatabaseId() {
        return this.mongoDBDatabaseId;
    }

    /**
     * Set name of the Cosmos DB MongoDB database.
     *
     * @param mongoDBDatabaseId the mongoDBDatabaseId value to set
     * @return the MongoDBDatabaseInner object itself.
     */
    public MongoDBDatabaseInner withMongoDBDatabaseId(String mongoDBDatabaseId) {
        this.mongoDBDatabaseId = mongoDBDatabaseId;
        return this;
    }

}
