/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB SQL database.
 */
@JsonFlatten
@SkipParentValidation
public class SqlDatabaseInner extends Resource {
    /**
     * Name of the Cosmos DB SQL database.
     */
    @JsonProperty(value = "properties.id", required = true)
    private String sqlDatabaseId;

    /**
     * A system generated property. A unique identifier.
     */
    @JsonProperty(value = "properties._rid")
    private String _rid;

    /**
     * A system generated property that denotes the last updated timestamp of
     * the resource.
     */
    @JsonProperty(value = "properties._ts")
    private Object _ts;

    /**
     * A system generated property representing the resource etag required for
     * optimistic concurrency control.
     */
    @JsonProperty(value = "properties._etag")
    private String _etag;

    /**
     * A system generated property that specified the addressable path of the
     * collections resource.
     */
    @JsonProperty(value = "properties._colls")
    private String _colls;

    /**
     * A system generated property that specifies the addressable path of the
     * users resource.
     */
    @JsonProperty(value = "properties._users")
    private String _users;

    /**
     * Get name of the Cosmos DB SQL database.
     *
     * @return the sqlDatabaseId value
     */
    public String sqlDatabaseId() {
        return this.sqlDatabaseId;
    }

    /**
     * Set name of the Cosmos DB SQL database.
     *
     * @param sqlDatabaseId the sqlDatabaseId value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner withSqlDatabaseId(String sqlDatabaseId) {
        this.sqlDatabaseId = sqlDatabaseId;
        return this;
    }

    /**
     * Get a system generated property. A unique identifier.
     *
     * @return the _rid value
     */
    public String _rid() {
        return this._rid;
    }

    /**
     * Set a system generated property. A unique identifier.
     *
     * @param _rid the _rid value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner with_rid(String _rid) {
        this._rid = _rid;
        return this;
    }

    /**
     * Get a system generated property that denotes the last updated timestamp of the resource.
     *
     * @return the _ts value
     */
    public Object _ts() {
        return this._ts;
    }

    /**
     * Set a system generated property that denotes the last updated timestamp of the resource.
     *
     * @param _ts the _ts value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner with_ts(Object _ts) {
        this._ts = _ts;
        return this;
    }

    /**
     * Get a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @return the _etag value
     */
    public String _etag() {
        return this._etag;
    }

    /**
     * Set a system generated property representing the resource etag required for optimistic concurrency control.
     *
     * @param _etag the _etag value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner with_etag(String _etag) {
        this._etag = _etag;
        return this;
    }

    /**
     * Get a system generated property that specified the addressable path of the collections resource.
     *
     * @return the _colls value
     */
    public String _colls() {
        return this._colls;
    }

    /**
     * Set a system generated property that specified the addressable path of the collections resource.
     *
     * @param _colls the _colls value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner with_colls(String _colls) {
        this._colls = _colls;
        return this;
    }

    /**
     * Get a system generated property that specifies the addressable path of the users resource.
     *
     * @return the _users value
     */
    public String _users() {
        return this._users;
    }

    /**
     * Set a system generated property that specifies the addressable path of the users resource.
     *
     * @param _users the _users value to set
     * @return the SqlDatabaseInner object itself.
     */
    public SqlDatabaseInner with_users(String _users) {
        this._users = _users;
        return this;
    }

}
