/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cosmosdb.CassandraKeyspaceCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.CassandraTableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountPatchParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountRegenerateKeyParameters;
import com.microsoft.azure.management.cosmosdb.ErrorResponseException;
import com.microsoft.azure.management.cosmosdb.FailoverPolicies;
import com.microsoft.azure.management.cosmosdb.FailoverPolicy;
import com.microsoft.azure.management.cosmosdb.GremlinDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.GremlinGraphCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.MongoDBCollectionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.MongoDBDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.RegionForOnlineOffline;
import com.microsoft.azure.management.cosmosdb.SqlContainerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.TableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputResource;
import com.microsoft.azure.management.cosmosdb.ThroughputUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraKeyspaceInner;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraTableInner;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.GremlinDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.GremlinGraphInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricInner;
import com.microsoft.azure.management.cosmosdb.implementation.MongoDBCollectionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MongoDBDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.SqlContainerInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlDatabaseInner;
import com.microsoft.azure.management.cosmosdb.implementation.TableInner;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputInner;
import com.microsoft.azure.management.cosmosdb.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseAccountsInner
implements InnerSupportsGet<DatabaseAccountInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DatabaseAccountInner> {
    private DatabaseAccountsService service;
    private CosmosDBImpl client;

    public DatabaseAccountsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (DatabaseAccountsService)retrofit.create(DatabaseAccountsService.class);
        this.client = client;
    }

    public DatabaseAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner patch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return this.patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        Observable<Response<ResponseBody>> observable = this.service.patch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginPatch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return this.beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        return this.service.beginPatch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginPatchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginPatchDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountInner createOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>(){}.getType());
    }

    public DatabaseAccountInner beginCreateOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return (DatabaseAccountInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>(){

            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return (DatabaseAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        ((ServiceResponse)this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        Observable<Response<ResponseBody>> observable = this.service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        ((ServiceResponse)this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        return this.service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginFailoverPriorityChangeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverPriorityChangeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listAsync(ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page){

            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>(){

            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<DatabaseAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListKeysResultInner>, DatabaseAccountListKeysResultInner>(){

            public DatabaseAccountListKeysResultInner call(ServiceResponse<DatabaseAccountListKeysResultInner> response) {
                return (DatabaseAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListConnectionStringsResultInner listConnectionStrings(String resourceGroupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResultInner)((ServiceResponse)this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListConnectionStringsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName) {
        return this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>, DatabaseAccountListConnectionStringsResultInner>(){

            public DatabaseAccountListConnectionStringsResultInner call(ServiceResponse<DatabaseAccountListConnectionStringsResultInner> response) {
                return (DatabaseAccountListConnectionStringsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listConnectionStrings(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listConnectionStringsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListConnectionStringsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void offlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> offlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.offlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOfflineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOfflineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        return this.service.beginOfflineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOfflineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOfflineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void onlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> onlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.onlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOnlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOnlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        return this.service.beginOnlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOnlineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOnlineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner getReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> getReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner listReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> listReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void regenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().last()).body();
    }

    public ServiceFuture<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        Observable<Response<ResponseBody>> observable = this.service.regenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRegenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRegenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        return this.service.beginRegenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginRegenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRegenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkNameExists(String accountName) {
        return (Boolean)((ServiceResponse)this.checkNameExistsWithServiceResponseAsync(accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkNameExistsAsync(String accountName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameExistsWithServiceResponseAsync(accountName), serviceCallback);
    }

    public Observable<Boolean> checkNameExistsAsync(String accountName) {
        return this.checkNameExistsWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkNameExistsWithServiceResponseAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkNameExists(accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.checkNameExistsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkNameExistsDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName) {
        return this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricDefinitionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlDatabaseInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<SqlDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<SqlDatabaseInner>>, List<SqlDatabaseInner>>(){

            public List<SqlDatabaseInner> call(ServiceResponse<List<SqlDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlDatabaseInner>>> listSqlDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSqlDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<SqlDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listSqlDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlDatabaseInner>> listSqlDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> getSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseInner> getSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> createUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlDatabaseInner>(){}.getType());
    }

    public SqlDatabaseInner beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>(){

            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return (SqlDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseInner>> beginCreateUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlDatabaseParameters);
        return this.service.beginCreateUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseInner> beginCreateUpdateSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateSqlDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlContainerInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<SqlContainerInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<SqlContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<SqlContainerInner>>, List<SqlContainerInner>>(){

            public List<SqlContainerInner> call(ServiceResponse<List<SqlContainerInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlContainerInner>>> listSqlContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSqlContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlContainerInner>>>>(){

            public Observable<ServiceResponse<List<SqlContainerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listSqlContainersDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlContainerInner>> listSqlContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlContainerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlContainerInner getSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (SqlContainerInner)((Object)((ServiceResponse)this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<SqlContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>(){

            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return (SqlContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerInner>> getSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerInner>>>(){

            public Observable<ServiceResponse<SqlContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlContainerInner> getSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlContainerInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (SqlContainerInner)((Object)((ServiceResponse)this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<SqlContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>(){

            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return (SqlContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerInner>> createUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlContainerParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlContainerInner>(){}.getType());
    }

    public SqlContainerInner beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (SqlContainerInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<SqlContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>(){

            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return (SqlContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerInner>> beginCreateUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateSqlContainerParameters);
        return this.service.beginCreateUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerInner>>>(){

            public Observable<ServiceResponse<SqlContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlContainerInner> beginCreateUpdateSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlContainerInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        ((ServiceResponse)this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        ((ServiceResponse)this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<ThroughputInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getSqlContainerThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateSqlContainerThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MongoDBDatabaseInner> listMongoDBDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoDBDatabaseInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<MongoDBDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MongoDBDatabaseInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MongoDBDatabaseInner>>, List<MongoDBDatabaseInner>>(){

            public List<MongoDBDatabaseInner> call(ServiceResponse<List<MongoDBDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoDBDatabaseInner>>> listMongoDBDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMongoDBDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<MongoDBDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMongoDBDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoDBDatabaseInner>> listMongoDBDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoDBDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBDatabaseInner getMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (MongoDBDatabaseInner)((Object)((ServiceResponse)this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBDatabaseInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<MongoDBDatabaseInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>(){

            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return (MongoDBDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseInner>> getMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseInner>>>(){

            public Observable<ServiceResponse<MongoDBDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBDatabaseInner> getMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBDatabaseInner createUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return (MongoDBDatabaseInner)((Object)((ServiceResponse)this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoDBDatabaseInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDBDatabaseInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>(){

            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return (MongoDBDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseInner>> createUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDBDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBDatabaseInner>(){}.getType());
    }

    public MongoDBDatabaseInner beginCreateUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return (MongoDBDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>(){

            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return (MongoDBDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseInner>> beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDBDatabaseParameters);
        return this.service.beginCreateUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseInner>>>(){

            public Observable<ServiceResponse<MongoDBDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoDBDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateMongoDBDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MongoDBCollectionInner> listMongoDBCollections(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoDBCollectionInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<MongoDBCollectionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<MongoDBCollectionInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<MongoDBCollectionInner>>, List<MongoDBCollectionInner>>(){

            public List<MongoDBCollectionInner> call(ServiceResponse<List<MongoDBCollectionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoDBCollectionInner>>> listMongoDBCollectionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listMongoDBCollections(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBCollectionInner>>>>(){

            public Observable<ServiceResponse<List<MongoDBCollectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMongoDBCollectionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoDBCollectionInner>> listMongoDBCollectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoDBCollectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBCollectionInner getMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return (MongoDBCollectionInner)((Object)((ServiceResponse)this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBCollectionInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<MongoDBCollectionInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>(){

            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return (MongoDBCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionInner>> getMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionInner>>>(){

            public Observable<ServiceResponse<MongoDBCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBCollectionInner> getMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBCollectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBCollectionInner createUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return (MongoDBCollectionInner)((Object)((ServiceResponse)this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoDBCollectionInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    public Observable<MongoDBCollectionInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>(){

            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return (MongoDBCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionInner>> createUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDBCollectionParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBCollectionInner>(){}.getType());
    }

    public MongoDBCollectionInner beginCreateUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return (MongoDBCollectionInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    public Observable<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>(){

            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return (MongoDBCollectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionInner>> beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateMongoDBCollectionParameters);
        return this.service.beginCreateUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionInner>>>(){

            public Observable<ServiceResponse<MongoDBCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBCollectionInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        ((ServiceResponse)this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        ((ServiceResponse)this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<ThroughputInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getMongoDBCollectionThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateMongoDBCollectionThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<TableInner> listTables(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName, ServiceCallback<List<TableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listTablesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName) {
        return this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<TableInner>>, List<TableInner>>(){

            public List<TableInner> call(ServiceResponse<List<TableInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<TableInner>>> listTablesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listTables(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<TableInner>>>>(){

            public Observable<ServiceResponse<List<TableInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TableInner>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TableInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableInner getTable(String resourceGroupName, String accountName, String tableName) {
        return (TableInner)((Object)((ServiceResponse)this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> getTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>(){

            public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableInner> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableInner createUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableInner)((Object)((ServiceResponse)this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> createUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateTableParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TableInner>(){}.getType());
    }

    public TableInner beginCreateUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableInner)((Object)((ServiceResponse)this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableInner>, TableInner>(){

            public TableInner call(ServiceResponse<TableInner> response) {
                return (TableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableInner>> beginCreateUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateTableParameters);
        return this.service.beginCreateUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>(){

            public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableInner> beginCreateUpdateTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteTable(String resourceGroupName, String accountName, String tableName) {
        ((ServiceResponse)this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteTable(String resourceGroupName, String accountName, String tableName) {
        ((ServiceResponse)this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getTableThroughput(String resourceGroupName, String accountName, String tableName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<ThroughputInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CassandraKeyspaceInner> listCassandraKeyspaces(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName, ServiceCallback<List<CassandraKeyspaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName) {
        return this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<CassandraKeyspaceInner>>, List<CassandraKeyspaceInner>>(){

            public List<CassandraKeyspaceInner> call(ServiceResponse<List<CassandraKeyspaceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> listCassandraKeyspacesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCassandraKeyspaces(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraKeyspaceInner>>>>(){

            public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listCassandraKeyspacesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraKeyspaceInner>> listCassandraKeyspacesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraKeyspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceInner getCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> getCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceInner> getCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceInner createUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> createUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraKeyspaceParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraKeyspaceInner>(){}.getType());
    }

    public CassandraKeyspaceInner beginCreateUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>(){

            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return (CassandraKeyspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceInner>> beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraKeyspaceParameters);
        return this.service.beginCreateUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        ((ServiceResponse)this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        ((ServiceResponse)this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<ThroughputInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraKeyspaceThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateCassandraKeyspaceThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CassandraTableInner> listCassandraTables(String resourceGroupName, String accountName, String keyspaceName) {
        return (List)((ServiceResponse)this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<List<CassandraTableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<List<CassandraTableInner>>, List<CassandraTableInner>>(){

            public List<CassandraTableInner> call(ServiceResponse<List<CassandraTableInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraTableInner>>> listCassandraTablesWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCassandraTables(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraTableInner>>>>(){

            public Observable<ServiceResponse<List<CassandraTableInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listCassandraTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraTableInner>> listCassandraTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraTableInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableInner getCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> getCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>(){

            public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableInner> getCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableInner createUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> createUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraTableParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraTableInner>(){}.getType());
    }

    public CassandraTableInner beginCreateUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>(){

            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return (CassandraTableInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableInner>> beginCreateUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateCassandraTableParameters);
        return this.service.beginCreateUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>(){

            public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableInner> beginCreateUpdateCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        ((ServiceResponse)this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        ((ServiceResponse)this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<ThroughputInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getCassandraTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateCassandraTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<GremlinDatabaseInner> listGremlinDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<GremlinDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<GremlinDatabaseInner>>, List<GremlinDatabaseInner>>(){

            public List<GremlinDatabaseInner> call(ServiceResponse<List<GremlinDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GremlinDatabaseInner>>> listGremlinDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listGremlinDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<GremlinDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listGremlinDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GremlinDatabaseInner>> listGremlinDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GremlinDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseInner getGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> getGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseInner> getGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> createUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinDatabaseParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinDatabaseInner>(){}.getType());
    }

    public GremlinDatabaseInner beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>(){

            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return (GremlinDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseInner>> beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinDatabaseParameters);
        return this.service.beginCreateUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateGremlinDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<GremlinGraphInner> listGremlinGraphs(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GremlinGraphInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<GremlinGraphInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<GremlinGraphInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<GremlinGraphInner>>, List<GremlinGraphInner>>(){

            public List<GremlinGraphInner> call(ServiceResponse<List<GremlinGraphInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GremlinGraphInner>>> listGremlinGraphsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listGremlinGraphs(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinGraphInner>>>>(){

            public Observable<ServiceResponse<List<GremlinGraphInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listGremlinGraphsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GremlinGraphInner>> listGremlinGraphsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GremlinGraphInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinGraphInner getGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (GremlinGraphInner)((Object)((ServiceResponse)this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinGraphInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<GremlinGraphInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>(){

            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return (GremlinGraphInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphInner>> getGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphInner>>>(){

            public Observable<ServiceResponse<GremlinGraphInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinGraphInner> getGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinGraphInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinGraphInner createUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return (GremlinGraphInner)((Object)((ServiceResponse)this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().last()).body());
    }

    public ServiceFuture<GremlinGraphInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    public Observable<GremlinGraphInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map((Func1)new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>(){

            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return (GremlinGraphInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphInner>> createUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinGraphParameters);
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinGraphInner>(){}.getType());
    }

    public GremlinGraphInner beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return (GremlinGraphInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinGraphInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    public Observable<GremlinGraphInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map((Func1)new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>(){

            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return (GremlinGraphInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphInner>> beginCreateUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate((Object)createUpdateGremlinGraphParameters);
        return this.service.beginCreateUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphInner>>>(){

            public Observable<ServiceResponse<GremlinGraphInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateUpdateGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinGraphInner> beginCreateUpdateGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinGraphInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        ((ServiceResponse)this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        ((ServiceResponse)this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner getGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (ThroughputInner)((Object)((ServiceResponse)this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<ThroughputInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> getGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getGremlinGraphThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> getGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputInner updateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> updateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = this.service.updateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>(){}.getType());
    }

    public ThroughputInner beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return (ThroughputInner)((Object)((ServiceResponse)this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource, ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource), serviceCallback);
    }

    public Observable<ThroughputInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).map((Func1)new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>(){

            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return (ThroughputInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputInner>> beginUpdateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return this.service.beginUpdateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>(){

            public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateGremlinGraphThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputInner> beginUpdateGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts patch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountPatchParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginPatch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginPatch(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountPatchParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts failoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> failoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginFailoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> beginFailoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listConnectionStrings"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings")
        public Observable<Response<ResponseBody>> listConnectionStrings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts offlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> offlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOfflineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> beginOfflineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts onlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> onlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOnlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> beginOnlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getReadOnlyKeys"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> getReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listReadOnlyKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> listReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginRegenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> beginRegenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts checkNameExists"})
        @HEAD(value="providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}")
        public Observable<Response<Void>> checkNameExists(@Path(value="accountName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listUsages"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/usages")
        public Observable<Response<ResponseBody>> listUsages(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetricDefinitions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metricDefinitions")
        public Observable<Response<ResponseBody>> listMetricDefinitions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases")
        public Observable<Response<ResponseBody>> listSqlDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> getSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateSqlDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateSqlDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlContainers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers")
        public Observable<Response<ResponseBody>> listSqlContainers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlContainer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> getSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> createUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body SqlContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body SqlContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlContainerThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        public Observable<Response<ResponseBody>> getSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateSqlContainerThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateSqlContainerThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoDBDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases")
        public Observable<Response<ResponseBody>> listMongoDBDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoDBDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body MongoDBDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoDBDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body MongoDBDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoDBDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoDBDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> getMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateMongoDBDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateMongoDBDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoDBCollections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections")
        public Observable<Response<ResponseBody>> listMongoDBCollections(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBCollection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> getMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoDBCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> createUpdateMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body MongoDBCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoDBCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body MongoDBCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoDBCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoDBCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBCollectionThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        public Observable<Response<ResponseBody>> getMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateMongoDBCollectionThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateMongoDBCollectionThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables")
        public Observable<Response<ResponseBody>> listTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        public Observable<Response<ResponseBody>> getTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        public Observable<Response<ResponseBody>> createUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getTableThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> getTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraKeyspaces"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces")
        public Observable<Response<ResponseBody>> listCassandraKeyspaces(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraKeyspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> getCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> createUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraKeyspaceThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        public Observable<Response<ResponseBody>> getCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateCassandraKeyspaceThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateCassandraKeyspaceThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables")
        public Observable<Response<ResponseBody>> listCassandraTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> getCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> createUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraTableThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> getCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateCassandraTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateCassandraTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases")
        public Observable<Response<ResponseBody>> listGremlinDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> getGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateGremlinDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateGremlinDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ThroughputUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinGraphs"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs")
        public Observable<Response<ResponseBody>> listGremlinGraphs(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinGraph"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> getGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinGraph"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> createUpdateGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body GremlinGraphCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinGraph"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body GremlinGraphCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinGraph"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinGraph"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinGraphThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        public Observable<Response<ResponseBody>> getGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateGremlinGraphThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        public Observable<Response<ResponseBody>> updateGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateGremlinGraphThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        public Observable<Response<ResponseBody>> beginUpdateGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ThroughputUpdateParameters var8, @Header(value="User-Agent") String var9);
    }
}

