/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.CassandraKeyspaceCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.CassandraTableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountPatchParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountRegenerateKeyParameters;
import com.microsoft.azure.management.cosmosdb.ErrorResponseException;
import com.microsoft.azure.management.cosmosdb.FailoverPolicies;
import com.microsoft.azure.management.cosmosdb.FailoverPolicy;
import com.microsoft.azure.management.cosmosdb.GremlinDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.GremlinGraphCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.MongoDBCollectionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.MongoDBDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.RegionForOnlineOffline;
import com.microsoft.azure.management.cosmosdb.SqlContainerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.TableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputResource;
import com.microsoft.azure.management.cosmosdb.ThroughputUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DatabaseAccounts.
 */
public class DatabaseAccountsInner implements InnerSupportsGet<DatabaseAccountInner>, InnerSupportsDelete<Void>, InnerSupportsListing<DatabaseAccountInner> {
    /** The Retrofit service to perform REST calls. */
    private DatabaseAccountsService service;
    /** The service client containing this operation class. */
    private CosmosDBImpl client;

    /**
     * Initializes an instance of DatabaseAccountsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DatabaseAccountsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = retrofit.create(DatabaseAccountsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DatabaseAccounts to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DatabaseAccountsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts patch" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        Observable<Response<ResponseBody>> patch(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Body DatabaseAccountPatchParameters updateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginPatch" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        Observable<Response<ResponseBody>> beginPatch(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Body DatabaseAccountPatchParameters updateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Body DatabaseAccountCreateUpdateParameters createUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Body DatabaseAccountCreateUpdateParameters createUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts failoverPriorityChange" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        Observable<Response<ResponseBody>> failoverPriorityChange(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body FailoverPolicies failoverParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginFailoverPriorityChange" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        Observable<Response<ResponseBody>> beginFailoverPriorityChange(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body FailoverPolicies failoverParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys")
        Observable<Response<ResponseBody>> listKeys(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listConnectionStrings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings")
        Observable<Response<ResponseBody>> listConnectionStrings(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts offlineRegion" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        Observable<Response<ResponseBody>> offlineRegion(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegionForOnlineOffline regionParameterForOffline, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOfflineRegion" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        Observable<Response<ResponseBody>> beginOfflineRegion(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegionForOnlineOffline regionParameterForOffline, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts onlineRegion" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        Observable<Response<ResponseBody>> onlineRegion(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegionForOnlineOffline regionParameterForOnline, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOnlineRegion" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        Observable<Response<ResponseBody>> beginOnlineRegion(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegionForOnlineOffline regionParameterForOnline, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getReadOnlyKeys" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        Observable<Response<ResponseBody>> getReadOnlyKeys(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listReadOnlyKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        Observable<Response<ResponseBody>> listReadOnlyKeys(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts regenerateKey" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        Observable<Response<ResponseBody>> regenerateKey(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DatabaseAccountRegenerateKeyParameters keyToRegenerate, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginRegenerateKey" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        Observable<Response<ResponseBody>> beginRegenerateKey(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body DatabaseAccountRegenerateKeyParameters keyToRegenerate, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts checkNameExists" })
        @HEAD("providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}")
        Observable<Response<Void>> checkNameExists(@Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metrics")
        Observable<Response<ResponseBody>> listMetrics(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/usages")
        Observable<Response<ResponseBody>> listUsages(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metricDefinitions")
        Observable<Response<ResponseBody>> listMetricDefinitions(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlDatabases" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases")
        Observable<Response<ResponseBody>> listSqlDatabases(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        Observable<Response<ResponseBody>> getSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        Observable<Response<ResponseBody>> createUpdateSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlDatabaseThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> getSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateSqlDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> updateSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateSqlDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listSqlContainers" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers")
        Observable<Response<ResponseBody>> listSqlContainers(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlContainer" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> getSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateSqlContainer" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> createUpdateSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateSqlContainer" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteSqlContainer" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteSqlContainer" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getSqlContainerThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        Observable<Response<ResponseBody>> getSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateSqlContainerThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        Observable<Response<ResponseBody>> updateSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateSqlContainerThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/sql/databases/{databaseName}/containers/{containerName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoDBDatabases" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases")
        Observable<Response<ResponseBody>> listMongoDBDatabases(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        Observable<Response<ResponseBody>> getMongoDBDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoDBDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        Observable<Response<ResponseBody>> createUpdateMongoDBDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoDBDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}")
        Observable<Response<ResponseBody>> beginCreateUpdateMongoDBDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoDBDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteMongoDBDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoDBDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteMongoDBDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBDatabaseThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> getMongoDBDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateMongoDBDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> updateMongoDBDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateMongoDBDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateMongoDBDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMongoDBCollections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections")
        Observable<Response<ResponseBody>> listMongoDBCollections(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBCollection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        Observable<Response<ResponseBody>> getMongoDBCollection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateMongoDBCollection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        Observable<Response<ResponseBody>> createUpdateMongoDBCollection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Body MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateMongoDBCollection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}")
        Observable<Response<ResponseBody>> beginCreateUpdateMongoDBCollection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Body MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteMongoDBCollection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteMongoDBCollection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteMongoDBCollection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteMongoDBCollection(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getMongoDBCollectionThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        Observable<Response<ResponseBody>> getMongoDBCollectionThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateMongoDBCollectionThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        Observable<Response<ResponseBody>> updateMongoDBCollectionThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateMongoDBCollectionThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/mongodb/databases/{databaseName}/collections/{collectionName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateMongoDBCollectionThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("collectionName") String collectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listTables" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables")
        Observable<Response<ResponseBody>> listTables(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getTable" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        Observable<Response<ResponseBody>> getTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateTable" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        Observable<Response<ResponseBody>> createUpdateTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Body TableCreateUpdateParameters createUpdateTableParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateTable" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}")
        Observable<Response<ResponseBody>> beginCreateUpdateTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Body TableCreateUpdateParameters createUpdateTableParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteTable" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteTable" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getTableThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> getTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateTableThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> updateTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateTableThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/table/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraKeyspaces" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces")
        Observable<Response<ResponseBody>> listCassandraKeyspaces(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraKeyspace" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        Observable<Response<ResponseBody>> getCassandraKeyspace(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraKeyspace" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        Observable<Response<ResponseBody>> createUpdateCassandraKeyspace(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Body CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraKeyspace" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}")
        Observable<Response<ResponseBody>> beginCreateUpdateCassandraKeyspace(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Body CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraKeyspace" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteCassandraKeyspace(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraKeyspace" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteCassandraKeyspace(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraKeyspaceThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        Observable<Response<ResponseBody>> getCassandraKeyspaceThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateCassandraKeyspaceThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        Observable<Response<ResponseBody>> updateCassandraKeyspaceThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateCassandraKeyspaceThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateCassandraKeyspaceThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listCassandraTables" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables")
        Observable<Response<ResponseBody>> listCassandraTables(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraTable" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        Observable<Response<ResponseBody>> getCassandraTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateCassandraTable" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        Observable<Response<ResponseBody>> createUpdateCassandraTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Body CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateCassandraTable" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}")
        Observable<Response<ResponseBody>> beginCreateUpdateCassandraTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Body CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteCassandraTable" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteCassandraTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteCassandraTable" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteCassandraTable(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getCassandraTableThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> getCassandraTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateCassandraTableThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> updateCassandraTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateCassandraTableThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/cassandra/keyspaces/{keyspaceName}/tables/{tableName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateCassandraTableThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("keyspaceName") String keyspaceName, @Path("tableName") String tableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinDatabases" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases")
        Observable<Response<ResponseBody>> listGremlinDatabases(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        Observable<Response<ResponseBody>> getGremlinDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        Observable<Response<ResponseBody>> createUpdateGremlinDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}")
        Observable<Response<ResponseBody>> beginCreateUpdateGremlinDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteGremlinDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteGremlinDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinDatabaseThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> getGremlinDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateGremlinDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> updateGremlinDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateGremlinDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateGremlinDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listGremlinGraphs" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs")
        Observable<Response<ResponseBody>> listGremlinGraphs(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinGraph" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        Observable<Response<ResponseBody>> getGremlinGraph(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createUpdateGremlinGraph" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        Observable<Response<ResponseBody>> createUpdateGremlinGraph(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Body GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateUpdateGremlinGraph" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}")
        Observable<Response<ResponseBody>> beginCreateUpdateGremlinGraph(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Body GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts deleteGremlinGraph" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteGremlinGraph(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDeleteGremlinGraph" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteGremlinGraph(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getGremlinGraphThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        Observable<Response<ResponseBody>> getGremlinGraphThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts updateGremlinGraphThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        Observable<Response<ResponseBody>> updateGremlinGraphThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdateGremlinGraphThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/apis/gremlin/databases/{databaseName}/graphs/{graphName}/settings/throughput")
        Observable<Response<ResponseBody>> beginUpdateGremlinGraphThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("graphName") String graphName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ThroughputUpdateParameters updateThroughputParameters, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountInner object if successful.
     */
    public DatabaseAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, final ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<DatabaseAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>() {
            @Override
            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<ServiceResponse<DatabaseAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountInner object if successful.
     */
    public DatabaseAccountInner patch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().last().body();
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, final ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DatabaseAccountInner> patchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return patchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map(new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>() {
            @Override
            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DatabaseAccountInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate(updateParameters);
        Observable<Response<ResponseBody>> observable = service.patch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>() { }.getType());
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountInner object if successful.
     */
    public DatabaseAccountInner beginPatch(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().single().body();
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters, final ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<DatabaseAccountInner> beginPatchAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map(new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>() {
            @Override
            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patches the properties of an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param updateParameters The tags parameter to patch for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<ServiceResponse<DatabaseAccountInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountPatchParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate(updateParameters);
        return service.beginPatch(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), updateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountInner> clientResponse = beginPatchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountInner> beginPatchDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountInner object if successful.
     */
    public DatabaseAccountInner createOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, final ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DatabaseAccountInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map(new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>() {
            @Override
            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DatabaseAccountInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateParameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountInner>() { }.getType());
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountInner object if successful.
     */
    public DatabaseAccountInner beginCreateOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, final ServiceCallback<DatabaseAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<DatabaseAccountInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map(new Func1<ServiceResponse<DatabaseAccountInner>, DatabaseAccountInner>() {
            @Override
            public DatabaseAccountInner call(ServiceResponse<DatabaseAccountInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateParameters The parameters to provide for the current database account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountInner object
     */
    public Observable<ServiceResponse<DatabaseAccountInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateParameters);
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String accountName) {
        deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return deleteWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String accountName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void failoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().last().body();
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        Observable<Response<ResponseBody>> observable = service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginFailoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().single().body();
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Changes the failover priority for the Azure Cosmos DB database account. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param failoverPolicies List of failover policies.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        return service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), failoverParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginFailoverPriorityChangeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginFailoverPriorityChangeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the subscription.
     *
     * @return the PagedList<DatabaseAccountInner> object if successful.
     */
    public PagedList<DatabaseAccountInner> list() {
        PageImpl<DatabaseAccountInner> page = new PageImpl<>();
        page.setItems(listWithServiceResponseAsync().toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page) {
            @Override
            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DatabaseAccountInner>> listAsync(final ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the subscription.
     *
     * @return the observable to the List&lt;DatabaseAccountInner&gt; object
     */
    public Observable<Page<DatabaseAccountInner>> listAsync() {
        return listWithServiceResponseAsync().map(new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>() {
            @Override
            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the subscription.
     *
     * @return the observable to the List&lt;DatabaseAccountInner&gt; object
     */
    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DatabaseAccountInner>> result = listDelegate(response);
                        List<DatabaseAccountInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<DatabaseAccountInner>> clientResponse = new ServiceResponse<List<DatabaseAccountInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DatabaseAccountInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DatabaseAccountInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the given resource group.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @return the PagedList<DatabaseAccountInner> object if successful.
     */
    public PagedList<DatabaseAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl<DatabaseAccountInner> page = new PageImpl<>();
        page.setItems(listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountInner>(page) {
            @Override
            public Page<DatabaseAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the given resource group.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName, final ServiceCallback<List<DatabaseAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the given resource group.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @return the observable to the List&lt;DatabaseAccountInner&gt; object
     */
    public Observable<Page<DatabaseAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName).map(new Func1<ServiceResponse<List<DatabaseAccountInner>>, Page<DatabaseAccountInner>>() {
            @Override
            public Page<DatabaseAccountInner> call(ServiceResponse<List<DatabaseAccountInner>> response) {
                PageImpl<DatabaseAccountInner> page = new PageImpl<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * Lists all the Azure Cosmos DB database accounts available under the given resource group.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @return the observable to the List&lt;DatabaseAccountInner&gt; object
     */
    public Observable<ServiceResponse<List<DatabaseAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<DatabaseAccountInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DatabaseAccountInner>> result = listByResourceGroupDelegate(response);
                        List<DatabaseAccountInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<DatabaseAccountInner>> clientResponse = new ServiceResponse<List<DatabaseAccountInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DatabaseAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DatabaseAccountInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DatabaseAccountInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountListKeysResultInner object if successful.
     */
    public DatabaseAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, final ServiceCallback<DatabaseAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListKeysResultInner object
     */
    public Observable<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<DatabaseAccountListKeysResultInner>, DatabaseAccountListKeysResultInner>() {
            @Override
            public DatabaseAccountListKeysResultInner call(ServiceResponse<DatabaseAccountListKeysResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListKeysResultInner object
     */
    public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListKeysResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountListKeysResultInner> clientResponse = listKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountListKeysResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountListKeysResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the connection strings for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountListConnectionStringsResultInner object if successful.
     */
    public DatabaseAccountListConnectionStringsResultInner listConnectionStrings(String resourceGroupName, String accountName) {
        return listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the connection strings for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName, final ServiceCallback<DatabaseAccountListConnectionStringsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the connection strings for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListConnectionStringsResultInner object
     */
    public Observable<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName) {
        return listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>, DatabaseAccountListConnectionStringsResultInner>() {
            @Override
            public DatabaseAccountListConnectionStringsResultInner call(ServiceResponse<DatabaseAccountListConnectionStringsResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the connection strings for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListConnectionStringsResultInner object
     */
    public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listConnectionStrings(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountListConnectionStringsResultInner> clientResponse = listConnectionStringsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountListConnectionStringsResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountListConnectionStringsResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void offlineRegion(String resourceGroupName, String accountName, String region) {
        offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last().body();
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> offlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        Observable<Response<ResponseBody>> observable = service.offlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginOfflineRegion(String resourceGroupName, String accountName, String region) {
        beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single().body();
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region) {
        return beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Offline the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginOfflineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        return service.beginOfflineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginOfflineRegionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginOfflineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void onlineRegion(String resourceGroupName, String accountName, String region) {
        onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last().body();
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> onlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        Observable<Response<ResponseBody>> observable = service.onlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginOnlineRegion(String resourceGroupName, String accountName, String region) {
        beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single().body();
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Online the specified region for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param region Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginOnlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        return service.beginOnlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginOnlineRegionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginOnlineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountListReadOnlyKeysResultInner object if successful.
     */
    public DatabaseAccountListReadOnlyKeysResultInner getReadOnlyKeys(String resourceGroupName, String accountName) {
        return getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName, final ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListReadOnlyKeysResultInner object
     */
    public Observable<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>() {
            @Override
            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListReadOnlyKeysResultInner object
     */
    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> getReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> clientResponse = getReadOnlyKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountListReadOnlyKeysResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseAccountListReadOnlyKeysResultInner object if successful.
     */
    public DatabaseAccountListReadOnlyKeysResultInner listReadOnlyKeys(String resourceGroupName, String accountName) {
        return listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName, final ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListReadOnlyKeysResultInner object
     */
    public Observable<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>() {
            @Override
            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the read-only access keys for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseAccountListReadOnlyKeysResultInner object
     */
    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> listReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> clientResponse = listReadOnlyKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseAccountListReadOnlyKeysResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void regenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().last().body();
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        Observable<Response<ResponseBody>> observable = service.regenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginRegenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().single().body();
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates an access key for the specified Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyKind The access key to regenerate. Possible values include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginRegenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        return service.beginRegenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginRegenerateKeyDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginRegenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks that the Azure Cosmos DB account name already exists. A valid account name may contain only lowercase letters, numbers, and the '-' character, and must be between 3 and 50 characters.
     *
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkNameExists(String accountName) {
        return checkNameExistsWithServiceResponseAsync(accountName).toBlocking().single().body();
    }

    /**
     * Checks that the Azure Cosmos DB account name already exists. A valid account name may contain only lowercase letters, numbers, and the '-' character, and must be between 3 and 50 characters.
     *
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkNameExistsAsync(String accountName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameExistsWithServiceResponseAsync(accountName), serviceCallback);
    }

    /**
     * Checks that the Azure Cosmos DB account name already exists. A valid account name may contain only lowercase letters, numbers, and the '-' character, and must be between 3 and 50 characters.
     *
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkNameExistsAsync(String accountName) {
        return checkNameExistsWithServiceResponseAsync(accountName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks that the Azure Cosmos DB account name already exists. A valid account name may contain only lowercase letters, numbers, and the '-' character, and must be between 3 and 50 characters.
     *
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkNameExistsWithServiceResponseAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkNameExists(accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkNameExistsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkNameExistsDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Retrieves the metrics determined by the given filter for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of metrics to return. The parameters that can be filtered are name.value (name of the metric, can have an or of multiple names), startTime, endTime, and timeGrain. The supported operator is eq.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MetricInner&gt; object if successful.
     */
    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String filter) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single().body();
    }

    /**
     * Retrieves the metrics determined by the given filter for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of metrics to return. The parameters that can be filtered are name.value (name of the metric, can have an or of multiple names), startTime, endTime, and timeGrain. The supported operator is eq.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter, final ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    /**
     * Retrieves the metrics determined by the given filter for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of metrics to return. The parameters that can be filtered are name.value (name of the metric, can have an or of multiple names), startTime, endTime, and timeGrain. The supported operator is eq.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricInner&gt; object
     */
    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).map(new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>() {
            @Override
            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the metrics determined by the given filter for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of metrics to return. The parameters that can be filtered are name.value (name of the metric, can have an or of multiple names), startTime, endTime, and timeGrain. The supported operator is eq.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricInner&gt; object
     */
    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        return service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MetricInner>> result = listMetricsDelegate(response);
                        List<MetricInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MetricInner>> clientResponse = new ServiceResponse<List<MetricInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MetricInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MetricInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;UsageInner&gt; object if successful.
     */
    public List<UsageInner> listUsages(String resourceGroupName, String accountName) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listUsagesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageInner&gt; object
     */
    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>() {
            @Override
            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listUsagesDelegate(response);
                        List<UsageInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<UsageInner>> clientResponse = new ServiceResponse<List<UsageInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of the metric, can have an or of multiple names).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;UsageInner&gt; object if successful.
     */
    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String filter) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single().body();
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of the metric, can have an or of multiple names).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter, final ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of the metric, can have an or of multiple names).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageInner&gt; object
     */
    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).map(new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>() {
            @Override
            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the usages (most recent data) for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param filter An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of the metric, can have an or of multiple names).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listUsagesDelegate(response);
                        List<UsageInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<UsageInner>> clientResponse = new ServiceResponse<List<UsageInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves metric definitions for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MetricDefinitionInner&gt; object if successful.
     */
    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName) {
        return listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Retrieves metric definitions for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, final ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Retrieves metric definitions for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricDefinitionInner&gt; object
     */
    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName) {
        return listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>() {
            @Override
            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves metric definitions for the given database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MetricDefinitionInner>> result = listMetricDefinitionsDelegate(response);
                        List<MetricDefinitionInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MetricDefinitionInner>> clientResponse = new ServiceResponse<List<MetricDefinitionInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MetricDefinitionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MetricDefinitionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlDatabaseInner&gt; object if successful.
     */
    public List<SqlDatabaseInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<SqlDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlDatabaseInner&gt; object
     */
    public Observable<List<SqlDatabaseInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<SqlDatabaseInner>>, List<SqlDatabaseInner>>() {
            @Override
            public List<SqlDatabaseInner> call(ServiceResponse<List<SqlDatabaseInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlDatabaseInner>>> listSqlDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSqlDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlDatabaseInner>> result = listSqlDatabasesDelegate(response);
                        List<SqlDatabaseInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlDatabaseInner>> clientResponse = new ServiceResponse<List<SqlDatabaseInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlDatabaseInner>> listSqlDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseInner object if successful.
     */
    public SqlDatabaseInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseInner object
     */
    public Observable<SqlDatabaseInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>() {
            @Override
            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseInner object
     */
    public Observable<ServiceResponse<SqlDatabaseInner>> getSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlDatabaseInner> clientResponse = getSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlDatabaseInner> getSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlDatabaseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseInner object if successful.
     */
    public SqlDatabaseInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, final ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlDatabaseInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map(new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>() {
            @Override
            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlDatabaseInner>> createUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlDatabaseParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlDatabaseInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseInner object if successful.
     */
    public SqlDatabaseInner beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, final ServiceCallback<SqlDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseInner object
     */
    public Observable<SqlDatabaseInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map(new Func1<ServiceResponse<SqlDatabaseInner>, SqlDatabaseInner>() {
            @Override
            public SqlDatabaseInner call(ServiceResponse<SqlDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseInner object
     */
    public Observable<ServiceResponse<SqlDatabaseInner>> beginCreateUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlDatabaseParameters);
        return service.beginCreateUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlDatabaseInner> clientResponse = beginCreateUpdateSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlDatabaseInner> beginCreateUpdateSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlDatabaseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getSqlDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateSqlDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlContainerInner&gt; object if successful.
     */
    public List<SqlContainerInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName) {
        return listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<List<SqlContainerInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlContainerInner&gt; object
     */
    public Observable<List<SqlContainerInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName) {
        return listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<List<SqlContainerInner>>, List<SqlContainerInner>>() {
            @Override
            public List<SqlContainerInner> call(ServiceResponse<List<SqlContainerInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlContainerInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlContainerInner>>> listSqlContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSqlContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlContainerInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlContainerInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlContainerInner>> result = listSqlContainersDelegate(response);
                        List<SqlContainerInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlContainerInner>> clientResponse = new ServiceResponse<List<SqlContainerInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlContainerInner>> listSqlContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlContainerInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlContainerInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerInner object if successful.
     */
    public SqlContainerInner getSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerInner object
     */
    public Observable<SqlContainerInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>() {
            @Override
            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerInner object
     */
    public Observable<ServiceResponse<SqlContainerInner>> getSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlContainerInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlContainerInner> clientResponse = getSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlContainerInner> getSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlContainerInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlContainerInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerInner object if successful.
     */
    public SqlContainerInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, final ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlContainerInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map(new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>() {
            @Override
            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlContainerInner>> createUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlContainerParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlContainerInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerInner object if successful.
     */
    public SqlContainerInner beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, final ServiceCallback<SqlContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerInner object
     */
    public Observable<SqlContainerInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map(new Func1<ServiceResponse<SqlContainerInner>, SqlContainerInner>() {
            @Override
            public SqlContainerInner call(ServiceResponse<SqlContainerInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerInner object
     */
    public Observable<ServiceResponse<SqlContainerInner>> beginCreateUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlContainerParameters);
        return service.beginCreateUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlContainerInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlContainerInner> clientResponse = beginCreateUpdateSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlContainerInner> beginCreateUpdateSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlContainerInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlContainerInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getSqlContainerThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        return beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateSqlContainerThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MongoDBDatabaseInner&gt; object if successful.
     */
    public List<MongoDBDatabaseInner> listMongoDBDatabases(String resourceGroupName, String accountName) {
        return listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MongoDBDatabaseInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<MongoDBDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MongoDBDatabaseInner&gt; object
     */
    public Observable<List<MongoDBDatabaseInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName) {
        return listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<MongoDBDatabaseInner>>, List<MongoDBDatabaseInner>>() {
            @Override
            public List<MongoDBDatabaseInner> call(ServiceResponse<List<MongoDBDatabaseInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MongoDBDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<List<MongoDBDatabaseInner>>> listMongoDBDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMongoDBDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MongoDBDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MongoDBDatabaseInner>> result = listMongoDBDatabasesDelegate(response);
                        List<MongoDBDatabaseInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MongoDBDatabaseInner>> clientResponse = new ServiceResponse<List<MongoDBDatabaseInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MongoDBDatabaseInner>> listMongoDBDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MongoDBDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MongoDBDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBDatabaseInner object if successful.
     */
    public MongoDBDatabaseInner getMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBDatabaseInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBDatabaseInner object
     */
    public Observable<MongoDBDatabaseInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>() {
            @Override
            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBDatabaseInner object
     */
    public Observable<ServiceResponse<MongoDBDatabaseInner>> getMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<MongoDBDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MongoDBDatabaseInner> clientResponse = getMongoDBDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MongoDBDatabaseInner> getMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MongoDBDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MongoDBDatabaseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBDatabaseInner object if successful.
     */
    public MongoDBDatabaseInner createUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().last().body();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBDatabaseInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, final ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<MongoDBDatabaseInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map(new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>() {
            @Override
            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<MongoDBDatabaseInner>> createUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateMongoDBDatabaseParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBDatabaseInner>() { }.getType());
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBDatabaseInner object if successful.
     */
    public MongoDBDatabaseInner beginCreateUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().single().body();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, final ServiceCallback<MongoDBDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBDatabaseInner object
     */
    public Observable<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map(new Func1<ServiceResponse<MongoDBDatabaseInner>, MongoDBDatabaseInner>() {
            @Override
            public MongoDBDatabaseInner call(ServiceResponse<MongoDBDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBDatabaseInner object
     */
    public Observable<ServiceResponse<MongoDBDatabaseInner>> beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateMongoDBDatabaseParameters);
        return service.beginCreateUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<MongoDBDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MongoDBDatabaseInner> clientResponse = beginCreateUpdateMongoDBDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MongoDBDatabaseInner> beginCreateUpdateMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MongoDBDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MongoDBDatabaseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteMongoDBDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getMongoDBDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateMongoDBDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MongoDBCollectionInner&gt; object if successful.
     */
    public List<MongoDBCollectionInner> listMongoDBCollections(String resourceGroupName, String accountName, String databaseName) {
        return listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MongoDBCollectionInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<List<MongoDBCollectionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MongoDBCollectionInner&gt; object
     */
    public Observable<List<MongoDBCollectionInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName) {
        return listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<List<MongoDBCollectionInner>>, List<MongoDBCollectionInner>>() {
            @Override
            public List<MongoDBCollectionInner> call(ServiceResponse<List<MongoDBCollectionInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MongoDBCollectionInner&gt; object
     */
    public Observable<ServiceResponse<List<MongoDBCollectionInner>>> listMongoDBCollectionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMongoDBCollections(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBCollectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MongoDBCollectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MongoDBCollectionInner>> result = listMongoDBCollectionsDelegate(response);
                        List<MongoDBCollectionInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MongoDBCollectionInner>> clientResponse = new ServiceResponse<List<MongoDBCollectionInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MongoDBCollectionInner>> listMongoDBCollectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MongoDBCollectionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MongoDBCollectionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBCollectionInner object if successful.
     */
    public MongoDBCollectionInner getMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single().body();
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBCollectionInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, final ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBCollectionInner object
     */
    public Observable<MongoDBCollectionInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map(new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>() {
            @Override
            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBCollectionInner object
     */
    public Observable<ServiceResponse<MongoDBCollectionInner>> getMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionInner>>>() {
                @Override
                public Observable<ServiceResponse<MongoDBCollectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MongoDBCollectionInner> clientResponse = getMongoDBCollectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MongoDBCollectionInner> getMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MongoDBCollectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MongoDBCollectionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBCollectionInner object if successful.
     */
    public MongoDBCollectionInner createUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBCollectionInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, final ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<MongoDBCollectionInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map(new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>() {
            @Override
            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<MongoDBCollectionInner>> createUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateMongoDBCollectionParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBCollectionInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MongoDBCollectionInner object if successful.
     */
    public MongoDBCollectionInner beginCreateUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, final ServiceCallback<MongoDBCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBCollectionInner object
     */
    public Observable<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map(new Func1<ServiceResponse<MongoDBCollectionInner>, MongoDBCollectionInner>() {
            @Override
            public MongoDBCollectionInner call(ServiceResponse<MongoDBCollectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MongoDBCollectionInner object
     */
    public Observable<ServiceResponse<MongoDBCollectionInner>> beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateMongoDBCollectionParameters);
        return service.beginCreateUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionInner>>>() {
                @Override
                public Observable<ServiceResponse<MongoDBCollectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MongoDBCollectionInner> clientResponse = beginCreateUpdateMongoDBCollectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MongoDBCollectionInner> beginCreateUpdateMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MongoDBCollectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MongoDBCollectionInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteMongoDBCollectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getMongoDBCollectionThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).toBlocking().last().body();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource), serviceCallback);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).toBlocking().single().body();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource), serviceCallback);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        return beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateMongoDBCollectionThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Tables under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;TableInner&gt; object if successful.
     */
    public List<TableInner> listTables(String resourceGroupName, String accountName) {
        return listTablesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the Tables under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<TableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listTablesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the Tables under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;TableInner&gt; object
     */
    public Observable<List<TableInner>> listTablesAsync(String resourceGroupName, String accountName) {
        return listTablesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<TableInner>>, List<TableInner>>() {
            @Override
            public List<TableInner> call(ServiceResponse<List<TableInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the Tables under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;TableInner&gt; object
     */
    public Observable<ServiceResponse<List<TableInner>>> listTablesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listTables(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<TableInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<TableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<TableInner>> result = listTablesDelegate(response);
                        List<TableInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<TableInner>> clientResponse = new ServiceResponse<List<TableInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<TableInner>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<TableInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<TableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Tables under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TableInner object if successful.
     */
    public TableInner getTable(String resourceGroupName, String accountName, String tableName) {
        return getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single().body();
    }

    /**
     * Gets the Tables under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableName, final ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    /**
     * Gets the Tables under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TableInner object
     */
    public Observable<TableInner> getTableAsync(String resourceGroupName, String accountName, String tableName) {
        return getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map(new Func1<ServiceResponse<TableInner>, TableInner>() {
            @Override
            public TableInner call(ServiceResponse<TableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Tables under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TableInner object
     */
    public Observable<ServiceResponse<TableInner>> getTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>() {
                @Override
                public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TableInner> clientResponse = getTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TableInner> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TableInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TableInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TableInner object if successful.
     */
    public TableInner createUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, final ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<TableInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map(new Func1<ServiceResponse<TableInner>, TableInner>() {
            @Override
            public TableInner call(ServiceResponse<TableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<TableInner>> createUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateTableParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TableInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TableInner object if successful.
     */
    public TableInner beginCreateUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, final ServiceCallback<TableInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TableInner object
     */
    public Observable<TableInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map(new Func1<ServiceResponse<TableInner>, TableInner>() {
            @Override
            public TableInner call(ServiceResponse<TableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateTableParameters The parameters to provide for the current Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TableInner object
     */
    public Observable<ServiceResponse<TableInner>> beginCreateUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateTableParameters);
        return service.beginCreateUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableInner>>>() {
                @Override
                public Observable<ServiceResponse<TableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TableInner> clientResponse = beginCreateUpdateTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TableInner> beginCreateUpdateTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TableInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TableInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteTable(String resourceGroupName, String accountName, String tableName) {
        deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteTable(String resourceGroupName, String accountName, String tableName) {
        beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the Table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getTableThroughput(String resourceGroupName, String accountName, String tableName) {
        return getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the Table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the Table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName) {
        return getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the Table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getTableThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        return beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateTableThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Cassandra keyspaces under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;CassandraKeyspaceInner&gt; object if successful.
     */
    public List<CassandraKeyspaceInner> listCassandraKeyspaces(String resourceGroupName, String accountName) {
        return listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the Cassandra keyspaces under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<CassandraKeyspaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the Cassandra keyspaces under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CassandraKeyspaceInner&gt; object
     */
    public Observable<List<CassandraKeyspaceInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName) {
        return listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<CassandraKeyspaceInner>>, List<CassandraKeyspaceInner>>() {
            @Override
            public List<CassandraKeyspaceInner> call(ServiceResponse<List<CassandraKeyspaceInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the Cassandra keyspaces under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CassandraKeyspaceInner&gt; object
     */
    public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> listCassandraKeyspacesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listCassandraKeyspaces(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraKeyspaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<CassandraKeyspaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CassandraKeyspaceInner>> result = listCassandraKeyspacesDelegate(response);
                        List<CassandraKeyspaceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<CassandraKeyspaceInner>> clientResponse = new ServiceResponse<List<CassandraKeyspaceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CassandraKeyspaceInner>> listCassandraKeyspacesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CassandraKeyspaceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CassandraKeyspaceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraKeyspaceInner object if successful.
     */
    public CassandraKeyspaceInner getCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        return getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single().body();
    }

    /**
     * Gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, final ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    /**
     * Gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraKeyspaceInner object
     */
    public Observable<CassandraKeyspaceInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map(new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>() {
            @Override
            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraKeyspaceInner object
     */
    public Observable<ServiceResponse<CassandraKeyspaceInner>> getCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>() {
                @Override
                public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CassandraKeyspaceInner> clientResponse = getCassandraKeyspaceDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CassandraKeyspaceInner> getCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CassandraKeyspaceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CassandraKeyspaceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraKeyspaceInner object if successful.
     */
    public CassandraKeyspaceInner createUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, final ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CassandraKeyspaceInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map(new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>() {
            @Override
            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CassandraKeyspaceInner>> createUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateCassandraKeyspaceParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraKeyspaceInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraKeyspaceInner object if successful.
     */
    public CassandraKeyspaceInner beginCreateUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, final ServiceCallback<CassandraKeyspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraKeyspaceInner object
     */
    public Observable<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map(new Func1<ServiceResponse<CassandraKeyspaceInner>, CassandraKeyspaceInner>() {
            @Override
            public CassandraKeyspaceInner call(ServiceResponse<CassandraKeyspaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param createUpdateCassandraKeyspaceParameters The parameters to provide for the current Cassandra keyspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraKeyspaceInner object
     */
    public Observable<ServiceResponse<CassandraKeyspaceInner>> beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateCassandraKeyspaceParameters);
        return service.beginCreateUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceInner>>>() {
                @Override
                public Observable<ServiceResponse<CassandraKeyspaceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CassandraKeyspaceInner> clientResponse = beginCreateUpdateCassandraKeyspaceDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CassandraKeyspaceInner> beginCreateUpdateCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CassandraKeyspaceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CassandraKeyspaceInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteCassandraKeyspaceDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the Cassandra Keyspace under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName) {
        return getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the Cassandra Keyspace under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the Cassandra Keyspace under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the Cassandra Keyspace under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getCassandraKeyspaceThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        return beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra Keyspace.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateCassandraKeyspaceThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;CassandraTableInner&gt; object if successful.
     */
    public List<CassandraTableInner> listCassandraTables(String resourceGroupName, String accountName, String keyspaceName) {
        return listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single().body();
    }

    /**
     * Lists the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName, final ServiceCallback<List<CassandraTableInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    /**
     * Lists the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CassandraTableInner&gt; object
     */
    public Observable<List<CassandraTableInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map(new Func1<ServiceResponse<List<CassandraTableInner>>, List<CassandraTableInner>>() {
            @Override
            public List<CassandraTableInner> call(ServiceResponse<List<CassandraTableInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CassandraTableInner&gt; object
     */
    public Observable<ServiceResponse<List<CassandraTableInner>>> listCassandraTablesWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listCassandraTables(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraTableInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<CassandraTableInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CassandraTableInner>> result = listCassandraTablesDelegate(response);
                        List<CassandraTableInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<CassandraTableInner>> clientResponse = new ServiceResponse<List<CassandraTableInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CassandraTableInner>> listCassandraTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CassandraTableInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CassandraTableInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraTableInner object if successful.
     */
    public CassandraTableInner getCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single().body();
    }

    /**
     * Gets the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, final ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    /**
     * Gets the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraTableInner object
     */
    public Observable<CassandraTableInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map(new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>() {
            @Override
            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Cassandra table under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraTableInner object
     */
    public Observable<ServiceResponse<CassandraTableInner>> getCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>() {
                @Override
                public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CassandraTableInner> clientResponse = getCassandraTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CassandraTableInner> getCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CassandraTableInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CassandraTableInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraTableInner object if successful.
     */
    public CassandraTableInner createUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, final ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CassandraTableInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map(new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>() {
            @Override
            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CassandraTableInner>> createUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateCassandraTableParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraTableInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CassandraTableInner object if successful.
     */
    public CassandraTableInner beginCreateUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, final ServiceCallback<CassandraTableInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraTableInner object
     */
    public Observable<CassandraTableInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map(new Func1<ServiceResponse<CassandraTableInner>, CassandraTableInner>() {
            @Override
            public CassandraTableInner call(ServiceResponse<CassandraTableInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Cassandra Table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param createUpdateCassandraTableParameters The parameters to provide for the current Cassandra Table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CassandraTableInner object
     */
    public Observable<ServiceResponse<CassandraTableInner>> beginCreateUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateCassandraTableParameters);
        return service.beginCreateUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableInner>>>() {
                @Override
                public Observable<ServiceResponse<CassandraTableInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CassandraTableInner> clientResponse = beginCreateUpdateCassandraTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CassandraTableInner> beginCreateUpdateCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CassandraTableInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CassandraTableInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteCassandraTableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the Cassandra table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the Cassandra table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the Cassandra table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the Cassandra table under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getCassandraTableThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        return beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Cassandra table.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param tableName Cosmos DB table name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateCassandraTableThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;GremlinDatabaseInner&gt; object if successful.
     */
    public List<GremlinDatabaseInner> listGremlinDatabases(String resourceGroupName, String accountName) {
        return listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<GremlinDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;GremlinDatabaseInner&gt; object
     */
    public Observable<List<GremlinDatabaseInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName) {
        return listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<GremlinDatabaseInner>>, List<GremlinDatabaseInner>>() {
            @Override
            public List<GremlinDatabaseInner> call(ServiceResponse<List<GremlinDatabaseInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;GremlinDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<List<GremlinDatabaseInner>>> listGremlinDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listGremlinDatabases(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<GremlinDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<GremlinDatabaseInner>> result = listGremlinDatabasesDelegate(response);
                        List<GremlinDatabaseInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<GremlinDatabaseInner>> clientResponse = new ServiceResponse<List<GremlinDatabaseInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<GremlinDatabaseInner>> listGremlinDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<GremlinDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<GremlinDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinDatabaseInner object if successful.
     */
    public GremlinDatabaseInner getGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinDatabaseInner object
     */
    public Observable<GremlinDatabaseInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>() {
            @Override
            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinDatabaseInner object
     */
    public Observable<ServiceResponse<GremlinDatabaseInner>> getGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GremlinDatabaseInner> clientResponse = getGremlinDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GremlinDatabaseInner> getGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GremlinDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GremlinDatabaseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinDatabaseInner object if successful.
     */
    public GremlinDatabaseInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, final ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GremlinDatabaseInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map(new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>() {
            @Override
            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GremlinDatabaseInner>> createUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateGremlinDatabaseParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinDatabaseInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinDatabaseInner object if successful.
     */
    public GremlinDatabaseInner beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, final ServiceCallback<GremlinDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinDatabaseInner object
     */
    public Observable<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map(new Func1<ServiceResponse<GremlinDatabaseInner>, GremlinDatabaseInner>() {
            @Override
            public GremlinDatabaseInner call(ServiceResponse<GremlinDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinDatabaseInner object
     */
    public Observable<ServiceResponse<GremlinDatabaseInner>> beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateGremlinDatabaseParameters);
        return service.beginCreateUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<GremlinDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GremlinDatabaseInner> clientResponse = beginCreateUpdateGremlinDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GremlinDatabaseInner> beginCreateUpdateGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GremlinDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GremlinDatabaseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteGremlinDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getGremlinDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        return beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateGremlinDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;GremlinGraphInner&gt; object if successful.
     */
    public List<GremlinGraphInner> listGremlinGraphs(String resourceGroupName, String accountName, String databaseName) {
        return listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GremlinGraphInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<List<GremlinGraphInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;GremlinGraphInner&gt; object
     */
    public Observable<List<GremlinGraphInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName) {
        return listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<List<GremlinGraphInner>>, List<GremlinGraphInner>>() {
            @Override
            public List<GremlinGraphInner> call(ServiceResponse<List<GremlinGraphInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;GremlinGraphInner&gt; object
     */
    public Observable<ServiceResponse<List<GremlinGraphInner>>> listGremlinGraphsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listGremlinGraphs(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinGraphInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<GremlinGraphInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<GremlinGraphInner>> result = listGremlinGraphsDelegate(response);
                        List<GremlinGraphInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<GremlinGraphInner>> clientResponse = new ServiceResponse<List<GremlinGraphInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<GremlinGraphInner>> listGremlinGraphsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<GremlinGraphInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<GremlinGraphInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinGraphInner object if successful.
     */
    public GremlinGraphInner getGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single().body();
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinGraphInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, final ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinGraphInner object
     */
    public Observable<GremlinGraphInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map(new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>() {
            @Override
            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinGraphInner object
     */
    public Observable<ServiceResponse<GremlinGraphInner>> getGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphInner>>>() {
                @Override
                public Observable<ServiceResponse<GremlinGraphInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GremlinGraphInner> clientResponse = getGremlinGraphDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GremlinGraphInner> getGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GremlinGraphInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GremlinGraphInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinGraphInner object if successful.
     */
    public GremlinGraphInner createUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinGraphInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, final ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GremlinGraphInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map(new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>() {
            @Override
            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GremlinGraphInner>> createUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateGremlinGraphParameters);
        Observable<Response<ResponseBody>> observable = service.createUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinGraphInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GremlinGraphInner object if successful.
     */
    public GremlinGraphInner beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GremlinGraphInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, final ServiceCallback<GremlinGraphInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinGraphInner object
     */
    public Observable<GremlinGraphInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map(new Func1<ServiceResponse<GremlinGraphInner>, GremlinGraphInner>() {
            @Override
            public GremlinGraphInner call(ServiceResponse<GremlinGraphInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GremlinGraphInner object
     */
    public Observable<ServiceResponse<GremlinGraphInner>> beginCreateUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateGremlinGraphParameters);
        return service.beginCreateUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphInner>>>() {
                @Override
                public Observable<ServiceResponse<GremlinGraphInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GremlinGraphInner> clientResponse = beginCreateUpdateGremlinGraphDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GremlinGraphInner> beginCreateUpdateGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GremlinGraphInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GremlinGraphInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteGremlinGraphDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner getGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single().body();
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> getGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = getGremlinGraphThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> getGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner updateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputInner>> updateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        Observable<Response<ResponseBody>> observable = service.updateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputInner object if successful.
     */
    public ThroughputInner beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource, final ServiceCallback<ThroughputInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ThroughputInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        return beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, resource).map(new Func1<ServiceResponse<ThroughputInner>, ThroughputInner>() {
            @Override
            public ThroughputInner call(ServiceResponse<ThroughputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resource The standard JSON format of a resource throughput
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputInner object
     */
    public Observable<ServiceResponse<ThroughputInner>> beginUpdateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputResource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate(resource);
        ThroughputUpdateParameters updateThroughputParameters = new ThroughputUpdateParameters();
        updateThroughputParameters.withResource(resource);
        return service.beginUpdateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, this.client.apiVersion(), this.client.acceptLanguage(), updateThroughputParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputInner> clientResponse = beginUpdateGremlinGraphThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputInner> beginUpdateGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
