/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * An Azure Cosmos DB resource throughput.
 */
@JsonFlatten
@SkipParentValidation
public class ThroughputInner extends Resource {
    /**
     * Value of the Cosmos DB resource throughput.
     */
    @JsonProperty(value = "properties.throughput", required = true)
    private int throughput;

    /**
     * Get value of the Cosmos DB resource throughput.
     *
     * @return the throughput value
     */
    public int throughput() {
        return this.throughput;
    }

    /**
     * Set value of the Cosmos DB resource throughput.
     *
     * @param throughput the throughput value to set
     * @return the ThroughputInner object itself.
     */
    public ThroughputInner withThroughput(int throughput) {
        this.throughput = throughput;
        return this;
    }

}
