/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cosmos DB Cassandra table cluster key.
 */
public class ClusterKey {
    /**
     * Name of the Cosmos DB Cassandra table cluster key.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Order of the Cosmos DB Cassandra table cluster key, only support "Asc"
     * and "Desc".
     */
    @JsonProperty(value = "orderBy")
    private String orderBy;

    /**
     * Get name of the Cosmos DB Cassandra table cluster key.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set name of the Cosmos DB Cassandra table cluster key.
     *
     * @param name the name value to set
     * @return the ClusterKey object itself.
     */
    public ClusterKey withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc".
     *
     * @return the orderBy value
     */
    public String orderBy() {
        return this.orderBy;
    }

    /**
     * Set order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc".
     *
     * @param orderBy the orderBy value to set
     * @return the ClusterKey object itself.
     */
    public ClusterKey withOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

}
