/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for IndexingMode.
 */
public final class IndexingMode extends ExpandableStringEnum<IndexingMode> {
    /** Static value Consistent for IndexingMode. */
    public static final IndexingMode CONSISTENT = fromString("Consistent");

    /** Static value Lazy for IndexingMode. */
    public static final IndexingMode LAZY = fromString("Lazy");

    /** Static value None for IndexingMode. */
    public static final IndexingMode NONE = fromString("None");

    /**
     * Creates or finds a IndexingMode from its string representation.
     * @param name a name to look for
     * @return the corresponding IndexingMode
     */
    @JsonCreator
    public static IndexingMode fromString(String name) {
        return fromString(name, IndexingMode.class);
    }

    /**
     * @return known IndexingMode values
     */
    public static Collection<IndexingMode> values() {
        return values(IndexingMode.class);
    }
}
