/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.GremlinDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.GremlinGraphCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.GremlinDatabaseGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.GremlinGraphGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputSettingsGetResultsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class GremlinResourcesInner {
    private GremlinResourcesService service;
    private CosmosDBImpl client;

    public GremlinResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (GremlinResourcesService)retrofit.create(GremlinResourcesService.class);
        this.client = client;
    }

    public List<GremlinDatabaseGetResultsInner> listGremlinDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GremlinDatabaseGetResultsInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<GremlinDatabaseGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<GremlinDatabaseGetResultsInner>> listGremlinDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listGremlinDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<GremlinDatabaseGetResultsInner>>, List<GremlinDatabaseGetResultsInner>>(){

            public List<GremlinDatabaseGetResultsInner> call(ServiceResponse<List<GremlinDatabaseGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GremlinDatabaseGetResultsInner>>> listGremlinDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listGremlinDatabases(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinDatabaseGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<GremlinDatabaseGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GremlinResourcesInner.this.listGremlinDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GremlinDatabaseGetResultsInner>> listGremlinDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GremlinDatabaseGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseGetResultsInner getGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (GremlinDatabaseGetResultsInner)((Object)((ServiceResponse)this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseGetResultsInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<GremlinDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<GremlinDatabaseGetResultsInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>(){

            public GremlinDatabaseGetResultsInner call(ServiceResponse<GremlinDatabaseGetResultsInner> response) {
                return (GremlinDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.getGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseGetResultsInner> getGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseGetResultsInner)((Object)((ServiceResponse)this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.createUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>(){

            public GremlinDatabaseGetResultsInner call(ServiceResponse<GremlinDatabaseGetResultsInner> response) {
                return (GremlinDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseGetResultsInner>> createUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateGremlinDatabaseParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinDatabaseGetResultsInner>(){}.getType());
    }

    public GremlinDatabaseGetResultsInner beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return (GremlinDatabaseGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, ServiceCallback<GremlinDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters), serviceCallback);
    }

    public Observable<GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this.beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters).map((Func1)new Func1<ServiceResponse<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>(){

            public GremlinDatabaseGetResultsInner call(ServiceResponse<GremlinDatabaseGetResultsInner> response) {
                return (GremlinDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinDatabaseGetResultsInner>> beginCreateUpdateGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateGremlinDatabaseParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateGremlinDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<GremlinDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginCreateUpdateGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinDatabaseGetResultsInner> beginCreateUpdateGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinDatabaseGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteGremlinDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteGremlinDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginDeleteGremlinDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.getGremlinDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateGremlinDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateGremlinDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginUpdateGremlinDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateGremlinDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<GremlinGraphGetResultsInner> listGremlinGraphs(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GremlinGraphGetResultsInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<GremlinGraphGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<GremlinGraphGetResultsInner>> listGremlinGraphsAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listGremlinGraphsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<GremlinGraphGetResultsInner>>, List<GremlinGraphGetResultsInner>>(){

            public List<GremlinGraphGetResultsInner> call(ServiceResponse<List<GremlinGraphGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GremlinGraphGetResultsInner>>> listGremlinGraphsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listGremlinGraphs(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GremlinGraphGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<GremlinGraphGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GremlinResourcesInner.this.listGremlinGraphsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GremlinGraphGetResultsInner>> listGremlinGraphsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GremlinGraphGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinGraphGetResultsInner getGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (GremlinGraphGetResultsInner)((Object)((ServiceResponse)this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinGraphGetResultsInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<GremlinGraphGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<GremlinGraphGetResultsInner> getGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>(){

            public GremlinGraphGetResultsInner call(ServiceResponse<GremlinGraphGetResultsInner> response) {
                return (GremlinGraphGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphGetResultsInner>> getGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphGetResultsInner>>>(){

            public Observable<ServiceResponse<GremlinGraphGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.getGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinGraphGetResultsInner> getGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinGraphGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GremlinGraphGetResultsInner createUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return (GremlinGraphGetResultsInner)((Object)((ServiceResponse)this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().last()).body());
    }

    public ServiceFuture<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, ServiceCallback<GremlinGraphGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    public Observable<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.createUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map((Func1)new Func1<ServiceResponse<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>(){

            public GremlinGraphGetResultsInner call(ServiceResponse<GremlinGraphGetResultsInner> response) {
                return (GremlinGraphGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphGetResultsInner>> createUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateGremlinGraphParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GremlinGraphGetResultsInner>(){}.getType());
    }

    public GremlinGraphGetResultsInner beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return (GremlinGraphGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).toBlocking().single()).body());
    }

    public ServiceFuture<GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, ServiceCallback<GremlinGraphGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters), serviceCallback);
    }

    public Observable<GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this.beginCreateUpdateGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters).map((Func1)new Func1<ServiceResponse<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>(){

            public GremlinGraphGetResultsInner call(ServiceResponse<GremlinGraphGetResultsInner> response) {
                return (GremlinGraphGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GremlinGraphGetResultsInner>> beginCreateUpdateGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (createUpdateGremlinGraphParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateGremlinGraphParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateGremlinGraphParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", createUpdateGremlinGraphParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GremlinGraphGetResultsInner>>>(){

            public Observable<ServiceResponse<GremlinGraphGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginCreateUpdateGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GremlinGraphGetResultsInner> beginCreateUpdateGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GremlinGraphGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        ((ServiceResponse)this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.deleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName) {
        ((ServiceResponse)this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.beginDeleteGremlinGraphWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteGremlinGraphWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteGremlinGraph(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginDeleteGremlinGraphDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteGremlinGraphDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        return this.getGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.getGremlinGraphThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateGremlinGraphThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateGremlinGraphThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (graphName == null) {
            throw new IllegalArgumentException("Parameter graphName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateGremlinGraphThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, graphName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GremlinResourcesInner.this.beginUpdateGremlinGraphThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateGremlinGraphThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GremlinResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources listGremlinDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases")
        public Observable<Response<ResponseBody>> listGremlinDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources getGremlinDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> getGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources createUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginCreateUpdateGremlinDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body GremlinDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources deleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginDeleteGremlinDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources getGremlinDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources updateGremlinDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginUpdateGremlinDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateGremlinDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources listGremlinGraphs"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs")
        public Observable<Response<ResponseBody>> listGremlinGraphs(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources getGremlinGraph"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> getGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources createUpdateGremlinGraph"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> createUpdateGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body GremlinGraphCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginCreateUpdateGremlinGraph"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body GremlinGraphCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources deleteGremlinGraph"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginDeleteGremlinGraph"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteGremlinGraph(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources getGremlinGraphThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources updateGremlinGraphThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.GremlinResources beginUpdateGremlinGraphThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateGremlinGraphThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="graphName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

