/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.SqlContainerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlStoredProcedureCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlTriggerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlUserDefinedFunctionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in SqlResources.
 */
public class SqlResourcesInner {
    /** The Retrofit service to perform REST calls. */
    private SqlResourcesService service;
    /** The service client containing this operation class. */
    private CosmosDBImpl client;

    /**
     * Initializes an instance of SqlResourcesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SqlResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = retrofit.create(SqlResourcesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlResources to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SqlResourcesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlDatabases" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases")
        Observable<Response<ResponseBody>> listSqlDatabases(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        Observable<Response<ResponseBody>> getSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        Observable<Response<ResponseBody>> createUpdateSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlDatabase" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlDatabase" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlDatabase(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlDatabaseThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        Observable<Response<ResponseBody>> getSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources updateSqlDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        Observable<Response<ResponseBody>> updateSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body ThroughputSettingsUpdateParameters updateThroughputParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginUpdateSqlDatabaseThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        Observable<Response<ResponseBody>> beginUpdateSqlDatabaseThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Body ThroughputSettingsUpdateParameters updateThroughputParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlContainers" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers")
        Observable<Response<ResponseBody>> listSqlContainers(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlContainer" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> getSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlContainer" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> createUpdateSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlContainer" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlContainer" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlContainer" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlContainer(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlContainerThroughput" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        Observable<Response<ResponseBody>> getSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources updateSqlContainerThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        Observable<Response<ResponseBody>> updateSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body ThroughputSettingsUpdateParameters updateThroughputParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginUpdateSqlContainerThroughput" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        Observable<Response<ResponseBody>> beginUpdateSqlContainerThroughput(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body ThroughputSettingsUpdateParameters updateThroughputParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlStoredProcedures" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/")
        Observable<Response<ResponseBody>> listSqlStoredProcedures(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlStoredProcedure" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        Observable<Response<ResponseBody>> getSqlStoredProcedure(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("storedProcedureName") String storedProcedureName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlStoredProcedure" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        Observable<Response<ResponseBody>> createUpdateSqlStoredProcedure(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("storedProcedureName") String storedProcedureName, @Query("api-version") String apiVersion, @Body SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlStoredProcedure" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlStoredProcedure(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("storedProcedureName") String storedProcedureName, @Query("api-version") String apiVersion, @Body SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlStoredProcedure" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlStoredProcedure(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("storedProcedureName") String storedProcedureName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlStoredProcedure" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlStoredProcedure(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("storedProcedureName") String storedProcedureName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlUserDefinedFunctions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/")
        Observable<Response<ResponseBody>> listSqlUserDefinedFunctions(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlUserDefinedFunction" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        Observable<Response<ResponseBody>> getSqlUserDefinedFunction(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("userDefinedFunctionName") String userDefinedFunctionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlUserDefinedFunction" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        Observable<Response<ResponseBody>> createUpdateSqlUserDefinedFunction(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("userDefinedFunctionName") String userDefinedFunctionName, @Query("api-version") String apiVersion, @Body SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlUserDefinedFunction" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlUserDefinedFunction(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("userDefinedFunctionName") String userDefinedFunctionName, @Query("api-version") String apiVersion, @Body SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlUserDefinedFunction" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlUserDefinedFunction(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("userDefinedFunctionName") String userDefinedFunctionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlUserDefinedFunction" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlUserDefinedFunction(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("userDefinedFunctionName") String userDefinedFunctionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlTriggers" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/")
        Observable<Response<ResponseBody>> listSqlTriggers(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlTrigger" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        Observable<Response<ResponseBody>> getSqlTrigger(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("triggerName") String triggerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlTrigger" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        Observable<Response<ResponseBody>> createUpdateSqlTrigger(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("triggerName") String triggerName, @Query("api-version") String apiVersion, @Body SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlTrigger" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        Observable<Response<ResponseBody>> beginCreateUpdateSqlTrigger(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("triggerName") String triggerName, @Query("api-version") String apiVersion, @Body SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlTrigger" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSqlTrigger(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("triggerName") String triggerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlTrigger" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteSqlTrigger(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("databaseName") String databaseName, @Path("containerName") String containerName, @Path("triggerName") String triggerName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlDatabaseGetResultsInner&gt; object if successful.
     */
    public List<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlDatabaseGetResultsInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName, final ServiceCallback<List<SqlDatabaseGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlDatabaseGetResultsInner&gt; object
     */
    public Observable<List<SqlDatabaseGetResultsInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<SqlDatabaseGetResultsInner>>, List<SqlDatabaseGetResultsInner>>() {
            @Override
            public List<SqlDatabaseGetResultsInner> call(ServiceResponse<List<SqlDatabaseGetResultsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlDatabaseGetResultsInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>> listSqlDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.listSqlDatabases(this.client.subscriptionId(), resourceGroupName, accountName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlDatabaseGetResultsInner>> result = listSqlDatabasesDelegate(response);
                        List<SqlDatabaseGetResultsInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlDatabaseGetResultsInner>> clientResponse = new ServiceResponse<List<SqlDatabaseGetResultsInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlDatabaseGetResultsInner>> listSqlDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlDatabaseGetResultsInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlDatabaseGetResultsInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseGetResultsInner object if successful.
     */
    public SqlDatabaseGetResultsInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseGetResultsInner object
     */
    public Observable<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>() {
            @Override
            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseGetResultsInner object
     */
    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> getSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlDatabaseGetResultsInner> clientResponse = getSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlDatabaseGetResultsInner> getSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlDatabaseGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlDatabaseGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseGetResultsInner object if successful.
     */
    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, final ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map(new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>() {
            @Override
            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> createUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlDatabaseParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlDatabaseGetResultsInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlDatabaseGetResultsInner object if successful.
     */
    public SqlDatabaseGetResultsInner beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, final ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseGetResultsInner object
     */
    public Observable<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map(new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>() {
            @Override
            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlDatabaseGetResultsInner object
     */
    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> beginCreateUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlDatabaseParameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlDatabaseGetResultsInner> clientResponse = beginCreateUpdateSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlDatabaseGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlDatabaseGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.deleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDeleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlDatabaseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner getSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputSettingsGetResultsInner> clientResponse = getSqlDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputSettingsGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate(updateThroughputParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.updateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate(updateThroughputParameters);
        final String apiVersion = "2019-08-01";
        return service.beginUpdateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputSettingsGetResultsInner> clientResponse = beginUpdateSqlDatabaseThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputSettingsGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlContainerGetResultsInner&gt; object if successful.
     */
    public List<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName) {
        return listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single().body();
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlContainerGetResultsInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName, final ServiceCallback<List<SqlContainerGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlContainerGetResultsInner&gt; object
     */
    public Observable<List<SqlContainerGetResultsInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName) {
        return listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map(new Func1<ServiceResponse<List<SqlContainerGetResultsInner>>, List<SqlContainerGetResultsInner>>() {
            @Override
            public List<SqlContainerGetResultsInner> call(ServiceResponse<List<SqlContainerGetResultsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlContainerGetResultsInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlContainerGetResultsInner>>> listSqlContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.listSqlContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlContainerGetResultsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlContainerGetResultsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlContainerGetResultsInner>> result = listSqlContainersDelegate(response);
                        List<SqlContainerGetResultsInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlContainerGetResultsInner>> clientResponse = new ServiceResponse<List<SqlContainerGetResultsInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlContainerGetResultsInner>> listSqlContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlContainerGetResultsInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlContainerGetResultsInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerGetResultsInner object if successful.
     */
    public SqlContainerGetResultsInner getSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerGetResultsInner object
     */
    public Observable<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>() {
            @Override
            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerGetResultsInner object
     */
    public Observable<ServiceResponse<SqlContainerGetResultsInner>> getSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlContainerGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlContainerGetResultsInner> clientResponse = getSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlContainerGetResultsInner> getSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlContainerGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlContainerGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerGetResultsInner object if successful.
     */
    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, final ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map(new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>() {
            @Override
            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlContainerGetResultsInner>> createUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlContainerParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlContainerGetResultsInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlContainerGetResultsInner object if successful.
     */
    public SqlContainerGetResultsInner beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, final ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerGetResultsInner object
     */
    public Observable<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map(new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>() {
            @Override
            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlContainerGetResultsInner object
     */
    public Observable<ServiceResponse<SqlContainerGetResultsInner>> beginCreateUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlContainerParameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlContainerGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlContainerGetResultsInner> clientResponse = beginCreateUpdateSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlContainerGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlContainerGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.deleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDeleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlContainerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner getSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputSettingsGetResultsInner> clientResponse = getSqlContainerThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputSettingsGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).toBlocking().last().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate(updateThroughputParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.updateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ThroughputSettingsGetResultsInner object if successful.
     */
    public ThroughputSettingsGetResultsInner beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).toBlocking().single().body();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, final ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters), serviceCallback);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).map(new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>() {
            @Override
            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ThroughputSettingsGetResultsInner object
     */
    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate(updateThroughputParameters);
        final String apiVersion = "2019-08-01";
        return service.beginUpdateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ThroughputSettingsGetResultsInner> clientResponse = beginUpdateSqlContainerThroughputDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ThroughputSettingsGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ThroughputSettingsGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlStoredProcedureGetResultsInner&gt; object if successful.
     */
    public List<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<List<SqlStoredProcedureGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlStoredProcedureGetResultsInner&gt; object
     */
    public Observable<List<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>, List<SqlStoredProcedureGetResultsInner>>() {
            @Override
            public List<SqlStoredProcedureGetResultsInner> call(ServiceResponse<List<SqlStoredProcedureGetResultsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlStoredProcedureGetResultsInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>> listSqlStoredProceduresWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.listSqlStoredProcedures(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlStoredProcedureGetResultsInner>> result = listSqlStoredProceduresDelegate(response);
                        List<SqlStoredProcedureGetResultsInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlStoredProcedureGetResultsInner>> clientResponse = new ServiceResponse<List<SqlStoredProcedureGetResultsInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlStoredProcedureGetResultsInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlStoredProcedureGetResultsInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlStoredProcedureGetResultsInner object if successful.
     */
    public SqlStoredProcedureGetResultsInner getSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().single().body();
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, final ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlStoredProcedureGetResultsInner object
     */
    public Observable<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map(new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>() {
            @Override
            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlStoredProcedureGetResultsInner object
     */
    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlStoredProcedureGetResultsInner> clientResponse = getSqlStoredProcedureDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlStoredProcedureGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlStoredProcedureGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlStoredProcedureGetResultsInner object if successful.
     */
    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, final ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).map(new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>() {
            @Override
            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> createUpdateSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlStoredProcedureParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, apiVersion, createUpdateSqlStoredProcedureParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlStoredProcedureGetResultsInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlStoredProcedureGetResultsInner object if successful.
     */
    public SqlStoredProcedureGetResultsInner beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, final ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlStoredProcedureGetResultsInner object
     */
    public Observable<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).map(new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>() {
            @Override
            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlStoredProcedureGetResultsInner object
     */
    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlStoredProcedureParameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateUpdateSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, apiVersion, createUpdateSqlStoredProcedureParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlStoredProcedureGetResultsInner> clientResponse = beginCreateUpdateSqlStoredProcedureDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlStoredProcedureGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlStoredProcedureGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.deleteSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDeleteSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlStoredProcedureDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlUserDefinedFunctionGetResultsInner&gt; object if successful.
     */
    public List<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<List<SqlUserDefinedFunctionGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlUserDefinedFunctionGetResultsInner&gt; object
     */
    public Observable<List<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>, List<SqlUserDefinedFunctionGetResultsInner>>() {
            @Override
            public List<SqlUserDefinedFunctionGetResultsInner> call(ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlUserDefinedFunctionGetResultsInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>> listSqlUserDefinedFunctionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.listSqlUserDefinedFunctions(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlUserDefinedFunctionGetResultsInner>> result = listSqlUserDefinedFunctionsDelegate(response);
                        List<SqlUserDefinedFunctionGetResultsInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>> clientResponse = new ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlUserDefinedFunctionGetResultsInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlUserDefinedFunctionGetResultsInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlUserDefinedFunctionGetResultsInner object if successful.
     */
    public SqlUserDefinedFunctionGetResultsInner getSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().single().body();
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, final ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlUserDefinedFunctionGetResultsInner object
     */
    public Observable<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map(new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>() {
            @Override
            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlUserDefinedFunctionGetResultsInner object
     */
    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlUserDefinedFunctionGetResultsInner> clientResponse = getSqlUserDefinedFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlUserDefinedFunctionGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlUserDefinedFunctionGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlUserDefinedFunctionGetResultsInner object if successful.
     */
    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, final ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).map(new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>() {
            @Override
            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlUserDefinedFunctionParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, apiVersion, createUpdateSqlUserDefinedFunctionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlUserDefinedFunctionGetResultsInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlUserDefinedFunctionGetResultsInner object if successful.
     */
    public SqlUserDefinedFunctionGetResultsInner beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, final ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlUserDefinedFunctionGetResultsInner object
     */
    public Observable<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).map(new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>() {
            @Override
            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlUserDefinedFunctionGetResultsInner object
     */
    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlUserDefinedFunctionParameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateUpdateSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, apiVersion, createUpdateSqlUserDefinedFunctionParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlUserDefinedFunctionGetResultsInner> clientResponse = beginCreateUpdateSqlUserDefinedFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlUserDefinedFunctionGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlUserDefinedFunctionGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.deleteSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDeleteSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlUserDefinedFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SqlTriggerGetResultsInner&gt; object if successful.
     */
    public List<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single().body();
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SqlTriggerGetResultsInner>> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName, final ServiceCallback<List<SqlTriggerGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlTriggerGetResultsInner&gt; object
     */
    public Observable<List<SqlTriggerGetResultsInner>> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map(new Func1<ServiceResponse<List<SqlTriggerGetResultsInner>>, List<SqlTriggerGetResultsInner>>() {
            @Override
            public List<SqlTriggerGetResultsInner> call(ServiceResponse<List<SqlTriggerGetResultsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SqlTriggerGetResultsInner&gt; object
     */
    public Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>> listSqlTriggersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.listSqlTriggers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SqlTriggerGetResultsInner>> result = listSqlTriggersDelegate(response);
                        List<SqlTriggerGetResultsInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SqlTriggerGetResultsInner>> clientResponse = new ServiceResponse<List<SqlTriggerGetResultsInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SqlTriggerGetResultsInner>> listSqlTriggersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SqlTriggerGetResultsInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SqlTriggerGetResultsInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlTriggerGetResultsInner object if successful.
     */
    public SqlTriggerGetResultsInner getSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().single().body();
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, final ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlTriggerGetResultsInner object
     */
    public Observable<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map(new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>() {
            @Override
            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlTriggerGetResultsInner object
     */
    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> getSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.getSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlTriggerGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlTriggerGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlTriggerGetResultsInner> clientResponse = getSqlTriggerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlTriggerGetResultsInner> getSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlTriggerGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlTriggerGetResultsInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlTriggerGetResultsInner object if successful.
     */
    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).toBlocking().last().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, final ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).map(new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>() {
            @Override
            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> createUpdateSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        if (createUpdateSqlTriggerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlTriggerParameters);
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.createUpdateSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, apiVersion, createUpdateSqlTriggerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlTriggerGetResultsInner>() { }.getType());
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SqlTriggerGetResultsInner object if successful.
     */
    public SqlTriggerGetResultsInner beginCreateUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).toBlocking().single().body();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, final ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters), serviceCallback);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlTriggerGetResultsInner object
     */
    public Observable<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).map(new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>() {
            @Override
            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SqlTriggerGetResultsInner object
     */
    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> beginCreateUpdateSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        if (createUpdateSqlTriggerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null.");
        }
        Validator.validate(createUpdateSqlTriggerParameters);
        final String apiVersion = "2019-08-01";
        return service.beginCreateUpdateSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, apiVersion, createUpdateSqlTriggerParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlTriggerGetResultsInner>>>() {
                @Override
                public Observable<ServiceResponse<SqlTriggerGetResultsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SqlTriggerGetResultsInner> clientResponse = beginCreateUpdateSqlTriggerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SqlTriggerGetResultsInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SqlTriggerGetResultsInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = service.deleteSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        final String apiVersion = "2019-08-01";
        return service.beginDeleteSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteSqlTriggerDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
