/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The conflict resolution policy for the container.
 */
public class ConflictResolutionPolicy {
    /**
     * Indicates the conflict resolution mode. Possible values include:
     * 'LastWriterWins', 'Custom'.
     */
    @JsonProperty(value = "mode")
    private ConflictResolutionMode mode;

    /**
     * The conflict resolution path in the case of LastWriterWins mode.
     */
    @JsonProperty(value = "conflictResolutionPath")
    private String conflictResolutionPath;

    /**
     * The procedure to resolve conflicts in the case of custom mode.
     */
    @JsonProperty(value = "conflictResolutionProcedure")
    private String conflictResolutionProcedure;

    /**
     * Get indicates the conflict resolution mode. Possible values include: 'LastWriterWins', 'Custom'.
     *
     * @return the mode value
     */
    public ConflictResolutionMode mode() {
        return this.mode;
    }

    /**
     * Set indicates the conflict resolution mode. Possible values include: 'LastWriterWins', 'Custom'.
     *
     * @param mode the mode value to set
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withMode(ConflictResolutionMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the conflict resolution path in the case of LastWriterWins mode.
     *
     * @return the conflictResolutionPath value
     */
    public String conflictResolutionPath() {
        return this.conflictResolutionPath;
    }

    /**
     * Set the conflict resolution path in the case of LastWriterWins mode.
     *
     * @param conflictResolutionPath the conflictResolutionPath value to set
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withConflictResolutionPath(String conflictResolutionPath) {
        this.conflictResolutionPath = conflictResolutionPath;
        return this;
    }

    /**
     * Get the procedure to resolve conflicts in the case of custom mode.
     *
     * @return the conflictResolutionProcedure value
     */
    public String conflictResolutionProcedure() {
        return this.conflictResolutionProcedure;
    }

    /**
     * Set the procedure to resolve conflicts in the case of custom mode.
     *
     * @param conflictResolutionProcedure the conflictResolutionProcedure value to set
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withConflictResolutionProcedure(String conflictResolutionProcedure) {
        this.conflictResolutionProcedure = conflictResolutionProcedure;
        return this;
    }

}
