/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cosmosdb.implementation;

import java.util.List;
import com.microsoft.azure.management.cosmosdb.MetricAvailability;
import com.microsoft.azure.management.cosmosdb.PrimaryAggregationType;
import com.microsoft.azure.management.cosmosdb.UnitType;
import com.microsoft.azure.management.cosmosdb.MetricName;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The definition of a metric.
 */
public class MetricDefinitionInner {
    /**
     * The list of metric availabilities for the account.
     */
    @JsonProperty(value = "metricAvailabilities", access = JsonProperty.Access.WRITE_ONLY)
    private List<MetricAvailability> metricAvailabilities;

    /**
     * The primary aggregation type of the metric. Possible values include:
     * 'None', 'Average', 'Total', 'Minimimum', 'Maximum', 'Last'.
     */
    @JsonProperty(value = "primaryAggregationType", access = JsonProperty.Access.WRITE_ONLY)
    private PrimaryAggregationType primaryAggregationType;

    /**
     * The unit of the metric. Possible values include: 'Count', 'Bytes',
     * 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     * 'Milliseconds'.
     */
    @JsonProperty(value = "unit")
    private UnitType unit;

    /**
     * The resource uri of the database.
     */
    @JsonProperty(value = "resourceUri", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceUri;

    /**
     * The name information for the metric.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private MetricName name;

    /**
     * Get the metricAvailabilities value.
     *
     * @return the metricAvailabilities value
     */
    public List<MetricAvailability> metricAvailabilities() {
        return this.metricAvailabilities;
    }

    /**
     * Get the primaryAggregationType value.
     *
     * @return the primaryAggregationType value
     */
    public PrimaryAggregationType primaryAggregationType() {
        return this.primaryAggregationType;
    }

    /**
     * Get the unit value.
     *
     * @return the unit value
     */
    public UnitType unit() {
        return this.unit;
    }

    /**
     * Set the unit value.
     *
     * @param unit the unit value to set
     * @return the MetricDefinitionInner object itself.
     */
    public MetricDefinitionInner withUnit(UnitType unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the resourceUri value.
     *
     * @return the resourceUri value
     */
    public String resourceUri() {
        return this.resourceUri;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public MetricName name() {
        return this.name;
    }

}
