/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cosmosdb.ConsistencyPolicy;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccount;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountKind;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListReadOnlyKeysResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountOfferType;
import com.microsoft.azure.management.cosmosdb.DefaultConsistencyLevel;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.Location;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBManager;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountCreateUpdateParametersInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.FailoverPolicyInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class CosmosDBAccountImpl
extends GroupableResourceImpl<CosmosDBAccount, DatabaseAccountInner, CosmosDBAccountImpl, CosmosDBManager>
implements CosmosDBAccount,
CosmosDBAccount.Definition,
CosmosDBAccount.Update {
    private List<FailoverPolicyInner> failoverPolicies = new ArrayList<FailoverPolicyInner>();
    private boolean hasFailoverPolicyChanges;
    private final int maxDelayDueToMissingFailovers = 600;

    CosmosDBAccountImpl(String name, DatabaseAccountInner innerObject, CosmosDBManager manager) {
        super(CosmosDBAccountImpl.fixDBName(name), (Resource)innerObject, (ManagerBase)manager);
    }

    @Override
    public DatabaseAccountKind kind() {
        return ((DatabaseAccountInner)((Object)this.inner())).kind();
    }

    @Override
    public String documentEndpoint() {
        return ((DatabaseAccountInner)((Object)this.inner())).documentEndpoint();
    }

    @Override
    public DatabaseAccountOfferType databaseAccountOfferType() {
        return ((DatabaseAccountInner)((Object)this.inner())).databaseAccountOfferType();
    }

    @Override
    public String ipRangeFilter() {
        return ((DatabaseAccountInner)((Object)this.inner())).ipRangeFilter();
    }

    @Override
    public ConsistencyPolicy consistencyPolicy() {
        return ((DatabaseAccountInner)((Object)this.inner())).consistencyPolicy();
    }

    @Override
    public DefaultConsistencyLevel defaultConsistencyLevel() {
        if (((DatabaseAccountInner)((Object)this.inner())).consistencyPolicy() == null) {
            throw new RuntimeException("Consistency policy is missing!");
        }
        return ((DatabaseAccountInner)((Object)this.inner())).consistencyPolicy().defaultConsistencyLevel();
    }

    @Override
    public List<Location> writableReplications() {
        return ((DatabaseAccountInner)((Object)this.inner())).writeLocations();
    }

    @Override
    public List<Location> readableReplications() {
        return ((DatabaseAccountInner)((Object)this.inner())).readLocations();
    }

    @Override
    public DatabaseAccountListKeysResult listKeys() {
        return (DatabaseAccountListKeysResult)this.listKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListKeysResult> listKeysAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListKeysResultInner, DatabaseAccountListKeysResult>(){

            public DatabaseAccountListKeysResult call(DatabaseAccountListKeysResultInner databaseAccountListKeysResultInner) {
                return new DatabaseAccountListKeysResultImpl(databaseAccountListKeysResultInner);
            }
        });
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys() {
        return (DatabaseAccountListReadOnlyKeysResult)this.listReadOnlyKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listReadOnlyKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListReadOnlyKeysResultInner, DatabaseAccountListReadOnlyKeysResult>(){

            public DatabaseAccountListReadOnlyKeysResult call(DatabaseAccountListReadOnlyKeysResultInner databaseAccountListReadOnlyKeysResultInner) {
                return new DatabaseAccountListReadOnlyKeysResultImpl(databaseAccountListReadOnlyKeysResultInner);
            }
        });
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings() {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listConnectionStringsAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListConnectionStringsResultInner, DatabaseAccountListConnectionStringsResult>(){

            public DatabaseAccountListConnectionStringsResult call(DatabaseAccountListConnectionStringsResultInner databaseAccountListConnectionStringsResultInner) {
                return new DatabaseAccountListConnectionStringsResultImpl(databaseAccountListConnectionStringsResultInner);
            }
        });
    }

    @Override
    public void regenerateKey(KeyKind keyKind) {
        this.regenerateKeyAsync(keyKind).toBlocking().last();
    }

    @Override
    public Observable<Void> regenerateKeyAsync(KeyKind keyKind) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), keyKind);
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind) {
        ((DatabaseAccountInner)((Object)this.inner())).withKind(kind);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withIpRangeFilter(String ipRangeFilter) {
        ((DatabaseAccountInner)((Object)this.inner())).withIpRangeFilter(ipRangeFilter);
        return this;
    }

    protected Observable<DatabaseAccountInner> getInnerAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CosmosDBAccountImpl withWriteReplication(Region region) {
        FailoverPolicyInner failoverPolicyInner = new FailoverPolicyInner();
        failoverPolicyInner.withLocationName(region.name());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        FailoverPolicyInner failoverPolicyInner = new FailoverPolicyInner();
        failoverPolicyInner.withLocationName(region.name());
        failoverPolicyInner.withFailoverPriority(this.failoverPolicies.size());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        for (int i = 1; i < this.failoverPolicies.size(); ++i) {
            String locName;
            if (this.failoverPolicies.get(i).locationName() == null || !(locName = this.failoverPolicies.get(i).locationName().replace(" ", "").toLowerCase()).equals(region.name())) continue;
            this.failoverPolicies.remove(i);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withEventualConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.EVENTUAL, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withSessionConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.SESSION, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withBoundedStalenessConsistency(int maxStalenessPrefix, int maxIntervalInSeconds) {
        this.setConsistencyPolicy(DefaultConsistencyLevel.BOUNDED_STALENESS, maxStalenessPrefix, maxIntervalInSeconds);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withStrongConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.STRONG, 0L, 0);
        return this;
    }

    public Observable<CosmosDBAccount> createResourceAsync() {
        return this.doDatabaseUpdateCreate();
    }

    private DatabaseAccountCreateUpdateParametersInner createUpdateParametersInner(DatabaseAccountInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountCreateUpdateParametersInner createUpdateParametersInner = new DatabaseAccountCreateUpdateParametersInner();
        createUpdateParametersInner.withLocation(this.regionName().toLowerCase());
        createUpdateParametersInner.withConsistencyPolicy(inner.consistencyPolicy());
        createUpdateParametersInner.withDatabaseAccountOfferType(DatabaseAccountOfferType.STANDARD.toString());
        createUpdateParametersInner.withIpRangeFilter(inner.ipRangeFilter());
        createUpdateParametersInner.withKind(inner.kind());
        createUpdateParametersInner.withTags(inner.getTags());
        this.addLocationsForCreateUpdateParameters(createUpdateParametersInner, this.failoverPolicies);
        return createUpdateParametersInner;
    }

    private static String fixDBName(String name) {
        return name.toLowerCase();
    }

    private void setConsistencyPolicy(DefaultConsistencyLevel level, long maxStalenessPrefix, int maxIntervalInSeconds) {
        ConsistencyPolicy policy = new ConsistencyPolicy();
        policy.withDefaultConsistencyLevel(level);
        if (level == DefaultConsistencyLevel.BOUNDED_STALENESS) {
            policy.withMaxStalenessPrefix(maxStalenessPrefix);
            policy.withMaxIntervalInSeconds(maxIntervalInSeconds);
        }
        ((DatabaseAccountInner)((Object)this.inner())).withConsistencyPolicy(policy);
    }

    private void addLocationsForCreateUpdateParameters(DatabaseAccountCreateUpdateParametersInner createUpdateParametersInner, List<FailoverPolicyInner> failoverPolicies) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < failoverPolicies.size(); ++i) {
            FailoverPolicyInner policyInner = failoverPolicies.get(i);
            Location location = new Location();
            location.withFailoverPriority(i);
            location.withLocationName(policyInner.locationName());
            locations.add(location);
        }
        if (locations.size() > 0) {
            createUpdateParametersInner.withLocations(locations);
        }
    }

    private Observable<CosmosDBAccount> updateFailoverPriorityAsync() {
        final CosmosDBAccountImpl self = this;
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().failoverPriorityChangeAsync(this.resourceGroupName(), this.name(), this.failoverPolicies).map((Func1)new Func1<Void, CosmosDBAccount>(){

            public CosmosDBAccount call(Void voidInner) {
                if (((DatabaseAccountInner)((Object)self.inner())).failoverPolicies() != null) {
                    ((DatabaseAccountInner)((Object)self.inner())).failoverPolicies().clear();
                    ((DatabaseAccountInner)((Object)self.inner())).failoverPolicies().addAll(self.failoverPolicies);
                }
                self.failoverPolicies.clear();
                return self;
            }
        });
    }

    private Observable<CosmosDBAccount> doDatabaseUpdateCreate() {
        final CosmosDBAccountImpl self = this;
        final ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(0);
        final DatabaseAccountCreateUpdateParametersInner createUpdateParametersInner = this.createUpdateParametersInner((DatabaseAccountInner)((Object)this.inner()));
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().createOrUpdateAsync(this.resourceGroupName(), this.name(), createUpdateParametersInner).flatMap((Func1)new Func1<DatabaseAccountInner, Observable<? extends CosmosDBAccount>>(){

            public Observable<? extends CosmosDBAccount> call(DatabaseAccountInner databaseAccountInner) {
                self.failoverPolicies.clear();
                self.hasFailoverPolicyChanges = false;
                return ((CosmosDBManager)CosmosDBAccountImpl.this.manager()).databaseAccounts().getByResourceGroupAsync(CosmosDBAccountImpl.this.resourceGroupName(), CosmosDBAccountImpl.this.name()).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                    public Observable<?> call(Observable<? extends Void> observable) {
                        data.set(0, (Integer)data.get(0) + 5);
                        return observable.delay(5L, TimeUnit.SECONDS);
                    }
                }).filter((Func1)new Func1<CosmosDBAccount, Boolean>(){

                    public Boolean call(CosmosDBAccount databaseAccount) {
                        if (600 > (Integer)data.get(0) && (databaseAccount.id() == null || databaseAccount.id().length() == 0 || createUpdateParametersInner.locations().size() > ((DatabaseAccountInner)((Object)databaseAccount.inner())).failoverPolicies().size())) {
                            data.set(0, (Integer)data.get(0) + 5);
                            return false;
                        }
                        if (CosmosDBAccountImpl.this.isAFinalProvisioningState(((DatabaseAccountInner)((Object)databaseAccount.inner())).provisioningState())) {
                            for (Location location : databaseAccount.readableReplications()) {
                                if (CosmosDBAccountImpl.this.isAFinalProvisioningState(location.provisioningState())) continue;
                                return false;
                            }
                        } else {
                            return false;
                        }
                        self.setInner(databaseAccount.inner());
                        return true;
                    }
                }).first();
            }
        });
    }

    private void ensureFailoverIsInitialized() {
        if (this.isInCreateMode()) {
            return;
        }
        if (!this.hasFailoverPolicyChanges) {
            this.failoverPolicies.clear();
            FailoverPolicyInner[] policyInners = new FailoverPolicyInner[((DatabaseAccountInner)((Object)this.inner())).failoverPolicies().size()];
            ((DatabaseAccountInner)((Object)this.inner())).failoverPolicies().toArray(policyInners);
            Arrays.sort(policyInners, new Comparator<FailoverPolicyInner>(){

                @Override
                public int compare(FailoverPolicyInner o1, FailoverPolicyInner o2) {
                    return o1.failoverPriority().compareTo(o2.failoverPriority());
                }
            });
            for (int i = 0; i < policyInners.length; ++i) {
                this.failoverPolicies.add(policyInners[i]);
            }
            this.hasFailoverPolicyChanges = true;
        }
    }

    private boolean isAFinalProvisioningState(String state) {
        switch (state.toLowerCase()) {
            case "succeeded": 
            case "canceled": 
            case "failed": {
                return true;
            }
        }
        return false;
    }
}

