/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.datalake.analytics.models.Acl;
import com.microsoft.azure.management.datalake.analytics.models.AclCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.AclDeleteParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialCreateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogCredentialUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssembly;
import com.microsoft.azure.management.datalake.analytics.models.USqlAssemblyClr;
import com.microsoft.azure.management.datalake.analytics.models.USqlCredential;
import com.microsoft.azure.management.datalake.analytics.models.USqlDatabase;
import com.microsoft.azure.management.datalake.analytics.models.USqlExternalDataSource;
import com.microsoft.azure.management.datalake.analytics.models.USqlPackage;
import com.microsoft.azure.management.datalake.analytics.models.USqlProcedure;
import com.microsoft.azure.management.datalake.analytics.models.USqlSchema;
import com.microsoft.azure.management.datalake.analytics.models.USqlSecret;
import com.microsoft.azure.management.datalake.analytics.models.USqlTable;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableFragment;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePartition;
import com.microsoft.azure.management.datalake.analytics.models.USqlTablePreview;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableStatistics;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableType;
import com.microsoft.azure.management.datalake.analytics.models.USqlTableValuedFunction;
import com.microsoft.azure.management.datalake.analytics.models.USqlType;
import com.microsoft.azure.management.datalake.analytics.models.USqlView;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.util.List;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Catalogs.
 */
public interface Catalogs {
    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void createSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> createSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Creates the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use CreateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to create the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> createSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlSecret object if successful.
     */
    USqlSecret getSecret(String accountName, String databaseName, String secretName);

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName, final ServiceCallback<USqlSecret> serviceCallback);

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSecret object
     */
    Observable<USqlSecret> getSecretAsync(String accountName, String databaseName, String secretName);

    /**
     * Gets the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use GetCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to get
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSecret object
     */
    Observable<ServiceResponse<USqlSecret>> getSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName);

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void updateSecret(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> updateSecretAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Modifies the specified secret for use with external data sources in the specified database. This is deprecated and will be removed in the next release. Please use UpdateCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret.
     * @param parameters The parameters required to modify the secret (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> updateSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName, DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters parameters);

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void deleteSecret(String accountName, String databaseName, String secretName);

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> deleteSecretAsync(String accountName, String databaseName, String secretName, final ServiceCallback<Void> serviceCallback);

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> deleteSecretAsync(String accountName, String databaseName, String secretName);

    /**
     * Deletes the specified secret in the specified database. This is deprecated and will be removed in the next release. Please use DeleteCredential instead.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param secretName The name of the secret to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> deleteSecretWithServiceResponseAsync(String accountName, String databaseName, String secretName);

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void deleteAllSecrets(String accountName, String databaseName);

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> deleteAllSecretsAsync(String accountName, String databaseName, final ServiceCallback<Void> serviceCallback);

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> deleteAllSecretsAsync(String accountName, String databaseName);

    /**
     * Deletes all secrets in the specified database. This is deprecated and will be removed in the next release. In the future, please only drop individual credentials using DeleteCredential.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> deleteAllSecretsWithServiceResponseAsync(String accountName, String databaseName);

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void createCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters);

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> createCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters);

    /**
     * Creates the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database in which to create the credential. Note: This is NOT an external database name, but the name of an existing U-SQL database that should contain the new credential object.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to create the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> createCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialCreateParameters parameters);

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlCredential object if successful.
     */
    USqlCredential getCredential(String accountName, String databaseName, String credentialName);

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName, final ServiceCallback<USqlCredential> serviceCallback);

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlCredential object
     */
    Observable<USqlCredential> getCredentialAsync(String accountName, String databaseName, String credentialName);

    /**
     * Retrieves the specified credential from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlCredential object
     */
    Observable<ServiceResponse<USqlCredential>> getCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName);

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void updateCredential(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters);

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> updateCredentialAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters);

    /**
     * Modifies the specified credential for use with external data sources in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential.
     * @param parameters The parameters required to modify the credential (name and password)
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> updateCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, DataLakeAnalyticsCatalogCredentialUpdateParameters parameters);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void deleteCredential(String accountName, String databaseName, String credentialName);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, final ServiceCallback<Void> serviceCallback);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName);
    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void deleteCredential(String accountName, String databaseName, String credentialName, Boolean cascade, String password);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password, final ServiceCallback<Void> serviceCallback);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> deleteCredentialAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password);

    /**
     * Deletes the specified credential in the specified database.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the credential.
     * @param credentialName The name of the credential to delete
     * @param cascade Indicates if the delete should be a cascading delete (which deletes all resources dependent on the credential as well as the credential) or not. If false will fail if there are any resources relying on the credential.
     * @param password the current password for the credential and user with access to the data source. This is required if the requester is not the account owner.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> deleteCredentialWithServiceResponseAsync(String accountName, String databaseName, String credentialName, Boolean cascade, String password);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    PagedList<USqlCredential> listCredentials(final String accountName, final String databaseName);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlCredential> serviceCallback);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<Page<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    PagedList<USqlCredential> listCredentials(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlCredential> serviceCallback);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<Page<USqlCredential>> listCredentialsAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlExternalDataSource object if successful.
     */
    USqlExternalDataSource getExternalDataSource(String accountName, String databaseName, String externalDataSourceName);

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName, final ServiceCallback<USqlExternalDataSource> serviceCallback);

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlExternalDataSource object
     */
    Observable<USqlExternalDataSource> getExternalDataSourceAsync(String accountName, String databaseName, String externalDataSourceName);

    /**
     * Retrieves the specified external data source from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data source.
     * @param externalDataSourceName The name of the external data source.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlExternalDataSource object
     */
    Observable<ServiceResponse<USqlExternalDataSource>> getExternalDataSourceWithServiceResponseAsync(String accountName, String databaseName, String externalDataSourceName);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    PagedList<USqlExternalDataSource> listExternalDataSources(final String accountName, final String databaseName);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlExternalDataSource> serviceCallback);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    PagedList<USqlExternalDataSource> listExternalDataSources(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlExternalDataSource> serviceCallback);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<Page<USqlExternalDataSource>> listExternalDataSourcesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the external data sources.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlProcedure object if successful.
     */
    USqlProcedure getProcedure(String accountName, String databaseName, String schemaName, String procedureName);

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName, final ServiceCallback<USqlProcedure> serviceCallback);

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlProcedure object
     */
    Observable<USqlProcedure> getProcedureAsync(String accountName, String databaseName, String schemaName, String procedureName);

    /**
     * Retrieves the specified procedure from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedure.
     * @param schemaName The name of the schema containing the procedure.
     * @param procedureName The name of the procedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlProcedure object
     */
    Observable<ServiceResponse<USqlProcedure>> getProcedureWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String procedureName);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    PagedList<USqlProcedure> listProcedures(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlProcedure> serviceCallback);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<Page<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    PagedList<USqlProcedure> listProcedures(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlProcedure> serviceCallback);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<Page<USqlProcedure>> listProceduresAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the procedures.
     * @param schemaName The name of the schema containing the procedures.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTable object if successful.
     */
    USqlTable getTable(String accountName, String databaseName, String schemaName, String tableName);

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName, final ServiceCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTable object
     */
    Observable<USqlTable> getTableAsync(String accountName, String databaseName, String schemaName, String tableName);

    /**
     * Retrieves the specified table from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTable object
     */
    Observable<ServiceResponse<USqlTable>> getTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    PagedList<USqlTableFragment> listTableFragments(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTableFragment> serviceCallback);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<Page<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);
    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    PagedList<USqlTableFragment> listTableFragments(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableFragment> serviceCallback);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<Page<USqlTableFragment>> listTableFragmentsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table fragments.
     * @param schemaName The name of the schema containing the table fragments.
     * @param tableName The name of the table containing the table fragments.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTables(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTables(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param schemaName The name of the schema containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchema(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableType object if successful.
     */
    USqlTableType getTableType(String accountName, String databaseName, String schemaName, String tableTypeName);

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName, final ServiceCallback<USqlTableType> serviceCallback);

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableType object
     */
    Observable<USqlTableType> getTableTypeAsync(String accountName, String databaseName, String schemaName, String tableTypeName);

    /**
     * Retrieves the specified table type from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table type.
     * @param schemaName The name of the schema containing the table type.
     * @param tableTypeName The name of the table type to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableType object
     */
    Observable<ServiceResponse<USqlTableType>> getTableTypeWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableTypeName);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    PagedList<USqlTableType> listTableTypes(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableType> serviceCallback);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<Page<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    PagedList<USqlTableType> listTableTypes(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableType> serviceCallback);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<Page<USqlTableType>> listTableTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table types.
     * @param schemaName The name of the schema containing the table types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlPackage object if successful.
     */
    USqlPackage getPackage(String accountName, String databaseName, String schemaName, String packageName);

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName, final ServiceCallback<USqlPackage> serviceCallback);

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlPackage object
     */
    Observable<USqlPackage> getPackageAsync(String accountName, String databaseName, String schemaName, String packageName);

    /**
     * Retrieves the specified package from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the package.
     * @param schemaName The name of the schema containing the package.
     * @param packageName The name of the package.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlPackage object
     */
    Observable<ServiceResponse<USqlPackage>> getPackageWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String packageName);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    PagedList<USqlPackage> listPackages(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlPackage> serviceCallback);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<Page<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    PagedList<USqlPackage> listPackages(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlPackage> serviceCallback);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<Page<USqlPackage>> listPackagesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the packages.
     * @param schemaName The name of the schema containing the packages.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<ServiceResponse<Page<USqlPackage>>> listPackagesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlView object if successful.
     */
    USqlView getView(String accountName, String databaseName, String schemaName, String viewName);

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName, final ServiceCallback<USqlView> serviceCallback);

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlView object
     */
    Observable<USqlView> getViewAsync(String accountName, String databaseName, String schemaName, String viewName);

    /**
     * Retrieves the specified view from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the view.
     * @param schemaName The name of the schema containing the view.
     * @param viewName The name of the view.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlView object
     */
    Observable<ServiceResponse<USqlView>> getViewWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String viewName);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViews(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViews(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param schemaName The name of the schema containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableStatistics object if successful.
     */
    USqlTableStatistics getTableStatistic(String accountName, String databaseName, String schemaName, String tableName, String statisticsName);

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName, final ServiceCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableStatistics object
     */
    Observable<USqlTableStatistics> getTableStatisticAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName);

    /**
     * Retrieves the specified table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param statisticsName The name of the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableStatistics object
     */
    Observable<ServiceResponse<USqlTableStatistics>> getTableStatisticWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String statisticsName);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatistics(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);
    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatistics(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the statistics.
     * @param schemaName The name of the schema containing the statistics.
     * @param tableName The name of the table containing the statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, final ServiceCallback<USqlTablePreview> serviceCallback);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName);
    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    USqlTablePreview previewTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns, final ServiceCallback<USqlTablePreview> serviceCallback);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<USqlTablePreview> previewTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns);

    /**
     * Retrieves a preview set of rows in given partition.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param maxRows The maximum number of preview rows to be retrieved.Rows returned may be less than or equal to this number depending on row sizes and number of rows in the partition.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<ServiceResponse<USqlTablePreview>> previewTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, Long maxRows, Long maxColumns);

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePartition object if successful.
     */
    USqlTablePartition getTablePartition(String accountName, String databaseName, String schemaName, String tableName, String partitionName);

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName, final ServiceCallback<USqlTablePartition> serviceCallback);

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePartition object
     */
    Observable<USqlTablePartition> getTablePartitionAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName);

    /**
     * Retrieves the specified table partition from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partition.
     * @param schemaName The name of the schema containing the partition.
     * @param tableName The name of the table containing the partition.
     * @param partitionName The name of the table partition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePartition object
     */
    Observable<ServiceResponse<USqlTablePartition>> getTablePartitionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, String partitionName);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, final ServiceCallback<USqlTablePreview> serviceCallback);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName);
    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTablePreview object if successful.
     */
    USqlTablePreview previewTable(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns, final ServiceCallback<USqlTablePreview> serviceCallback);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<USqlTablePreview> previewTableAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns);

    /**
     * Retrieves a preview set of rows in given table.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table.
     * @param schemaName The name of the schema containing the table.
     * @param tableName The name of the table.
     * @param maxRows The maximum number of preview rows to be retrieved. Rows returned may be less than or equal to this number depending on row sizes and number of rows in the table.
     * @param maxColumns The maximum number of columns to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTablePreview object
     */
    Observable<ServiceResponse<USqlTablePreview>> previewTableWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableName, Long maxRows, Long maxColumns);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    PagedList<USqlTablePartition> listTablePartitions(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final ListOperationCallback<USqlTablePartition> serviceCallback);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<Page<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName);
    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    PagedList<USqlTablePartition> listTablePartitions(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTablePartition> serviceCallback);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<Page<USqlTablePartition>> listTablePartitionsAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the partitions.
     * @param schemaName The name of the schema containing the partitions.
     * @param tableName The name of the table containing the partitions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String tableName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    PagedList<USqlType> listTypes(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlType> serviceCallback);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<Page<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    PagedList<USqlType> listTypes(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlType> serviceCallback);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<Page<USqlType>> listTypesAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the types.
     * @param schemaName The name of the schema containing the types.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<ServiceResponse<Page<USqlType>>> listTypesWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlTableValuedFunction object if successful.
     */
    USqlTableValuedFunction getTableValuedFunction(String accountName, String databaseName, String schemaName, String tableValuedFunctionName);

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName, final ServiceCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableValuedFunction object
     */
    Observable<USqlTableValuedFunction> getTableValuedFunctionAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName);

    /**
     * Retrieves the specified table valued function from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued function.
     * @param schemaName The name of the schema containing the table valued function.
     * @param tableValuedFunctionName The name of the tableValuedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlTableValuedFunction object
     */
    Observable<ServiceResponse<USqlTableValuedFunction>> getTableValuedFunctionWithServiceResponseAsync(String accountName, String databaseName, String schemaName, String tableValuedFunctionName);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctions(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName);
    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctions(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param schemaName The name of the schema containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsWithServiceResponseAsync(final String accountName, final String databaseName, final String schemaName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlAssembly object if successful.
     */
    USqlAssembly getAssembly(String accountName, String databaseName, String assemblyName);

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName, final ServiceCallback<USqlAssembly> serviceCallback);

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlAssembly object
     */
    Observable<USqlAssembly> getAssemblyAsync(String accountName, String databaseName, String assemblyName);

    /**
     * Retrieves the specified assembly from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param assemblyName The name of the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlAssembly object
     */
    Observable<ServiceResponse<USqlAssembly>> getAssemblyWithServiceResponseAsync(String accountName, String databaseName, String assemblyName);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    PagedList<USqlAssemblyClr> listAssemblies(final String accountName, final String databaseName);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlAssemblyClr> serviceCallback);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<Page<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    PagedList<USqlAssemblyClr> listAssemblies(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlAssemblyClr> serviceCallback);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<Page<USqlAssemblyClr>> listAssembliesAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the assembly.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlSchema object if successful.
     */
    USqlSchema getSchema(String accountName, String databaseName, String schemaName);

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName, final ServiceCallback<USqlSchema> serviceCallback);

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSchema object
     */
    Observable<USqlSchema> getSchemaAsync(String accountName, String databaseName, String schemaName);

    /**
     * Retrieves the specified schema from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param schemaName The name of the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlSchema object
     */
    Observable<ServiceResponse<USqlSchema>> getSchemaWithServiceResponseAsync(String accountName, String databaseName, String schemaName);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    PagedList<USqlSchema> listSchemas(final String accountName, final String databaseName);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlSchema> serviceCallback);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<Page<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    PagedList<USqlSchema> listSchemas(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlSchema> serviceCallback);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<Page<USqlSchema>> listSchemasAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the schema.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<ServiceResponse<Page<USqlSchema>>> listSchemasWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabase(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table statistics.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTablesByDatabase(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTablesByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the tables.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param basic The basic switch indicates what level of information to return when listing tables. When basic is true, only database_name, schema_name, table_name and version are returned for each table, otherwise all table metadata is returned. By default, it is false
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final Boolean basic);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the table valued functions.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViewsByDatabase(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViewsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database containing the views.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAclsByDatabase(final String accountName, final String databaseName);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName);
    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAclsByDatabase(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsByDatabaseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseWithServiceResponseAsync(final String accountName, final String databaseName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAcls(final String accountName);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsAsync(final String accountName, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsAsync(final String accountName);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(final String accountName);
    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAcls(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsWithServiceResponseAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the USqlDatabase object if successful.
     */
    USqlDatabase getDatabase(String accountName, String databaseName);

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<USqlDatabase> getDatabaseAsync(String accountName, String databaseName, final ServiceCallback<USqlDatabase> serviceCallback);

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlDatabase object
     */
    Observable<USqlDatabase> getDatabaseAsync(String accountName, String databaseName);

    /**
     * Retrieves the specified database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the USqlDatabase object
     */
    Observable<ServiceResponse<USqlDatabase>> getDatabaseWithServiceResponseAsync(String accountName, String databaseName);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    PagedList<USqlDatabase> listDatabases(final String accountName);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlDatabase>> listDatabasesAsync(final String accountName, final ListOperationCallback<USqlDatabase> serviceCallback);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<Page<USqlDatabase>> listDatabasesAsync(final String accountName);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(final String accountName);
    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    PagedList<USqlDatabase> listDatabases(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlDatabase>> listDatabasesAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<USqlDatabase> serviceCallback);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<Page<USqlDatabase>> listDatabasesAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesWithServiceResponseAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count);

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void grantAcl(String accountName, AclCreateOrUpdateParameters parameters);

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> grantAclAsync(String accountName, AclCreateOrUpdateParameters parameters);

    /**
     * Grants an access control list (ACL) entry to the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> grantAclWithServiceResponseAsync(String accountName, AclCreateOrUpdateParameters parameters);

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void grantAclToDatabase(String accountName, String databaseName, AclCreateOrUpdateParameters parameters);

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> grantAclToDatabaseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters);

    /**
     * Grants an access control list (ACL) entry to the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to create or update an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> grantAclToDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclCreateOrUpdateParameters parameters);

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void revokeAcl(String accountName, AclDeleteParameters parameters);

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> revokeAclAsync(String accountName, AclDeleteParameters parameters);

    /**
     * Revokes an access control list (ACL) entry from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry from a Data Lake Analytics catalog.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> revokeAclWithServiceResponseAsync(String accountName, AclDeleteParameters parameters);

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void revokeAclFromDatabase(String accountName, String databaseName, AclDeleteParameters parameters);

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters, final ServiceCallback<Void> serviceCallback);

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> revokeAclFromDatabaseAsync(String accountName, String databaseName, AclDeleteParameters parameters);

    /**
     * Revokes an access control list (ACL) entry for the database from the Data Lake Analytics catalog.
     *
     * @param accountName The Azure Data Lake Analytics account upon which to execute catalog operations.
     * @param databaseName The name of the database.
     * @param parameters Parameters supplied to delete an access control list (ACL) entry for a database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> revokeAclFromDatabaseWithServiceResponseAsync(String accountName, String databaseName, AclDeleteParameters parameters);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlCredential&gt; object if successful.
     */
    PagedList<USqlCredential> listCredentialsNext(final String nextPageLink);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlCredential>> listCredentialsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlCredential>> serviceFuture, final ListOperationCallback<USqlCredential> serviceCallback);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<Page<USqlCredential>> listCredentialsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of credentials from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlCredential&gt; object
     */
    Observable<ServiceResponse<Page<USqlCredential>>> listCredentialsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlExternalDataSource&gt; object if successful.
     */
    PagedList<USqlExternalDataSource> listExternalDataSourcesNext(final String nextPageLink);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlExternalDataSource>> listExternalDataSourcesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlExternalDataSource>> serviceFuture, final ListOperationCallback<USqlExternalDataSource> serviceCallback);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<Page<USqlExternalDataSource>> listExternalDataSourcesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of external data sources from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlExternalDataSource&gt; object
     */
    Observable<ServiceResponse<Page<USqlExternalDataSource>>> listExternalDataSourcesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlProcedure&gt; object if successful.
     */
    PagedList<USqlProcedure> listProceduresNext(final String nextPageLink);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlProcedure>> listProceduresNextAsync(final String nextPageLink, final ServiceFuture<List<USqlProcedure>> serviceFuture, final ListOperationCallback<USqlProcedure> serviceCallback);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<Page<USqlProcedure>> listProceduresNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of procedures from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlProcedure&gt; object
     */
    Observable<ServiceResponse<Page<USqlProcedure>>> listProceduresNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableFragment&gt; object if successful.
     */
    PagedList<USqlTableFragment> listTableFragmentsNext(final String nextPageLink);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableFragment>> listTableFragmentsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableFragment>> serviceFuture, final ListOperationCallback<USqlTableFragment> serviceCallback);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<Page<USqlTableFragment>> listTableFragmentsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of table fragments from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableFragment&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableFragment>>> listTableFragmentsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTablesNext(final String nextPageLink);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTable>> serviceFuture, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of tables from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabaseAndSchemaNext(final String nextPageLink);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseAndSchemaNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of all table statistics within the specified schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseAndSchemaNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableType&gt; object if successful.
     */
    PagedList<USqlTableType> listTableTypesNext(final String nextPageLink);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableType>> listTableTypesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableType>> serviceFuture, final ListOperationCallback<USqlTableType> serviceCallback);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<Page<USqlTableType>> listTableTypesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of table types from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableType&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableType>>> listTableTypesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlPackage&gt; object if successful.
     */
    PagedList<USqlPackage> listPackagesNext(final String nextPageLink);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlPackage>> listPackagesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlPackage>> serviceFuture, final ListOperationCallback<USqlPackage> serviceCallback);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<Page<USqlPackage>> listPackagesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of packages from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlPackage&gt; object
     */
    Observable<ServiceResponse<Page<USqlPackage>>> listPackagesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViewsNext(final String nextPageLink);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlView>> serviceFuture, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of views from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsNext(final String nextPageLink);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of table statistics from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTablePartition&gt; object if successful.
     */
    PagedList<USqlTablePartition> listTablePartitionsNext(final String nextPageLink);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTablePartition>> listTablePartitionsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTablePartition>> serviceFuture, final ListOperationCallback<USqlTablePartition> serviceCallback);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<Page<USqlTablePartition>> listTablePartitionsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of table partitions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTablePartition&gt; object
     */
    Observable<ServiceResponse<Page<USqlTablePartition>>> listTablePartitionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlType&gt; object if successful.
     */
    PagedList<USqlType> listTypesNext(final String nextPageLink);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlType>> listTypesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlType>> serviceFuture, final ListOperationCallback<USqlType> serviceCallback);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<Page<USqlType>> listTypesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of types within the specified database and schema from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlType&gt; object
     */
    Observable<ServiceResponse<Page<USqlType>>> listTypesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctionsNext(final String nextPageLink);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of table valued functions from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlAssemblyClr&gt; object if successful.
     */
    PagedList<USqlAssemblyClr> listAssembliesNext(final String nextPageLink);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlAssemblyClr>> listAssembliesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlAssemblyClr>> serviceFuture, final ListOperationCallback<USqlAssemblyClr> serviceCallback);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<Page<USqlAssemblyClr>> listAssembliesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of assemblies from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlAssemblyClr&gt; object
     */
    Observable<ServiceResponse<Page<USqlAssemblyClr>>> listAssembliesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlSchema&gt; object if successful.
     */
    PagedList<USqlSchema> listSchemasNext(final String nextPageLink);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlSchema>> listSchemasNextAsync(final String nextPageLink, final ServiceFuture<List<USqlSchema>> serviceFuture, final ListOperationCallback<USqlSchema> serviceCallback);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<Page<USqlSchema>> listSchemasNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of schemas from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlSchema&gt; object
     */
    Observable<ServiceResponse<Page<USqlSchema>>> listSchemasNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableStatistics&gt; object if successful.
     */
    PagedList<USqlTableStatistics> listTableStatisticsByDatabaseNext(final String nextPageLink);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableStatistics>> serviceFuture, final ListOperationCallback<USqlTableStatistics> serviceCallback);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<Page<USqlTableStatistics>> listTableStatisticsByDatabaseNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of all statistics in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableStatistics&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableStatistics>>> listTableStatisticsByDatabaseNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTable&gt; object if successful.
     */
    PagedList<USqlTable> listTablesByDatabaseNext(final String nextPageLink);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTable>> listTablesByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTable>> serviceFuture, final ListOperationCallback<USqlTable> serviceCallback);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<Page<USqlTable>> listTablesByDatabaseNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of all tables in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTable&gt; object
     */
    Observable<ServiceResponse<Page<USqlTable>>> listTablesByDatabaseNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlTableValuedFunction&gt; object if successful.
     */
    PagedList<USqlTableValuedFunction> listTableValuedFunctionsByDatabaseNext(final String nextPageLink);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlTableValuedFunction>> serviceFuture, final ListOperationCallback<USqlTableValuedFunction> serviceCallback);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<Page<USqlTableValuedFunction>> listTableValuedFunctionsByDatabaseNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of all table valued functions in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlTableValuedFunction&gt; object
     */
    Observable<ServiceResponse<Page<USqlTableValuedFunction>>> listTableValuedFunctionsByDatabaseNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlView&gt; object if successful.
     */
    PagedList<USqlView> listViewsByDatabaseNext(final String nextPageLink);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlView>> listViewsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<USqlView>> serviceFuture, final ListOperationCallback<USqlView> serviceCallback);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<Page<USqlView>> listViewsByDatabaseNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of all views in a database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlView&gt; object
     */
    Observable<ServiceResponse<Page<USqlView>>> listViewsByDatabaseNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAclsByDatabaseNext(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<Acl>> serviceFuture, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsByDatabaseNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the database from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsByDatabaseNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Acl&gt; object if successful.
     */
    PagedList<Acl> listAclsNext(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<Acl>> listAclsNextAsync(final String nextPageLink, final ServiceFuture<List<Acl>> serviceFuture, final ListOperationCallback<Acl> serviceCallback);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<Page<Acl>> listAclsNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of access control list (ACL) entries for the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Acl&gt; object
     */
    Observable<ServiceResponse<Page<Acl>>> listAclsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;USqlDatabase&gt; object if successful.
     */
    PagedList<USqlDatabase> listDatabasesNext(final String nextPageLink);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<USqlDatabase>> listDatabasesNextAsync(final String nextPageLink, final ServiceFuture<List<USqlDatabase>> serviceFuture, final ListOperationCallback<USqlDatabase> serviceCallback);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<Page<USqlDatabase>> listDatabasesNextAsync(final String nextPageLink);

    /**
     * Retrieves the list of databases from the Data Lake Analytics catalog.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;USqlDatabase&gt; object
     */
    Observable<ServiceResponse<Page<USqlDatabase>>> listDatabasesNextWithServiceResponseAsync(final String nextPageLink);

}
