/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.datalake.analytics.DataLakeAnalyticsJobManagementClient;
import com.microsoft.azure.management.datalake.analytics.Jobs;
import com.microsoft.azure.management.datalake.analytics.Pipelines;
import com.microsoft.azure.management.datalake.analytics.Recurrences;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;

/**
 * Initializes a new instance of the DataLakeAnalyticsJobManagementClientImpl class.
 */
public class DataLakeAnalyticsJobManagementClientImpl extends AzureServiceClient implements DataLakeAnalyticsJobManagementClient {
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The DNS suffix used as the base for all Azure Data Lake Analytics Job service requests. */
    private String adlaJobDnsSuffix;

    /**
     * Gets The DNS suffix used as the base for all Azure Data Lake Analytics Job service requests.
     *
     * @return the adlaJobDnsSuffix value.
     */
    public String adlaJobDnsSuffix() {
        return this.adlaJobDnsSuffix;
    }

    /**
     * Sets The DNS suffix used as the base for all Azure Data Lake Analytics Job service requests.
     *
     * @param adlaJobDnsSuffix the adlaJobDnsSuffix value.
     * @return the service client itself
     */
    public DataLakeAnalyticsJobManagementClientImpl withAdlaJobDnsSuffix(String adlaJobDnsSuffix) {
        this.adlaJobDnsSuffix = adlaJobDnsSuffix;
        return this;
    }

    /** Client Api Version. */
    private String apiVersion;

    /**
     * Gets Client Api Version.
     *
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /** The preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets The preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets The preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public DataLakeAnalyticsJobManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** The retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public DataLakeAnalyticsJobManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public DataLakeAnalyticsJobManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The Jobs object to access its operations.
     */
    private Jobs jobs;

    /**
     * Gets the Jobs object to access its operations.
     * @return the Jobs object.
     */
    public Jobs jobs() {
        return this.jobs;
    }

    /**
     * The Pipelines object to access its operations.
     */
    private Pipelines pipelines;

    /**
     * Gets the Pipelines object to access its operations.
     * @return the Pipelines object.
     */
    public Pipelines pipelines() {
        return this.pipelines;
    }

    /**
     * The Recurrences object to access its operations.
     */
    private Recurrences recurrences;

    /**
     * Gets the Recurrences object to access its operations.
     * @return the Recurrences object.
     */
    public Recurrences recurrences() {
        return this.recurrences;
    }

    /**
     * Initializes an instance of DataLakeAnalyticsJobManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public DataLakeAnalyticsJobManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://{accountName}.{adlaJobDnsSuffix}", credentials);
    }

    /**
     * Initializes an instance of DataLakeAnalyticsJobManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    private DataLakeAnalyticsJobManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of DataLakeAnalyticsJobManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public DataLakeAnalyticsJobManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.adlaJobDnsSuffix = "azuredatalakeanalytics.net";
        this.apiVersion = "2017-09-01-preview";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.jobs = new JobsImpl(restClient().retrofit(), this);
        this.pipelines = new PipelinesImpl(restClient().retrofit(), this);
        this.recurrences = new RecurrencesImpl(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "DataLakeAnalyticsJobManagementClient", "2017-09-01-preview");
    }
}
