/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.implementation;

import retrofit2.Retrofit;
import com.microsoft.azure.management.datalake.analytics.Jobs;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.datalake.analytics.models.BuildJobParameters;
import com.microsoft.azure.management.datalake.analytics.models.CreateJobParameters;
import com.microsoft.azure.management.datalake.analytics.models.JobDataPath;
import com.microsoft.azure.management.datalake.analytics.models.JobInformation;
import com.microsoft.azure.management.datalake.analytics.models.JobInformationBasic;
import com.microsoft.azure.management.datalake.analytics.models.JobStatistics;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.UpdateJobParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Jobs.
 */
public class JobsImpl implements Jobs {
    /** The Retrofit service to perform REST calls. */
    private JobsService service;
    /** The service client containing this operation class. */
    private DataLakeAnalyticsJobManagementClientImpl client;

    /**
     * Initializes an instance of JobsImpl.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobsImpl(Retrofit retrofit, DataLakeAnalyticsJobManagementClientImpl client) {
        this.service = retrofit.create(JobsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Jobs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs list" })
        @GET("jobs")
        Observable<Response<ResponseBody>> list(@Query("$filter") String filter, @Query("$top") Integer top, @Query("$skip") Integer skip, @Query("$select") String select, @Query("$orderby") String orderby, @Query("$count") Boolean count, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs create" })
        @PUT("jobs/{jobIdentity}")
        Observable<Response<ResponseBody>> create(@Path("jobIdentity") UUID jobIdentity, @Body CreateJobParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs get" })
        @GET("jobs/{jobIdentity}")
        Observable<Response<ResponseBody>> get(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs update" })
        @PATCH("jobs/{jobIdentity}")
        Observable<Response<ResponseBody>> update(@Path("jobIdentity") UUID jobIdentity, @Body UpdateJobParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginUpdate" })
        @PATCH("jobs/{jobIdentity}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("jobIdentity") UUID jobIdentity, @Body UpdateJobParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs getStatistics" })
        @GET("jobs/{jobIdentity}/GetStatistics")
        Observable<Response<ResponseBody>> getStatistics(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs getDebugDataPath" })
        @GET("jobs/{jobIdentity}/GetDebugDataPath")
        Observable<Response<ResponseBody>> getDebugDataPath(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs cancel" })
        @POST("jobs/{jobIdentity}/CancelJob")
        Observable<Response<ResponseBody>> cancel(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginCancel" })
        @POST("jobs/{jobIdentity}/CancelJob")
        Observable<Response<ResponseBody>> beginCancel(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs yield" })
        @POST("jobs/{jobIdentity}/YieldJob")
        Observable<Response<ResponseBody>> yield(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginYield" })
        @POST("jobs/{jobIdentity}/YieldJob")
        Observable<Response<ResponseBody>> beginYield(@Path("jobIdentity") UUID jobIdentity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs build" })
        @POST("buildJob")
        Observable<Response<ResponseBody>> build(@Body BuildJobParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("x-ms-parameterized-host") String parameterizedHost, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInformationBasic&gt; object if successful.
     */
    public PagedList<JobInformationBasic> list(final String accountName) {
        ServiceResponse<Page<JobInformationBasic>> response = listSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<JobInformationBasic>(response.body()) {
            @Override
            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInformationBasic>> listAsync(final String accountName, final ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(accountName),
            new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<Page<JobInformationBasic>> listAsync(final String accountName) {
        return listWithServiceResponseAsync(accountName)
            .map(new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>() {
                @Override
                public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listWithServiceResponseAsync(final String accountName) {
        return listSinglePageAsync(accountName)
            .concatMap(new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInformationBasic&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listSinglePageAsync(final String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        final String select = null;
        final String orderby = null;
        final Boolean count = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.list(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInformationBasic>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInformationBasic>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInformationBasic&gt; object if successful.
     */
    public PagedList<JobInformationBasic> list(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        ServiceResponse<Page<JobInformationBasic>> response = listSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<JobInformationBasic>(response.body()) {
            @Override
            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInformationBasic>> listAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count, final ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(accountName, filter, top, skip, select, orderby, count),
            new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<Page<JobInformationBasic>> listAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count)
            .map(new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>() {
                @Override
                public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param filter OData filter. Optional.
     * @param top The number of items to return. Optional.
     * @param skip The number of items to skip over before returning elements. Optional.
     * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
     * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
     * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listWithServiceResponseAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        return listSinglePageAsync(accountName, filter, top, skip, select, orderby, count)
            .concatMap(new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
    ServiceResponse<PageImpl<JobInformationBasic>> * @param accountName The Azure Data Lake Analytics account to execute job operations on.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param filter OData filter. Optional.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param top The number of items to return. Optional.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param skip The number of items to skip over before returning elements. Optional.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param select OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description. Optional.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param orderby OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc. Optional.
    ServiceResponse<PageImpl<JobInformationBasic>> * @param count The Boolean value of true or false to request a count of the matching resources included with the resources in the response, e.g. Categories?$count=true. Optional.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInformationBasic&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listSinglePageAsync(final String accountName, final String filter, final Integer top, final Integer skip, final String select, final String orderby, final Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.list(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInformationBasic>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInformationBasic>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInformationBasic>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInformationBasic>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInformationBasic>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Submits a job to the specified Data Lake Analytics account.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to submit a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation create(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        return createWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().single().body();
    }

    /**
     * Submits a job to the specified Data Lake Analytics account.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to submit a job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> createAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    /**
     * Submits a job to the specified Data Lake Analytics account.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to submit a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<JobInformation> createAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        return createWithServiceResponseAsync(accountName, jobIdentity, parameters).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Submits a job to the specified Data Lake Analytics account.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to submit a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<ServiceResponse<JobInformation>> createWithServiceResponseAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.create(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInformation> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInformation> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInformation, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInformation>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the job information for the specified job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity JobInfo ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation get(String accountName, UUID jobIdentity) {
        return getWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Gets the job information for the specified job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity JobInfo ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> getAsync(String accountName, UUID jobIdentity, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Gets the job information for the specified job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity JobInfo ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<JobInformation> getAsync(String accountName, UUID jobIdentity) {
        return getWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the job information for the specified job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity JobInfo ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<ServiceResponse<JobInformation>> getWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.get(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInformation> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInformation, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInformation>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation update(String accountName, UUID jobIdentity) {
        return updateWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last().body();
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> updateAsync(String accountName, UUID jobIdentity, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobInformation> updateAsync(String accountName, UUID jobIdentity) {
        return updateWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobInformation>> updateWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final UpdateJobParameters parameters = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        Observable<Response<ResponseBody>> observable = service.update(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInformation>() { }.getType());
    }
    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation update(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return updateWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().last().body();
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> updateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobInformation> updateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return updateWithServiceResponseAsync(accountName, jobIdentity, parameters).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobInformation>> updateWithServiceResponseAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        Observable<Response<ResponseBody>> observable = service.update(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInformation>() { }.getType());
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation beginUpdate(String accountName, UUID jobIdentity) {
        return beginUpdateWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity) {
        return beginUpdateWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<ServiceResponse<JobInformation>> beginUpdateWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final UpdateJobParameters parameters = null;
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.beginUpdate(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInformation> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation beginUpdate(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().single().body();
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the job information for the specified job ID. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param parameters The parameters to update a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<ServiceResponse<JobInformation>> beginUpdateWithServiceResponseAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.beginUpdate(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInformation> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInformation> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInformation, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInformation>() { }.getType())
                .register(201, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets statistics of the specified job.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job Information ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobStatistics object if successful.
     */
    public JobStatistics getStatistics(String accountName, UUID jobIdentity) {
        return getStatisticsWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Gets statistics of the specified job.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job Information ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobStatistics> getStatisticsAsync(String accountName, UUID jobIdentity, final ServiceCallback<JobStatistics> serviceCallback) {
        return ServiceFuture.fromResponse(getStatisticsWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Gets statistics of the specified job.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job Information ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobStatistics object
     */
    public Observable<JobStatistics> getStatisticsAsync(String accountName, UUID jobIdentity) {
        return getStatisticsWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<JobStatistics>, JobStatistics>() {
            @Override
            public JobStatistics call(ServiceResponse<JobStatistics> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets statistics of the specified job.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job Information ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobStatistics object
     */
    public Observable<ServiceResponse<JobStatistics>> getStatisticsWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.getStatistics(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobStatistics>>>() {
                @Override
                public Observable<ServiceResponse<JobStatistics>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobStatistics> clientResponse = getStatisticsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobStatistics> getStatisticsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobStatistics, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobStatistics>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the job debug data information specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobDataPath object if successful.
     */
    public JobDataPath getDebugDataPath(String accountName, UUID jobIdentity) {
        return getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Gets the job debug data information specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobDataPath> getDebugDataPathAsync(String accountName, UUID jobIdentity, final ServiceCallback<JobDataPath> serviceCallback) {
        return ServiceFuture.fromResponse(getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Gets the job debug data information specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobDataPath object
     */
    public Observable<JobDataPath> getDebugDataPathAsync(String accountName, UUID jobIdentity) {
        return getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<JobDataPath>, JobDataPath>() {
            @Override
            public JobDataPath call(ServiceResponse<JobDataPath> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the job debug data information specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobDataPath object
     */
    public Observable<ServiceResponse<JobDataPath>> getDebugDataPathWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.getDebugDataPath(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobDataPath>>>() {
                @Override
                public Observable<ServiceResponse<JobDataPath>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobDataPath> clientResponse = getDebugDataPathDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobDataPath> getDebugDataPathDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobDataPath, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobDataPath>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancel(String accountName, UUID jobIdentity) {
        cancelWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last().body();
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAsync(String accountName, UUID jobIdentity, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> cancelAsync(String accountName, UUID jobIdentity) {
        return cancelWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        Observable<Response<ResponseBody>> observable = service.cancel(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginCancel(String accountName, UUID jobIdentity) {
        beginCancelWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginCancelAsync(String accountName, UUID jobIdentity, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginCancelWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginCancelAsync(String accountName, UUID jobIdentity) {
        return beginCancelWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels the running job specified by the job ID.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.beginCancel(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginCancelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void yield(String accountName, UUID jobIdentity) {
        yieldWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last().body();
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> yieldAsync(String accountName, UUID jobIdentity, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(yieldWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> yieldAsync(String accountName, UUID jobIdentity) {
        return yieldWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> yieldWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        Observable<Response<ResponseBody>> observable = service.yield(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginYield(String accountName, UUID jobIdentity) {
        beginYieldWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single().body();
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginYieldAsync(String accountName, UUID jobIdentity, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginYieldWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginYieldAsync(String accountName, UUID jobIdentity) {
        return beginYieldWithServiceResponseAsync(accountName, jobIdentity).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Pauses the specified job and places it back in the job queue, behind other jobs of equal or higher importance, based on priority. (Only for use internally with Scope job type.).
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param jobIdentity Job identifier. Uniquely identifies the job across all jobs submitted to the service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginYieldWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.beginYield(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginYieldDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginYieldDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Builds (compiles) the specified job in the specified Data Lake Analytics account for job correctness and validation.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param parameters The parameters to build a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInformation object if successful.
     */
    public JobInformation build(String accountName, BuildJobParameters parameters) {
        return buildWithServiceResponseAsync(accountName, parameters).toBlocking().single().body();
    }

    /**
     * Builds (compiles) the specified job in the specified Data Lake Analytics account for job correctness and validation.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param parameters The parameters to build a job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInformation> buildAsync(String accountName, BuildJobParameters parameters, final ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(buildWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    /**
     * Builds (compiles) the specified job in the specified Data Lake Analytics account for job correctness and validation.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param parameters The parameters to build a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<JobInformation> buildAsync(String accountName, BuildJobParameters parameters) {
        return buildWithServiceResponseAsync(accountName, parameters).map(new Func1<ServiceResponse<JobInformation>, JobInformation>() {
            @Override
            public JobInformation call(ServiceResponse<JobInformation> response) {
                return response.body();
            }
        });
    }

    /**
     * Builds (compiles) the specified job in the specified Data Lake Analytics account for job correctness and validation.
     *
     * @param accountName The Azure Data Lake Analytics account to execute job operations on.
     * @param parameters The parameters to build a job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInformation object
     */
    public Observable<ServiceResponse<JobInformation>> buildWithServiceResponseAsync(String accountName, BuildJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        String parameterizedHost = Joiner.on(", ").join("{accountName}", accountName, "{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix());
        return service.build(parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>() {
                @Override
                public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInformation> clientResponse = buildDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInformation> buildDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInformation, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInformation>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInformationBasic&gt; object if successful.
     */
    public PagedList<JobInformationBasic> listNext(final String nextPageLink) {
        ServiceResponse<Page<JobInformationBasic>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInformationBasic>(response.body()) {
            @Override
            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInformationBasic>> listNextAsync(final String nextPageLink, final ServiceFuture<List<JobInformationBasic>> serviceFuture, final ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<Page<JobInformationBasic>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>() {
                @Override
                public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInformationBasic&gt; object
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the jobs, if any, associated with the specified Data Lake Analytics account. The response includes a link to the next page of results, if any.
     *
    ServiceResponse<PageImpl<JobInformationBasic>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInformationBasic&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInformationBasic>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInformationBasic>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInformationBasic>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInformationBasic>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInformationBasic>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
