/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog entity identifier object.
 */
public class EntityId {
    /**
     * the name of the external table associated with this database, schema and
     * table.
     */
    @JsonProperty(value = "name")
    private DdlName name;

    /**
     * the version of the external data source.
     */
    @JsonProperty(value = "version")
    private UUID version;

    /**
     * Get the name of the external table associated with this database, schema and table.
     *
     * @return the name value
     */
    public DdlName name() {
        return this.name;
    }

    /**
     * Set the name of the external table associated with this database, schema and table.
     *
     * @param name the name value to set
     * @return the EntityId object itself.
     */
    public EntityId withName(DdlName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the version of the external data source.
     *
     * @return the version value
     */
    public UUID version() {
        return this.version;
    }

    /**
     * Set the version of the external data source.
     *
     * @param version the version value to set
     * @return the EntityId object itself.
     */
    public EntityId withVersion(UUID version) {
        this.version = version;
        return this;
    }

}
