/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog U-SQL directed column item.
 */
public class USqlDirectedColumn {
    /**
     * the name of the index in the table.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * the switch indicating if the index is descending or not.
     */
    @JsonProperty(value = "descending")
    private Boolean descending;

    /**
     * Get the name of the index in the table.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the index in the table.
     *
     * @param name the name value to set
     * @return the USqlDirectedColumn object itself.
     */
    public USqlDirectedColumn withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the switch indicating if the index is descending or not.
     *
     * @return the descending value
     */
    public Boolean descending() {
        return this.descending;
    }

    /**
     * Set the switch indicating if the index is descending or not.
     *
     * @param descending the descending value to set
     * @return the USqlDirectedColumn object itself.
     */
    public USqlDirectedColumn withDescending(Boolean descending) {
        this.descending = descending;
        return this;
    }

}
