/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import java.util.UUID;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Data Lake Analytics catalog U-SQL table fragment item.
 */
public class USqlTableFragment {
    /**
     * the parent object Id of the table fragment. The parent could be a table
     * or table partition.
     */
    @JsonProperty(value = "parentId")
    private UUID parentId;

    /**
     * the version of the catalog item.
     */
    @JsonProperty(value = "fragmentId")
    private UUID fragmentId;

    /**
     * the ordinal of the index which contains the table fragment.
     */
    @JsonProperty(value = "indexId")
    private Integer indexId;

    /**
     * the data size of the table fragment in bytes.
     */
    @JsonProperty(value = "size")
    private Long size;

    /**
     * the number of rows in the table fragment.
     */
    @JsonProperty(value = "rowCount")
    private Long rowCount;

    /**
     * the creation time of the table fragment.
     */
    @JsonProperty(value = "createDate")
    private DateTime createDate;

    /**
     * Get the parent object Id of the table fragment. The parent could be a table or table partition.
     *
     * @return the parentId value
     */
    public UUID parentId() {
        return this.parentId;
    }

    /**
     * Set the parent object Id of the table fragment. The parent could be a table or table partition.
     *
     * @param parentId the parentId value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withParentId(UUID parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
     * Get the version of the catalog item.
     *
     * @return the fragmentId value
     */
    public UUID fragmentId() {
        return this.fragmentId;
    }

    /**
     * Set the version of the catalog item.
     *
     * @param fragmentId the fragmentId value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withFragmentId(UUID fragmentId) {
        this.fragmentId = fragmentId;
        return this;
    }

    /**
     * Get the ordinal of the index which contains the table fragment.
     *
     * @return the indexId value
     */
    public Integer indexId() {
        return this.indexId;
    }

    /**
     * Set the ordinal of the index which contains the table fragment.
     *
     * @param indexId the indexId value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withIndexId(Integer indexId) {
        this.indexId = indexId;
        return this;
    }

    /**
     * Get the data size of the table fragment in bytes.
     *
     * @return the size value
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the data size of the table fragment in bytes.
     *
     * @param size the size value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the number of rows in the table fragment.
     *
     * @return the rowCount value
     */
    public Long rowCount() {
        return this.rowCount;
    }

    /**
     * Set the number of rows in the table fragment.
     *
     * @param rowCount the rowCount value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withRowCount(Long rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    /**
     * Get the creation time of the table fragment.
     *
     * @return the createDate value
     */
    public DateTime createDate() {
        return this.createDate;
    }

    /**
     * Set the creation time of the table fragment.
     *
     * @param createDate the createDate value to set
     * @return the USqlTableFragment object itself.
     */
    public USqlTableFragment withCreateDate(DateTime createDate) {
        this.createDate = createDate;
        return this;
    }

}
