/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.analytics.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The parameters used to update a Data Lake Store account while updating a
 * Data Lake Analytics account.
 */
@JsonFlatten
public class UpdateDataLakeStoreWithAccountParameters {
    /**
     * The unique name of the Data Lake Store account to update.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The optional suffix for the Data Lake Store account.
     */
    @JsonProperty(value = "properties.suffix")
    private String suffix;

    /**
     * Get the unique name of the Data Lake Store account to update.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the unique name of the Data Lake Store account to update.
     *
     * @param name the name value to set
     * @return the UpdateDataLakeStoreWithAccountParameters object itself.
     */
    public UpdateDataLakeStoreWithAccountParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the optional suffix for the Data Lake Store account.
     *
     * @return the suffix value
     */
    public String suffix() {
        return this.suffix;
    }

    /**
     * Set the optional suffix for the Data Lake Store account.
     *
     * @param suffix the suffix value to set
     * @return the UpdateDataLakeStoreWithAccountParameters object itself.
     */
    public UpdateDataLakeStoreWithAccountParameters withSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

}
