/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.Accounts;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.CheckNameAvailabilityParameters;
import com.microsoft.azure.management.datalake.analytics.models.CreateDataLakeAnalyticsAccountParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsAccount;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeAnalyticsAccountBasic;
import com.microsoft.azure.management.datalake.analytics.models.NameAvailabilityInformation;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.UpdateDataLakeAnalyticsAccountParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AccountsImpl
implements Accounts {
    private AccountsService service;
    private DataLakeAnalyticsAccountManagementClientImpl client;

    public AccountsImpl(Retrofit retrofit, DataLakeAnalyticsAccountManagementClientImpl client) {
        this.service = (AccountsService)retrofit.create(AccountsService.class);
        this.client = client;
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listAsync(ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        return this.service.list(this.client.subscriptionId(), filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> list(String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listAsync(String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listAsync(String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listWithServiceResponseAsync(filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listWithServiceResponseAsync(String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listSinglePageAsync(filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listSinglePageAsync(String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeAnalyticsAccountBasic>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeAnalyticsAccountBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> listByResourceGroup(String resourceGroupName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeAnalyticsAccountBasic>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeAnalyticsAccountBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public DataLakeAnalyticsAccount create(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().last()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> createAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> createAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> createWithServiceResponseAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DataLakeAnalyticsAccount>(){}.getType());
    }

    @Override
    public DataLakeAnalyticsAccount beginCreate(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> beginCreateAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> beginCreateAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, CreateDataLakeAnalyticsAccountParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataLakeAnalyticsAccount>>>(){

            public Observable<ServiceResponse<DataLakeAnalyticsAccount>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DataLakeAnalyticsAccount> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).register(201, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public DataLakeAnalyticsAccount get(String resourceGroupName, String accountName) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> getAsync(String resourceGroupName, String accountName, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> getAsync(String resourceGroupName, String accountName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> getWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataLakeAnalyticsAccount>>>(){

            public Observable<ServiceResponse<DataLakeAnalyticsAccount>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DataLakeAnalyticsAccount> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public DataLakeAnalyticsAccount update(String resourceGroupName, String accountName) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> updateAsync(String resourceGroupName, String accountName, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> updateAsync(String resourceGroupName, String accountName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> updateWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateDataLakeAnalyticsAccountParameters parameters = null;
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DataLakeAnalyticsAccount>(){}.getType());
    }

    @Override
    public DataLakeAnalyticsAccount update(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().last()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> updateAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> updateAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DataLakeAnalyticsAccount>(){}.getType());
    }

    @Override
    public DataLakeAnalyticsAccount beginUpdate(String resourceGroupName, String accountName) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> beginUpdateAsync(String resourceGroupName, String accountName, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> beginUpdateAsync(String resourceGroupName, String accountName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateDataLakeAnalyticsAccountParameters parameters = null;
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataLakeAnalyticsAccount>>>(){

            public Observable<ServiceResponse<DataLakeAnalyticsAccount>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public DataLakeAnalyticsAccount beginUpdate(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        return (DataLakeAnalyticsAccount)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    @Override
    public ServiceFuture<DataLakeAnalyticsAccount> beginUpdateAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters, ServiceCallback<DataLakeAnalyticsAccount> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<DataLakeAnalyticsAccount> beginUpdateAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<DataLakeAnalyticsAccount>, DataLakeAnalyticsAccount>(){

            public DataLakeAnalyticsAccount call(ServiceResponse<DataLakeAnalyticsAccount> response) {
                return (DataLakeAnalyticsAccount)((Object)response.body());
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeAnalyticsAccount>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, UpdateDataLakeAnalyticsAccountParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataLakeAnalyticsAccount>>>(){

            public Observable<ServiceResponse<DataLakeAnalyticsAccount>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DataLakeAnalyticsAccount> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).register(201, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).register(202, new TypeToken<DataLakeAnalyticsAccount>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    @Override
    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    @Override
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public NameAvailabilityInformation checkNameAvailability(String location, String name) {
        return (NameAvailabilityInformation)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(location, name).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<NameAvailabilityInformation> checkNameAvailabilityAsync(String location, String name, ServiceCallback<NameAvailabilityInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(location, name), serviceCallback);
    }

    @Override
    public Observable<NameAvailabilityInformation> checkNameAvailabilityAsync(String location, String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(location, name).map((Func1)new Func1<ServiceResponse<NameAvailabilityInformation>, NameAvailabilityInformation>(){

            public NameAvailabilityInformation call(ServiceResponse<NameAvailabilityInformation> response) {
                return (NameAvailabilityInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<NameAvailabilityInformation>> checkNameAvailabilityWithServiceResponseAsync(String location, String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityParameters parameters = new CheckNameAvailabilityParameters();
        parameters.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NameAvailabilityInformation>>>(){

            public Observable<ServiceResponse<NameAvailabilityInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AccountsImpl.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NameAvailabilityInformation> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NameAvailabilityInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listNextAsync(String nextPageLink, ServiceFuture<List<DataLakeAnalyticsAccountBasic>> serviceFuture, ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeAnalyticsAccountBasic>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeAnalyticsAccountBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DataLakeAnalyticsAccountBasic> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DataLakeAnalyticsAccountBasic>((Page)response.body()){

            public Page<DataLakeAnalyticsAccountBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeAnalyticsAccountBasic>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DataLakeAnalyticsAccountBasic>> serviceFuture, ListOperationCallback<DataLakeAnalyticsAccountBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(String nextPageLink) {
                return AccountsImpl.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeAnalyticsAccountBasic>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Page<DataLakeAnalyticsAccountBasic>>(){

            public Page<DataLakeAnalyticsAccountBasic> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(ServiceResponse<Page<DataLakeAnalyticsAccountBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>>>(){

            public Observable<ServiceResponse<Page<DataLakeAnalyticsAccountBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AccountsImpl.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeAnalyticsAccountBasic>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeAnalyticsAccountBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/accounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="$skip") Integer var4, @Query(value="$select") String var5, @Query(value="$orderby") String var6, @Query(value="$count") Boolean var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="$skip") Integer var5, @Query(value="$select") String var6, @Query(value="$orderby") String var7, @Query(value="$count") Boolean var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Body CreateDataLakeAnalyticsAccountParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Body CreateDataLakeAnalyticsAccountParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Body UpdateDataLakeAnalyticsAccountParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Body UpdateDataLakeAnalyticsAccountParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/locations/{location}/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CheckNameAvailabilityParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Accounts listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

