/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.AddDataLakeStoreParameters;
import com.microsoft.azure.management.datalake.analytics.models.DataLakeStoreAccountInformation;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DataLakeStoreAccountsImpl
implements DataLakeStoreAccounts {
    private DataLakeStoreAccountsService service;
    private DataLakeAnalyticsAccountManagementClientImpl client;

    public DataLakeStoreAccountsImpl(Retrofit retrofit, DataLakeAnalyticsAccountManagementClientImpl client) {
        this.service = (DataLakeStoreAccountsService)retrofit.create(DataLakeStoreAccountsService.class);
        this.client = client;
    }

    @Override
    public PagedList<DataLakeStoreAccountInformation> listByAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<DataLakeStoreAccountInformation>((Page)response.body()){

            public Page<DataLakeStoreAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeStoreAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<DataLakeStoreAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(String nextPageLink) {
                return DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeStoreAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Page<DataLakeStoreAccountInformation>>(){

            public Page<DataLakeStoreAccountInformation> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DataLakeStoreAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DataLakeStoreAccountsImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DataLakeStoreAccountInformation> listByAccount(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<DataLakeStoreAccountInformation>((Page)response.body()){

            public Page<DataLakeStoreAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeStoreAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<DataLakeStoreAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(String nextPageLink) {
                return DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeStoreAccountInformation>> listByAccountAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Page<DataLakeStoreAccountInformation>>(){

            public Page<DataLakeStoreAccountInformation> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DataLakeStoreAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DataLakeStoreAccountsImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeStoreAccountInformation>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeStoreAccountInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void add(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        ((ServiceResponse)this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        return this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> addWithServiceResponseAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (dataLakeStoreAccountName == null) {
            throw new IllegalArgumentException("Parameter dataLakeStoreAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object suffix = null;
        AddDataLakeStoreParameters parameters = new AddDataLakeStoreParameters();
        parameters.withSuffix(null);
        return this.service.add(this.client.subscriptionId(), resourceGroupName, accountName, dataLakeStoreAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DataLakeStoreAccountsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(String resourceGroupName, String accountName, String dataLakeStoreAccountName, String suffix) {
        ((ServiceResponse)this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName, suffix).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, String suffix, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName, suffix), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, String suffix) {
        return this.addWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName, suffix).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> addWithServiceResponseAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, String suffix) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (dataLakeStoreAccountName == null) {
            throw new IllegalArgumentException("Parameter dataLakeStoreAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        AddDataLakeStoreParameters parameters = null;
        if (suffix != null) {
            parameters = new AddDataLakeStoreParameters();
            parameters.withSuffix(suffix);
        }
        return this.service.add(this.client.subscriptionId(), resourceGroupName, accountName, dataLakeStoreAccountName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DataLakeStoreAccountsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> addDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public DataLakeStoreAccountInformation get(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        return (DataLakeStoreAccountInformation)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DataLakeStoreAccountInformation> getAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, ServiceCallback<DataLakeStoreAccountInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName), serviceCallback);
    }

    @Override
    public Observable<DataLakeStoreAccountInformation> getAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).map((Func1)new Func1<ServiceResponse<DataLakeStoreAccountInformation>, DataLakeStoreAccountInformation>(){

            public DataLakeStoreAccountInformation call(ServiceResponse<DataLakeStoreAccountInformation> response) {
                return (DataLakeStoreAccountInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DataLakeStoreAccountInformation>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (dataLakeStoreAccountName == null) {
            throw new IllegalArgumentException("Parameter dataLakeStoreAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, dataLakeStoreAccountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataLakeStoreAccountInformation>>>(){

            public Observable<ServiceResponse<DataLakeStoreAccountInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DataLakeStoreAccountsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DataLakeStoreAccountInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DataLakeStoreAccountInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, dataLakeStoreAccountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String dataLakeStoreAccountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (dataLakeStoreAccountName == null) {
            throw new IllegalArgumentException("Parameter dataLakeStoreAccountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, dataLakeStoreAccountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DataLakeStoreAccountsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DataLakeStoreAccountInformation> listByAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DataLakeStoreAccountInformation>((Page)response.body()){

            public Page<DataLakeStoreAccountInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DataLakeStoreAccountInformation>> listByAccountNextAsync(String nextPageLink, ServiceFuture<List<DataLakeStoreAccountInformation>> serviceFuture, ListOperationCallback<DataLakeStoreAccountInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(String nextPageLink) {
                return DataLakeStoreAccountsImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DataLakeStoreAccountInformation>> listByAccountNextAsync(String nextPageLink) {
        return this.listByAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Page<DataLakeStoreAccountInformation>>(){

            public Page<DataLakeStoreAccountInformation> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DataLakeStoreAccountInformation>>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(ServiceResponse<Page<DataLakeStoreAccountInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DataLakeStoreAccountsImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> listByAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>>>(){

            public Observable<ServiceResponse<Page<DataLakeStoreAccountInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DataLakeStoreAccountsImpl.this.listByAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataLakeStoreAccountInformation>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataLakeStoreAccountInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DataLakeStoreAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts listByAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts")
        public Observable<Response<ResponseBody>> listByAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="$filter") String var4, @Query(value="$top") Integer var5, @Query(value="$skip") Integer var6, @Query(value="$select") String var7, @Query(value="$orderby") String var8, @Query(value="$count") Boolean var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts add"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}")
        public Observable<Response<ResponseBody>> add(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="dataLakeStoreAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body AddDataLakeStoreParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="dataLakeStoreAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="dataLakeStoreAccountName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.DataLakeStoreAccounts listByAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

