/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.Jobs;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsJobManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.BuildJobParameters;
import com.microsoft.azure.management.datalake.analytics.models.CreateJobParameters;
import com.microsoft.azure.management.datalake.analytics.models.JobDataPath;
import com.microsoft.azure.management.datalake.analytics.models.JobInformation;
import com.microsoft.azure.management.datalake.analytics.models.JobInformationBasic;
import com.microsoft.azure.management.datalake.analytics.models.JobStatistics;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.UpdateJobParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobsImpl
implements Jobs {
    private JobsService service;
    private DataLakeAnalyticsJobManagementClientImpl client;

    public JobsImpl(Retrofit retrofit, DataLakeAnalyticsJobManagementClientImpl client) {
        this.service = (JobsService)retrofit.create(JobsService.class);
        this.client = client;
    }

    @Override
    public PagedList<JobInformationBasic> list(String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<JobInformationBasic>((Page)response.body()){

            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobInformationBasic>> listAsync(String accountName, ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobInformationBasic>> listAsync(String accountName) {
        return this.listWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>(){

            public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listWithServiceResponseAsync(String accountName) {
        return this.listSinglePageAsync(accountName).concatMap((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInformationBasic>>> listSinglePageAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        Integer skip = null;
        String select = null;
        String orderby = null;
        Boolean count = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<JobInformationBasic> list(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName, filter, top, skip, select, orderby, count).toBlocking().single();
        return new PagedList<JobInformationBasic>((Page)response.body()){

            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobInformationBasic>> listAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count, ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName, filter, top, skip, select, orderby, count), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobInformationBasic>> listAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listWithServiceResponseAsync(accountName, filter, top, skip, select, orderby, count).map((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>(){

            public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listWithServiceResponseAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        return this.listSinglePageAsync(accountName, filter, top, skip, select, orderby, count).concatMap((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInformationBasic>>> listSinglePageAsync(String accountName, String filter, Integer top, Integer skip, String select, String orderby, Boolean count) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(filter, top, skip, select, orderby, count, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInformationBasic>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInformationBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobInformation create(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        return (JobInformation)((ServiceResponse)this.createWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobInformation> createAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    @Override
    public Observable<JobInformation> createAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        return this.createWithServiceResponseAsync(accountName, jobIdentity, parameters).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> createWithServiceResponseAsync(String accountName, UUID jobIdentity, CreateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.create(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>(){

            public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInformation> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobInformation get(String accountName, UUID jobIdentity) {
        return (JobInformation)((ServiceResponse)this.getWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobInformation> getAsync(String accountName, UUID jobIdentity, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<JobInformation> getAsync(String accountName, UUID jobIdentity) {
        return this.getWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> getWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.get(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>(){

            public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobInformation update(String accountName, UUID jobIdentity) {
        return (JobInformation)((ServiceResponse)this.updateWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last()).body();
    }

    @Override
    public ServiceFuture<JobInformation> updateAsync(String accountName, UUID jobIdentity, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<JobInformation> updateAsync(String accountName, UUID jobIdentity) {
        return this.updateWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> updateWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateJobParameters parameters = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        Observable<Response<ResponseBody>> observable = this.service.update(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInformation>(){}.getType());
    }

    @Override
    public JobInformation update(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return (JobInformation)((ServiceResponse)this.updateWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().last()).body();
    }

    @Override
    public ServiceFuture<JobInformation> updateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    @Override
    public Observable<JobInformation> updateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return this.updateWithServiceResponseAsync(accountName, jobIdentity, parameters).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> updateWithServiceResponseAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        Observable<Response<ResponseBody>> observable = this.service.update(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInformation>(){}.getType());
    }

    @Override
    public JobInformation beginUpdate(String accountName, UUID jobIdentity) {
        return (JobInformation)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity) {
        return this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> beginUpdateWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateJobParameters parameters = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.beginUpdate(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>(){

            public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public JobInformation beginUpdate(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return (JobInformation)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters), serviceCallback);
    }

    @Override
    public Observable<JobInformation> beginUpdateAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        return this.beginUpdateWithServiceResponseAsync(accountName, jobIdentity, parameters).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> beginUpdateWithServiceResponseAsync(String accountName, UUID jobIdentity, UpdateJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.beginUpdate(jobIdentity, parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>(){

            public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInformation> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInformation>(){}.getType()).register(201, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobStatistics getStatistics(String accountName, UUID jobIdentity) {
        return (JobStatistics)((ServiceResponse)this.getStatisticsWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobStatistics> getStatisticsAsync(String accountName, UUID jobIdentity, ServiceCallback<JobStatistics> serviceCallback) {
        return ServiceFuture.fromResponse(this.getStatisticsWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<JobStatistics> getStatisticsAsync(String accountName, UUID jobIdentity) {
        return this.getStatisticsWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<JobStatistics>, JobStatistics>(){

            public JobStatistics call(ServiceResponse<JobStatistics> response) {
                return (JobStatistics)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobStatistics>> getStatisticsWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.getStatistics(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobStatistics>>>(){

            public Observable<ServiceResponse<JobStatistics>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.getStatisticsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobStatistics> getStatisticsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobStatistics>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobDataPath getDebugDataPath(String accountName, UUID jobIdentity) {
        return (JobDataPath)((ServiceResponse)this.getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobDataPath> getDebugDataPathAsync(String accountName, UUID jobIdentity, ServiceCallback<JobDataPath> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<JobDataPath> getDebugDataPathAsync(String accountName, UUID jobIdentity) {
        return this.getDebugDataPathWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<JobDataPath>, JobDataPath>(){

            public JobDataPath call(ServiceResponse<JobDataPath> response) {
                return (JobDataPath)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobDataPath>> getDebugDataPathWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.getDebugDataPath(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobDataPath>>>(){

            public Observable<ServiceResponse<JobDataPath>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.getDebugDataPathDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobDataPath> getDebugDataPathDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobDataPath>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void cancel(String accountName, UUID jobIdentity) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last()).body();
    }

    @Override
    public ServiceFuture<Void> cancelAsync(String accountName, UUID jobIdentity, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<Void> cancelAsync(String accountName, UUID jobIdentity) {
        return this.cancelWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        Observable<Response<ResponseBody>> observable = this.service.cancel(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    @Override
    public void beginCancel(String accountName, UUID jobIdentity) {
        ((ServiceResponse)this.beginCancelWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> beginCancelAsync(String accountName, UUID jobIdentity, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCancelWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<Void> beginCancelAsync(String accountName, UUID jobIdentity) {
        return this.beginCancelWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.beginCancel(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.beginCancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void yield(String accountName, UUID jobIdentity) {
        ((ServiceResponse)this.yieldWithServiceResponseAsync(accountName, jobIdentity).toBlocking().last()).body();
    }

    @Override
    public ServiceFuture<Void> yieldAsync(String accountName, UUID jobIdentity, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.yieldWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<Void> yieldAsync(String accountName, UUID jobIdentity) {
        return this.yieldWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> yieldWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        Observable<Response<ResponseBody>> observable = this.service.yield(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    @Override
    public void beginYield(String accountName, UUID jobIdentity) {
        ((ServiceResponse)this.beginYieldWithServiceResponseAsync(accountName, jobIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> beginYieldAsync(String accountName, UUID jobIdentity, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginYieldWithServiceResponseAsync(accountName, jobIdentity), serviceCallback);
    }

    @Override
    public Observable<Void> beginYieldAsync(String accountName, UUID jobIdentity) {
        return this.beginYieldWithServiceResponseAsync(accountName, jobIdentity).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> beginYieldWithServiceResponseAsync(String accountName, UUID jobIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (jobIdentity == null) {
            throw new IllegalArgumentException("Parameter jobIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.beginYield(jobIdentity, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.beginYieldDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginYieldDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobInformation build(String accountName, BuildJobParameters parameters) {
        return (JobInformation)((ServiceResponse)this.buildWithServiceResponseAsync(accountName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobInformation> buildAsync(String accountName, BuildJobParameters parameters, ServiceCallback<JobInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.buildWithServiceResponseAsync(accountName, parameters), serviceCallback);
    }

    @Override
    public Observable<JobInformation> buildAsync(String accountName, BuildJobParameters parameters) {
        return this.buildWithServiceResponseAsync(accountName, parameters).map((Func1)new Func1<ServiceResponse<JobInformation>, JobInformation>(){

            public JobInformation call(ServiceResponse<JobInformation> response) {
                return (JobInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobInformation>> buildWithServiceResponseAsync(String accountName, BuildJobParameters parameters) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.build(parameters, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInformation>>>(){

            public Observable<ServiceResponse<JobInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsImpl.this.buildDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInformation> buildDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<JobInformationBasic> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInformationBasic>((Page)response.body()){

            public Page<JobInformationBasic> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobInformationBasic>> listNextAsync(String nextPageLink, ServiceFuture<List<JobInformationBasic>> serviceFuture, ListOperationCallback<JobInformationBasic> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobInformationBasic>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Page<JobInformationBasic>>(){

            public Page<JobInformationBasic> call(ServiceResponse<Page<JobInformationBasic>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobInformationBasic>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobInformationBasic>>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(ServiceResponse<Page<JobInformationBasic>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInformationBasic>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInformationBasic>>>>(){

            public Observable<ServiceResponse<Page<JobInformationBasic>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInformationBasic>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInformationBasic>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs list"})
        @GET(value="jobs")
        public Observable<Response<ResponseBody>> list(@Query(value="$filter") String var1, @Query(value="$top") Integer var2, @Query(value="$skip") Integer var3, @Query(value="$select") String var4, @Query(value="$orderby") String var5, @Query(value="$count") Boolean var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs create"})
        @PUT(value="jobs/{jobIdentity}")
        public Observable<Response<ResponseBody>> create(@Path(value="jobIdentity") UUID var1, @Body CreateJobParameters var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs get"})
        @GET(value="jobs/{jobIdentity}")
        public Observable<Response<ResponseBody>> get(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs update"})
        @PATCH(value="jobs/{jobIdentity}")
        public Observable<Response<ResponseBody>> update(@Path(value="jobIdentity") UUID var1, @Body UpdateJobParameters var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginUpdate"})
        @PATCH(value="jobs/{jobIdentity}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="jobIdentity") UUID var1, @Body UpdateJobParameters var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs getStatistics"})
        @GET(value="jobs/{jobIdentity}/GetStatistics")
        public Observable<Response<ResponseBody>> getStatistics(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs getDebugDataPath"})
        @GET(value="jobs/{jobIdentity}/GetDebugDataPath")
        public Observable<Response<ResponseBody>> getDebugDataPath(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs cancel"})
        @POST(value="jobs/{jobIdentity}/CancelJob")
        public Observable<Response<ResponseBody>> cancel(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginCancel"})
        @POST(value="jobs/{jobIdentity}/CancelJob")
        public Observable<Response<ResponseBody>> beginCancel(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs yield"})
        @POST(value="jobs/{jobIdentity}/YieldJob")
        public Observable<Response<ResponseBody>> yield(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs beginYield"})
        @POST(value="jobs/{jobIdentity}/YieldJob")
        public Observable<Response<ResponseBody>> beginYield(@Path(value="jobIdentity") UUID var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs build"})
        @POST(value="buildJob")
        public Observable<Response<ResponseBody>> build(@Body BuildJobParameters var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Jobs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

