/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.Recurrences;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsJobManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.JobRecurrenceInformation;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RecurrencesImpl
implements Recurrences {
    private RecurrencesService service;
    private DataLakeAnalyticsJobManagementClientImpl client;

    public RecurrencesImpl(Retrofit retrofit, DataLakeAnalyticsJobManagementClientImpl client) {
        this.service = (RecurrencesService)retrofit.create(RecurrencesService.class);
        this.client = client;
    }

    @Override
    public PagedList<JobRecurrenceInformation> list(String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName).toBlocking().single();
        return new PagedList<JobRecurrenceInformation>((Page)response.body()){

            public Page<JobRecurrenceInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobRecurrenceInformation>> listAsync(String accountName, ListOperationCallback<JobRecurrenceInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(String nextPageLink) {
                return RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobRecurrenceInformation>> listAsync(String accountName) {
        return this.listWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Page<JobRecurrenceInformation>>(){

            public Page<JobRecurrenceInformation> call(ServiceResponse<Page<JobRecurrenceInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listWithServiceResponseAsync(String accountName) {
        return this.listSinglePageAsync(accountName).concatMap((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(ServiceResponse<Page<JobRecurrenceInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecurrencesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listSinglePageAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DateTime startDateTime = null;
        DateTime endDateTime = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecurrencesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<JobRecurrenceInformation> list(String accountName, DateTime startDateTime, DateTime endDateTime) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(accountName, startDateTime, endDateTime).toBlocking().single();
        return new PagedList<JobRecurrenceInformation>((Page)response.body()){

            public Page<JobRecurrenceInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobRecurrenceInformation>> listAsync(String accountName, DateTime startDateTime, DateTime endDateTime, ListOperationCallback<JobRecurrenceInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(accountName, startDateTime, endDateTime), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(String nextPageLink) {
                return RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobRecurrenceInformation>> listAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        return this.listWithServiceResponseAsync(accountName, startDateTime, endDateTime).map((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Page<JobRecurrenceInformation>>(){

            public Page<JobRecurrenceInformation> call(ServiceResponse<Page<JobRecurrenceInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listWithServiceResponseAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        return this.listSinglePageAsync(accountName, startDateTime, endDateTime).concatMap((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(ServiceResponse<Page<JobRecurrenceInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecurrencesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listSinglePageAsync(String accountName, DateTime startDateTime, DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.list(startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecurrencesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobRecurrenceInformation>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobRecurrenceInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public JobRecurrenceInformation get(String accountName, UUID recurrenceIdentity) {
        return (JobRecurrenceInformation)((ServiceResponse)this.getWithServiceResponseAsync(accountName, recurrenceIdentity).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobRecurrenceInformation> getAsync(String accountName, UUID recurrenceIdentity, ServiceCallback<JobRecurrenceInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(accountName, recurrenceIdentity), serviceCallback);
    }

    @Override
    public Observable<JobRecurrenceInformation> getAsync(String accountName, UUID recurrenceIdentity) {
        return this.getWithServiceResponseAsync(accountName, recurrenceIdentity).map((Func1)new Func1<ServiceResponse<JobRecurrenceInformation>, JobRecurrenceInformation>(){

            public JobRecurrenceInformation call(ServiceResponse<JobRecurrenceInformation> response) {
                return (JobRecurrenceInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobRecurrenceInformation>> getWithServiceResponseAsync(String accountName, UUID recurrenceIdentity) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (recurrenceIdentity == null) {
            throw new IllegalArgumentException("Parameter recurrenceIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        DateTime startDateTime = null;
        DateTime endDateTime = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.get(recurrenceIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobRecurrenceInformation>>>(){

            public Observable<ServiceResponse<JobRecurrenceInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecurrencesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public JobRecurrenceInformation get(String accountName, UUID recurrenceIdentity, DateTime startDateTime, DateTime endDateTime) {
        return (JobRecurrenceInformation)((ServiceResponse)this.getWithServiceResponseAsync(accountName, recurrenceIdentity, startDateTime, endDateTime).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobRecurrenceInformation> getAsync(String accountName, UUID recurrenceIdentity, DateTime startDateTime, DateTime endDateTime, ServiceCallback<JobRecurrenceInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(accountName, recurrenceIdentity, startDateTime, endDateTime), serviceCallback);
    }

    @Override
    public Observable<JobRecurrenceInformation> getAsync(String accountName, UUID recurrenceIdentity, DateTime startDateTime, DateTime endDateTime) {
        return this.getWithServiceResponseAsync(accountName, recurrenceIdentity, startDateTime, endDateTime).map((Func1)new Func1<ServiceResponse<JobRecurrenceInformation>, JobRecurrenceInformation>(){

            public JobRecurrenceInformation call(ServiceResponse<JobRecurrenceInformation> response) {
                return (JobRecurrenceInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<JobRecurrenceInformation>> getWithServiceResponseAsync(String accountName, UUID recurrenceIdentity, DateTime startDateTime, DateTime endDateTime) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.adlaJobDnsSuffix() == null) {
            throw new IllegalArgumentException("Parameter this.client.adlaJobDnsSuffix() is required and cannot be null.");
        }
        if (recurrenceIdentity == null) {
            throw new IllegalArgumentException("Parameter recurrenceIdentity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{accountName}", (Object)accountName, new Object[]{"{adlaJobDnsSuffix}", this.client.adlaJobDnsSuffix()});
        return this.service.get(recurrenceIdentity, startDateTime, endDateTime, this.client.apiVersion(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobRecurrenceInformation>>>(){

            public Observable<ServiceResponse<JobRecurrenceInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecurrencesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobRecurrenceInformation> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobRecurrenceInformation>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<JobRecurrenceInformation> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobRecurrenceInformation>((Page)response.body()){

            public Page<JobRecurrenceInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobRecurrenceInformation>> listNextAsync(String nextPageLink, ServiceFuture<List<JobRecurrenceInformation>> serviceFuture, ListOperationCallback<JobRecurrenceInformation> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(String nextPageLink) {
                return RecurrencesImpl.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobRecurrenceInformation>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Page<JobRecurrenceInformation>>(){

            public Page<JobRecurrenceInformation> call(ServiceResponse<Page<JobRecurrenceInformation>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobRecurrenceInformation>>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(ServiceResponse<Page<JobRecurrenceInformation>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecurrencesImpl.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobRecurrenceInformation>>>>(){

            public Observable<ServiceResponse<Page<JobRecurrenceInformation>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecurrencesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobRecurrenceInformation>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobRecurrenceInformation>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RecurrencesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Recurrences list"})
        @GET(value="recurrences")
        public Observable<Response<ResponseBody>> list(@Query(value="startDateTime") DateTime var1, @Query(value="endDateTime") DateTime var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Recurrences get"})
        @GET(value="recurrences/{recurrenceIdentity}")
        public Observable<Response<ResponseBody>> get(@Path(value="recurrenceIdentity") UUID var1, @Query(value="startDateTime") DateTime var2, @Query(value="endDateTime") DateTime var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.Recurrences listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

