/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.store.implementation;

import retrofit2.Retrofit;
import com.microsoft.azure.management.datalake.store.TrustedIdProviders;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.datalake.store.models.CreateOrUpdateTrustedIdProviderParameters;
import com.microsoft.azure.management.datalake.store.models.PageImpl;
import com.microsoft.azure.management.datalake.store.models.TrustedIdProvider;
import com.microsoft.azure.management.datalake.store.models.UpdateTrustedIdProviderParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in TrustedIdProviders.
 */
public class TrustedIdProvidersImpl implements TrustedIdProviders {
    /** The Retrofit service to perform REST calls. */
    private TrustedIdProvidersService service;
    /** The service client containing this operation class. */
    private DataLakeStoreAccountManagementClientImpl client;

    /**
     * Initializes an instance of TrustedIdProvidersImpl.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public TrustedIdProvidersImpl(Retrofit retrofit, DataLakeStoreAccountManagementClientImpl client) {
        this.service = retrofit.create(TrustedIdProvidersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for TrustedIdProviders to be
     * used by Retrofit to perform actually REST calls.
     */
    interface TrustedIdProvidersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders listByAccount" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders")
        Observable<Response<ResponseBody>> listByAccount(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("trustedIdProviderName") String trustedIdProviderName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CreateOrUpdateTrustedIdProviderParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("trustedIdProviderName") String trustedIdProviderName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("trustedIdProviderName") String trustedIdProviderName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body UpdateTrustedIdProviderParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("trustedIdProviderName") String trustedIdProviderName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders listByAccountNext" })
        @GET
        Observable<Response<ResponseBody>> listByAccountNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;TrustedIdProvider&gt; object if successful.
     */
    public PagedList<TrustedIdProvider> listByAccount(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<TrustedIdProvider>> response = listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<TrustedIdProvider>(response.body()) {
            @Override
            public Page<TrustedIdProvider> nextPage(String nextPageLink) {
                return listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<TrustedIdProvider>> listByAccountAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<TrustedIdProvider> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAccountSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(String nextPageLink) {
                    return listByAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TrustedIdProvider&gt; object
     */
    public Observable<Page<TrustedIdProvider>> listByAccountAsync(final String resourceGroupName, final String accountName) {
        return listByAccountWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<TrustedIdProvider>>, Page<TrustedIdProvider>>() {
                @Override
                public Page<TrustedIdProvider> call(ServiceResponse<Page<TrustedIdProvider>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TrustedIdProvider&gt; object
     */
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listByAccountSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<TrustedIdProvider>>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(ServiceResponse<Page<TrustedIdProvider>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
    ServiceResponse<PageImpl<TrustedIdProvider>> * @param resourceGroupName The name of the Azure resource group.
    ServiceResponse<PageImpl<TrustedIdProvider>> * @param accountName The name of the Data Lake Store account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;TrustedIdProvider&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<TrustedIdProvider>> result = listByAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<TrustedIdProvider>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<TrustedIdProvider>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<TrustedIdProvider>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<TrustedIdProvider>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TrustedIdProvider object if successful.
     */
    public TrustedIdProvider createOrUpdate(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TrustedIdProvider> createOrUpdateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider, final ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider), serviceCallback);
    }

    /**
     * Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<TrustedIdProvider> createOrUpdateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).map(new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>() {
            @Override
            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<ServiceResponse<TrustedIdProvider>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("Parameter idProvider is required and cannot be null.");
        }
        CreateOrUpdateTrustedIdProviderParameters parameters = new CreateOrUpdateTrustedIdProviderParameters();
        parameters.withIdProvider(idProvider);
        return service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>() {
                @Override
                public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TrustedIdProvider> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TrustedIdProvider> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TrustedIdProvider, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TrustedIdProvider>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified Data Lake Store trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TrustedIdProvider object if successful.
     */
    public TrustedIdProvider get(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single().body();
    }

    /**
     * Gets the specified Data Lake Store trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TrustedIdProvider> getAsync(String resourceGroupName, String accountName, String trustedIdProviderName, final ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    /**
     * Gets the specified Data Lake Store trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<TrustedIdProvider> getAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map(new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>() {
            @Override
            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Data Lake Store trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<ServiceResponse<TrustedIdProvider>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>() {
                @Override
                public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TrustedIdProvider> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TrustedIdProvider> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TrustedIdProvider, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TrustedIdProvider>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TrustedIdProvider object if successful.
     */
    public TrustedIdProvider update(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single().body();
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, final ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map(new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>() {
            @Override
            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<ServiceResponse<TrustedIdProvider>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String idProvider = null;
        UpdateTrustedIdProviderParameters parameters = new UpdateTrustedIdProviderParameters();
        parameters.withIdProvider(null);
        return service.update(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>() {
                @Override
                public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TrustedIdProvider> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TrustedIdProvider object if successful.
     */
    public TrustedIdProvider update(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).toBlocking().single().body();
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider, final ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider), serviceCallback);
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).map(new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>() {
            @Override
            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the specified trusted identity provider.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider. This is used for differentiation of providers in the account.
     * @param idProvider The URL of this trusted identity provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TrustedIdProvider object
     */
    public Observable<ServiceResponse<TrustedIdProvider>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateTrustedIdProviderParameters parameters = null;
        if (idProvider != null) {
            parameters = new UpdateTrustedIdProviderParameters();
            parameters.withIdProvider(idProvider);
        }
        return service.update(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>() {
                @Override
                public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TrustedIdProvider> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TrustedIdProvider> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TrustedIdProvider, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TrustedIdProvider>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified trusted identity provider from the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String accountName, String trustedIdProviderName) {
        deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single().body();
    }

    /**
     * Deletes the specified trusted identity provider from the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String trustedIdProviderName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    /**
     * Deletes the specified trusted identity provider from the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified trusted identity provider from the specified Data Lake Store account.
     *
     * @param resourceGroupName The name of the Azure resource group.
     * @param accountName The name of the Data Lake Store account.
     * @param trustedIdProviderName The name of the trusted identity provider to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;TrustedIdProvider&gt; object if successful.
     */
    public PagedList<TrustedIdProvider> listByAccountNext(final String nextPageLink) {
        ServiceResponse<Page<TrustedIdProvider>> response = listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TrustedIdProvider>(response.body()) {
            @Override
            public Page<TrustedIdProvider> nextPage(String nextPageLink) {
                return listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<TrustedIdProvider>> listByAccountNextAsync(final String nextPageLink, final ServiceFuture<List<TrustedIdProvider>> serviceFuture, final ListOperationCallback<TrustedIdProvider> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAccountNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(String nextPageLink) {
                    return listByAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TrustedIdProvider&gt; object
     */
    public Observable<Page<TrustedIdProvider>> listByAccountNextAsync(final String nextPageLink) {
        return listByAccountNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<TrustedIdProvider>>, Page<TrustedIdProvider>>() {
                @Override
                public Page<TrustedIdProvider> call(ServiceResponse<Page<TrustedIdProvider>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TrustedIdProvider&gt; object
     */
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountNextWithServiceResponseAsync(final String nextPageLink) {
        return listByAccountNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<TrustedIdProvider>>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(ServiceResponse<Page<TrustedIdProvider>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the Data Lake Store trusted identity providers within the specified Data Lake Store account.
     *
    ServiceResponse<PageImpl<TrustedIdProvider>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;TrustedIdProvider&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<TrustedIdProvider>> result = listByAccountNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<TrustedIdProvider>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<TrustedIdProvider>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<TrustedIdProvider>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<TrustedIdProvider>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
