/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.store.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for EncryptionState.
 */
public enum EncryptionState {
    /** Enum value Enabled. */
    ENABLED("Enabled"),

    /** Enum value Disabled. */
    DISABLED("Disabled");

    /** The actual serialized value for a EncryptionState instance. */
    private String value;

    EncryptionState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a EncryptionState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed EncryptionState object, or null if unable to parse.
     */
    @JsonCreator
    public static EncryptionState fromString(String value) {
        EncryptionState[] items = EncryptionState.values();
        for (EncryptionState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
