/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.store.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Metadata information used by account encryption.
 */
public class KeyVaultMetaInfo {
    /**
     * The resource identifier for the user managed Key Vault being used to
     * encrypt.
     */
    @JsonProperty(value = "keyVaultResourceId", required = true)
    private String keyVaultResourceId;

    /**
     * The name of the user managed encryption key.
     */
    @JsonProperty(value = "encryptionKeyName", required = true)
    private String encryptionKeyName;

    /**
     * The version of the user managed encryption key.
     */
    @JsonProperty(value = "encryptionKeyVersion", required = true)
    private String encryptionKeyVersion;

    /**
     * Get the keyVaultResourceId value.
     *
     * @return the keyVaultResourceId value
     */
    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    /**
     * Set the keyVaultResourceId value.
     *
     * @param keyVaultResourceId the keyVaultResourceId value to set
     * @return the KeyVaultMetaInfo object itself.
     */
    public KeyVaultMetaInfo withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    /**
     * Get the encryptionKeyName value.
     *
     * @return the encryptionKeyName value
     */
    public String encryptionKeyName() {
        return this.encryptionKeyName;
    }

    /**
     * Set the encryptionKeyName value.
     *
     * @param encryptionKeyName the encryptionKeyName value to set
     * @return the KeyVaultMetaInfo object itself.
     */
    public KeyVaultMetaInfo withEncryptionKeyName(String encryptionKeyName) {
        this.encryptionKeyName = encryptionKeyName;
        return this;
    }

    /**
     * Get the encryptionKeyVersion value.
     *
     * @return the encryptionKeyVersion value
     */
    public String encryptionKeyVersion() {
        return this.encryptionKeyVersion;
    }

    /**
     * Set the encryptionKeyVersion value.
     *
     * @param encryptionKeyVersion the encryptionKeyVersion value to set
     * @return the KeyVaultMetaInfo object itself.
     */
    public KeyVaultMetaInfo withEncryptionKeyVersion(String encryptionKeyVersion) {
        this.encryptionKeyVersion = encryptionKeyVersion;
        return this;
    }

}
