/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.store.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for TierType.
 */
public enum TierType {
    /** Enum value Consumption. */
    CONSUMPTION("Consumption"),

    /** Enum value Commitment_1TB. */
    COMMITMENT_1TB("Commitment_1TB"),

    /** Enum value Commitment_10TB. */
    COMMITMENT_10TB("Commitment_10TB"),

    /** Enum value Commitment_100TB. */
    COMMITMENT_100TB("Commitment_100TB"),

    /** Enum value Commitment_500TB. */
    COMMITMENT_500TB("Commitment_500TB"),

    /** Enum value Commitment_1PB. */
    COMMITMENT_1PB("Commitment_1PB"),

    /** Enum value Commitment_5PB. */
    COMMITMENT_5PB("Commitment_5PB");

    /** The actual serialized value for a TierType instance. */
    private String value;

    TierType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TierType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed TierType object, or null if unable to parse.
     */
    @JsonCreator
    public static TierType fromString(String value) {
        TierType[] items = TierType.values();
        for (TierType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
