/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.datalake.store.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The parameters used to update a trusted identity provider while updating a
 * Data Lake Store account.
 */
@JsonFlatten
public class UpdateTrustedIdProviderWithAccountParameters {
    /**
     * The unique name of the trusted identity provider to update.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The URL of this trusted identity provider.
     */
    @JsonProperty(value = "properties.idProvider")
    private String idProvider;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the UpdateTrustedIdProviderWithAccountParameters object itself.
     */
    public UpdateTrustedIdProviderWithAccountParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the idProvider value.
     *
     * @return the idProvider value
     */
    public String idProvider() {
        return this.idProvider;
    }

    /**
     * Set the idProvider value.
     *
     * @param idProvider the idProvider value to set
     * @return the UpdateTrustedIdProviderWithAccountParameters object itself.
     */
    public UpdateTrustedIdProviderWithAccountParameters withIdProvider(String idProvider) {
        this.idProvider = idProvider;
        return this;
    }

}
