/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.datalake.store.Accounts;
import com.microsoft.azure.management.datalake.store.DataLakeStoreAccountManagementClient;
import com.microsoft.azure.management.datalake.store.FirewallRules;
import com.microsoft.azure.management.datalake.store.Locations;
import com.microsoft.azure.management.datalake.store.Operations;
import com.microsoft.azure.management.datalake.store.TrustedIdProviders;
import com.microsoft.azure.management.datalake.store.implementation.AccountsImpl;
import com.microsoft.azure.management.datalake.store.implementation.FirewallRulesImpl;
import com.microsoft.azure.management.datalake.store.implementation.LocationsImpl;
import com.microsoft.azure.management.datalake.store.implementation.OperationsImpl;
import com.microsoft.azure.management.datalake.store.implementation.TrustedIdProvidersImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class DataLakeStoreAccountManagementClientImpl
extends AzureServiceClient
implements DataLakeStoreAccountManagementClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Accounts accounts;
    private FirewallRules firewallRules;
    private TrustedIdProviders trustedIdProviders;
    private Operations operations;
    private Locations locations;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String subscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public DataLakeStoreAccountManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public DataLakeStoreAccountManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public DataLakeStoreAccountManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public DataLakeStoreAccountManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Accounts accounts() {
        return this.accounts;
    }

    @Override
    public FirewallRules firewallRules() {
        return this.firewallRules;
    }

    @Override
    public TrustedIdProviders trustedIdProviders() {
        return this.trustedIdProviders;
    }

    @Override
    public Operations operations() {
        return this.operations;
    }

    @Override
    public Locations locations() {
        return this.locations;
    }

    public DataLakeStoreAccountManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public DataLakeStoreAccountManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public DataLakeStoreAccountManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2016-11-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.accounts = new AccountsImpl(this.restClient().retrofit(), this);
        this.firewallRules = new FirewallRulesImpl(this.restClient().retrofit(), this);
        this.trustedIdProviders = new TrustedIdProvidersImpl(this.restClient().retrofit(), this);
        this.operations = new OperationsImpl(this.restClient().retrofit(), this);
        this.locations = new LocationsImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "DataLakeStoreAccountManagementClient", "2016-11-01");
    }
}

